/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.simulcast;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jitsi.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringCompiler {
    private final Map<String, Object> map;
    private static final Pattern p = Pattern.compile("\\{([^\\}]+)\\}");
    private StringBuffer sb;

    public StringCompiler(Map<String, Object> map) {
        this.map = map;
    }

    public StringCompiler c(String s) {
        if (StringUtils.isNullOrEmpty((String)s)) {
            return this;
        }
        Matcher m = p.matcher(s);
        this.sb = new StringBuffer();
        while (m.find()) {
            String key = m.group(1);
            String value = this.getValue(key);
            m.appendReplacement(this.sb, value);
        }
        m.appendTail(this.sb);
        return this;
    }

    public String toString() {
        return this.sb == null ? "" : this.sb.toString();
    }

    private String getValue(String key) {
        if (StringUtils.isNullOrEmpty((String)key)) {
            throw new IllegalArgumentException("key");
        }
        String value = "";
        String[] path = key.split("\\.");
        Object obj = null;
        for (int i = 0; i < path.length; ++i) {
            String identifier = path[i];
            if (i == 0) {
                if (!this.map.containsKey(identifier)) break;
                obj = this.map.get(identifier);
            } else {
                Field f;
                if (obj == null) break;
                Class<?> c = obj.getClass();
                try {
                    f = c.getDeclaredField(identifier);
                }
                catch (NoSuchFieldException e) {
                    break;
                }
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                try {
                    obj = f.get(obj);
                }
                catch (IllegalAccessException e) {
                    break;
                }
            }
            if (i != path.length - 1 || obj == null) continue;
            value = obj.toString();
        }
        return value;
    }
}

