/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.DatagramPacket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RateStatistics;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.util.Logger;
import org.jitsi.util.StringUtils;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.ConferenceSpeechActivity;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.ratecontrol.BitrateController;
import org.jitsi.videobridge.rtcp.BasicBridgeRTCPTerminationStrategy;
import org.jitsi.videobridge.simulcast.SimulcastManager;
import org.json.simple.JSONValue;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoChannel
extends RtpChannel {
    private static final String DISABLE_ABS_SEND_TIME_PNAME = "org.jitsi.videobridge.DISABLE_ABS_SEND_TIME";
    private static final int INCOMING_BITRATE_INTERVAL_MS = 5000;
    private static final Logger logger = Logger.getLogger(VideoChannel.class);
    private boolean adaptiveLastN = false;
    private boolean adaptiveSimulcast = false;
    private BitrateController bitrateController;
    private RateStatistics incomingBitrate = new RateStatistics(5000, 8000.0f);
    private Integer lastN;
    private List<WeakReference<Endpoint>> lastNEndpoints;
    private final ReadWriteLock lastNSyncRoot = new ReentrantReadWriteLock();
    private final SimulcastManager simulcastManager = new SimulcastManager(this);

    public VideoChannel(Content content, String id) throws Exception {
        this(content, id, null);
    }

    public VideoChannel(Content content, String id, String channelBundleId) throws Exception {
        super(content, id, channelBundleId);
    }

    @Override
    protected boolean acceptDataInputStreamDatagramPacket(DatagramPacket p) {
        boolean accept = super.acceptDataInputStreamDatagramPacket(p);
        if (accept) {
            this.incomingBitrate.update(p.getLength(), System.currentTimeMillis());
            this.simulcastManager.acceptedDataInputStreamDatagramPacket(p);
        }
        return accept;
    }

    @Override
    public void describe(ColibriConferenceIQ.ChannelCommon commonIq) {
        ColibriConferenceIQ.Channel iq = (ColibriConferenceIQ.Channel)commonIq;
        super.describe((ColibriConferenceIQ.ChannelCommon)iq);
        iq.setLastN(this.lastN);
    }

    public boolean getAdaptiveLastN() {
        return this.adaptiveLastN;
    }

    public boolean getAdaptiveSimulcast() {
        return this.adaptiveSimulcast;
    }

    private BitrateController getBitrateController() {
        if (this.bitrateController == null) {
            this.bitrateController = new BitrateController(this);
        }
        return this.bitrateController;
    }

    public long getIncomingBitrate() {
        return this.incomingBitrate.getRate(System.currentTimeMillis());
    }

    public int getLastN() {
        Integer lastNInteger = this.lastN;
        return lastNInteger == null ? -1 : lastNInteger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WeakReference<Endpoint>> getLastNEndpoints() {
        Lock readLock = this.lastNSyncRoot.readLock();
        LinkedList<WeakReference<Endpoint>> endpoints = new LinkedList<WeakReference<Endpoint>>();
        readLock.lock();
        try {
            if (this.lastNEndpoints != null) {
                endpoints.addAll(this.lastNEndpoints);
            }
            Object var4_3 = null;
            readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            readLock.unlock();
            throw throwable;
        }
        return endpoints;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        super.propertyChange(ev);
        String propertyName = ev.getPropertyName();
        if (Endpoint.PINNED_ENDPOINT_PROPERTY_NAME.equals(propertyName)) {
            if (this.getLastN() < 1) {
                return;
            }
            List<Endpoint> channelEndpointsToAskForKeyframes = this.speechActivityEndpointsChanged(null, true);
            if (channelEndpointsToAskForKeyframes != null && !channelEndpointsToAskForKeyframes.isEmpty()) {
                this.getContent().askForKeyframes(channelEndpointsToAskForKeyframes);
            }
        }
    }

    public Iterator<Endpoint> getReceivingEndpoints() {
        if (this.getLastN() == -1) {
            int lastIx;
            List<Endpoint> endpoints;
            Content content = this.getContent();
            if (content == null) {
                endpoints = null;
                lastIx = -1;
            } else {
                Conference conference = content.getConference();
                if (conference == null) {
                    endpoints = null;
                    lastIx = -1;
                } else {
                    endpoints = conference.getEndpoints();
                    lastIx = endpoints == null ? -1 : endpoints.size() - 1;
                }
            }
            return new Iterator<Endpoint>(){
                private int ix = 0;

                @Override
                public boolean hasNext() {
                    return this.ix <= lastIx;
                }

                @Override
                public Endpoint next() {
                    if (this.hasNext()) {
                        return (Endpoint)endpoints.get(this.ix++);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        final List<WeakReference<Endpoint>> lastNEndpoints = this.getLastNEndpoints();
        final int lastIx = lastNEndpoints == null ? -1 : lastNEndpoints.size() - 1;
        return new Iterator<Endpoint>(){
            private int ix = 0;

            @Override
            public boolean hasNext() {
                return this.ix <= lastIx;
            }

            @Override
            public Endpoint next() {
                if (this.hasNext()) {
                    return (Endpoint)((WeakReference)lastNEndpoints.get(this.ix++)).get();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int getReceivingEndpointsSize() {
        List<WeakReference<Endpoint>> lastNEndpoints;
        List<Endpoint> endpoints;
        Conference conference;
        Content content;
        int receivingEndpointsSize = this.getLastN() == -1 ? ((content = this.getContent()) == null ? 0 : ((conference = content.getConference()) == null ? 0 : ((endpoints = conference.getEndpoints()) == null ? 0 : endpoints.size()))) : ((lastNEndpoints = this.getLastNEndpoints()) == null ? 0 : lastNEndpoints.size());
        return receivingEndpointsSize;
    }

    public SimulcastManager getSimulcastManager() {
        return this.simulcastManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInLastN(Channel channel) {
        int lastN = this.getLastN();
        if (lastN < 0) {
            return true;
        }
        Endpoint channelEndpoint = channel.getEndpoint();
        if (channelEndpoint == null) {
            return true;
        }
        ConferenceSpeechActivity conferenceSpeechActivity = this.conferenceSpeechActivity;
        if (conferenceSpeechActivity == null) {
            return true;
        }
        if (lastN == 0) {
            return false;
        }
        if (this.lastNEndpoints == null) {
            this.speechActivityEndpointsChanged(null);
        }
        Lock readLock = this.lastNSyncRoot.readLock();
        boolean inLastN = false;
        readLock.lock();
        try {
            if (this.lastNEndpoints != null) {
                Endpoint thisEndpoint = this.getEndpoint();
                Endpoint pinnedEndpoint = this.getPinnedEndpoint();
                int n = 0;
                for (WeakReference<Endpoint> wr : this.lastNEndpoints) {
                    if (pinnedEndpoint == null && n >= lastN || pinnedEndpoint != null && n >= lastN - 1) break;
                    Endpoint e = (Endpoint)wr.get();
                    if (e != null) {
                        if (e.equals(thisEndpoint)) continue;
                        if (e.equals(channelEndpoint)) {
                            inLastN = true;
                            break;
                        }
                    }
                    ++n;
                }
                if (!inLastN && pinnedEndpoint != null) {
                    inLastN = channelEndpoint == pinnedEndpoint;
                }
            }
            Object var14_13 = null;
            readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            readLock.unlock();
            throw throwable;
        }
        return inLastN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lastNEndpointsChanged(List<Endpoint> endpointsEnteringLastN) {
        int lastN = this.getLastN();
        if (lastN < 0) {
            return;
        }
        Endpoint endpoint = this.getEndpoint();
        if (endpoint == null) {
            return;
        }
        Lock readLock = this.lastNSyncRoot.readLock();
        StringBuilder lastNEndpointsStr = new StringBuilder();
        List<Endpoint> effectiveEndpointsEnteringLastN = endpointsEnteringLastN;
        if (effectiveEndpointsEnteringLastN == null) {
            effectiveEndpointsEnteringLastN = new ArrayList<Endpoint>(lastN);
        }
        Endpoint pinnedEndpoint = this.getPinnedEndpoint();
        readLock.lock();
        try {
            if (this.lastNEndpoints != null && !this.lastNEndpoints.isEmpty()) {
                int n = 0;
                boolean foundPinnedEndpoint = pinnedEndpoint == null;
                for (WeakReference<Endpoint> wr : this.lastNEndpoints) {
                    if (n >= lastN) break;
                    Endpoint e = (Endpoint)wr.get();
                    if (!foundPinnedEndpoint) {
                        if (n == lastN - 1) {
                            e = pinnedEndpoint;
                        } else {
                            boolean bl = foundPinnedEndpoint = e == pinnedEndpoint;
                        }
                    }
                    if (e != null) {
                        if (e.equals(endpoint)) continue;
                        if (lastNEndpointsStr.length() != 0) {
                            lastNEndpointsStr.append(',');
                        }
                        lastNEndpointsStr.append('\"');
                        lastNEndpointsStr.append(JSONValue.escape((String)e.getID()));
                        lastNEndpointsStr.append('\"');
                        if (effectiveEndpointsEnteringLastN != endpointsEnteringLastN) {
                            effectiveEndpointsEnteringLastN.add(e);
                        }
                    }
                    ++n;
                }
            }
            Object var14_16 = null;
            readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            readLock.unlock();
            throw throwable;
        }
        StringBuilder msg = new StringBuilder("{\"colibriClass\":\"LastNEndpointsChangeEvent\"");
        msg.append(",\"lastNEndpoints\":[");
        msg.append((CharSequence)lastNEndpointsStr);
        msg.append(']');
        endpointsEnteringLastN = effectiveEndpointsEnteringLastN;
        if (endpointsEnteringLastN != null && !endpointsEnteringLastN.isEmpty()) {
            StringBuilder endpointsEnteringLastNStr = new StringBuilder();
            for (Endpoint e : endpointsEnteringLastN) {
                if (endpointsEnteringLastNStr.length() != 0) {
                    endpointsEnteringLastNStr.append(',');
                }
                endpointsEnteringLastNStr.append('\"');
                endpointsEnteringLastNStr.append(JSONValue.escape((String)e.getID()));
                endpointsEnteringLastNStr.append('\"');
            }
            if (endpointsEnteringLastNStr.length() != 0) {
                msg.append(",\"endpointsEnteringLastN\":[");
                msg.append((CharSequence)endpointsEnteringLastNStr);
                msg.append(']');
            }
        }
        msg.append('}');
        try {
            endpoint.sendMessageOnDataChannel(msg.toString());
        }
        catch (IOException e) {
            logger.error((Object)"Failed to send message on data channel.", (Throwable)e);
        }
    }

    private int lastNIndexOf(List<Endpoint> endpoints, int lastN, Endpoint endpoint) {
        Endpoint thisEndpoint = this.getEndpoint();
        int n = 0;
        for (Endpoint e : endpoints) {
            if (n >= lastN) break;
            if (e.equals(thisEndpoint)) continue;
            if (e.equals(endpoint)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    protected void maybeStartStream() throws IOException {
        super.maybeStartStream();
        MediaStream stream = this.getStream();
        if (stream != null) {
            boolean disableAbsSendTime;
            ConfigurationService cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)this.getBundleContext(), ConfigurationService.class);
            boolean bl = disableAbsSendTime = cfg != null && cfg.getBoolean(DISABLE_ABS_SEND_TIME_PNAME, false);
            if (!disableAbsSendTime) {
                stream.setAbsSendTimeExtensionID(3);
            }
        }
    }

    public void receivedREMB(long remb) {
        BitrateController bc = this.getBitrateController();
        if (bc != null) {
            bc.receivedREMB(remb);
        }
    }

    @Override
    boolean rtpTranslatorWillWrite(boolean data, byte[] buffer, int offset, int length, Channel source) {
        boolean accept = true;
        if (data && source != null && (accept = this.isInLastN(source)) && source instanceof VideoChannel) {
            VideoChannel videoChannel = (VideoChannel)source;
            accept = this.simulcastManager.accept(buffer, offset, length, videoChannel);
        }
        return accept;
    }

    @Override
    void sctpConnectionReady(Endpoint endpoint) {
        super.sctpConnectionReady(endpoint);
        if (endpoint.equals(this.getEndpoint())) {
            this.lastNEndpointsChanged(null);
        }
    }

    @Override
    public void setAdaptiveLastN(boolean adaptiveLastN) {
        this.adaptiveLastN = adaptiveLastN;
        if (adaptiveLastN) {
            this.getContent().setRTCPTerminationStrategyFQN(BasicBridgeRTCPTerminationStrategy.class.getName());
        }
    }

    @Override
    public void setAdaptiveSimulcast(boolean adaptiveSimulcast) {
        this.adaptiveSimulcast = adaptiveSimulcast;
        if (adaptiveSimulcast) {
            this.getContent().setRTCPTerminationStrategyFQN(BasicBridgeRTCPTerminationStrategy.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastN(Integer lastN) {
        if (this.lastN == lastN) {
            return;
        }
        boolean askForKeyframes = this.lastN == null;
        Lock writeLock = this.lastNSyncRoot.writeLock();
        LinkedList<Endpoint> endpointsEnteringLastN = new LinkedList<Endpoint>();
        writeLock.lock();
        try {
            if (this.lastN != null && this.lastN >= 0 && lastN > this.lastN) {
                int n = 0;
                Endpoint thisEndpoint = this.getEndpoint();
                if (this.lastNEndpoints == null) {
                    this.speechActivityEndpointsChanged(null);
                }
                if (this.lastNEndpoints != null) {
                    for (WeakReference<Endpoint> wr : this.lastNEndpoints) {
                        if (n >= lastN) break;
                        Endpoint endpoint = (Endpoint)wr.get();
                        if (endpoint != null && endpoint.equals(thisEndpoint) || ++n <= this.lastN || endpoint == null) continue;
                        endpointsEnteringLastN.add(endpoint);
                    }
                }
                Endpoint pinnedEndpoint = this.getPinnedEndpoint();
                if (endpointsEnteringLastN.size() > 0 && pinnedEndpoint != null) {
                    boolean found = false;
                    for (Endpoint e : endpointsEnteringLastN) {
                        if (e == null || !pinnedEndpoint.getID().equals(e.getID())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        endpointsEnteringLastN.remove(endpointsEnteringLastN.size() - 1);
                        endpointsEnteringLastN.add(pinnedEndpoint);
                    }
                }
            }
            this.lastN = lastN;
            Object var12_12 = null;
            writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            writeLock.unlock();
            throw throwable;
        }
        this.lastNEndpointsChanged(endpointsEnteringLastN);
        if (askForKeyframes) {
            this.getContent().askForKeyframes(new HashSet<Endpoint>(endpointsEnteringLastN));
        }
        this.touch();
    }

    private Endpoint getPinnedEndpoint() {
        Conference conference;
        Content content;
        String pinnedEndpointID;
        Endpoint self = this.getEndpoint();
        return self != null && !StringUtils.isNullOrEmpty((String)(pinnedEndpointID = self.getPinnedEndpointID())) && (content = this.getContent()) != null && (conference = content.getConference()) != null ? conference.getEndpoint(pinnedEndpointID) : null;
    }

    @Override
    List<Endpoint> speechActivityEndpointsChanged(List<Endpoint> endpoints) {
        return this.speechActivityEndpointsChanged(endpoints, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Endpoint> speechActivityEndpointsChanged(List<Endpoint> endpoints, boolean pinnedEndpointChanged) {
        Lock writeLock = this.lastNSyncRoot.writeLock();
        ArrayList<Endpoint> endpointsEnteringLastN = null;
        boolean lastNEndpointsChanged = pinnedEndpointChanged;
        writeLock.lock();
        try {
            int lastN = this.getLastN();
            if (endpoints == null) {
                endpoints = this.conferenceSpeechActivity.getEndpoints();
            }
            if (lastN >= 0) {
                Endpoint thisEndpoint = this.getEndpoint();
                endpointsEnteringLastN = new ArrayList<Endpoint>(lastN);
                for (Endpoint e : endpoints) {
                    if (endpointsEnteringLastN.size() >= lastN) break;
                    if (e.equals(thisEndpoint)) continue;
                    endpointsEnteringLastN.add(e);
                }
                Endpoint pinnedEndpoint = this.getPinnedEndpoint();
                if (endpointsEnteringLastN.size() > 0 && pinnedEndpoint != null) {
                    boolean found = false;
                    for (Endpoint endpoint : endpointsEnteringLastN) {
                        if (endpoint == null || !pinnedEndpoint.getID().equals(endpoint.getID())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        endpointsEnteringLastN.remove(endpointsEnteringLastN.size() - 1);
                        endpointsEnteringLastN.add(pinnedEndpoint);
                    }
                }
                if (this.lastNEndpoints != null && !this.lastNEndpoints.isEmpty()) {
                    int n = 0;
                    for (WeakReference weakReference : this.lastNEndpoints) {
                        if (n >= lastN) break;
                        Endpoint e = (Endpoint)weakReference.get();
                        if (e != null) {
                            if (e.equals(thisEndpoint)) continue;
                            endpointsEnteringLastN.remove(e);
                            if (this.lastNIndexOf(endpoints, lastN, e) < 0) {
                                lastNEndpointsChanged = true;
                            }
                        }
                        ++n;
                    }
                }
            }
            this.lastNEndpoints = new ArrayList<WeakReference<Endpoint>>(endpoints.size());
            for (Endpoint endpoint : endpoints) {
                this.lastNEndpoints.add(new WeakReference<Endpoint>(endpoint));
            }
            Object var14_17 = null;
            writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            writeLock.unlock();
            throw throwable;
        }
        if (endpointsEnteringLastN != null && !endpointsEnteringLastN.isEmpty()) {
            lastNEndpointsChanged = true;
        }
        if (lastNEndpointsChanged) {
            this.lastNEndpointsChanged(endpointsEnteringLastN);
        }
        return endpointsEnteringLastN;
    }
}

