/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.lang.reflect.Constructor;
import java.security.Provider;
import java.util.Random;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jitsi.impl.neomedia.transform.srtp.BlockCipherFactory;
import org.jitsi.impl.neomedia.transform.srtp.OpenSSLBlockCipher;
import org.jitsi.impl.neomedia.transform.srtp.SecurityProviderBlockCipherFactory;
import org.jitsi.util.Logger;

public class AES {
    private static final int BLOCK_SIZE = 16;
    private static final BlockCipherFactory BOUNCYCASTLE_FACTORY = new BouncyCastleBlockCipherFactory();
    private static BlockCipherFactory[] factories;
    private static BlockCipherFactory factory;
    private static long factoryTimestamp;
    private static final Class<?>[] FACTORY_CLASSES;
    public static final long FACTORY_TIMEOUT = 60000L;
    private static final byte[] in;
    private static final byte[] key;
    private static final Logger logger;
    private static final byte[] out;
    private static final Random random;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockCipher createBlockCipher() {
        Class<AES> clazz = AES.class;
        synchronized (AES.class) {
            long now = System.currentTimeMillis();
            BlockCipherFactory factory = AES.factory;
            if (factory != null && now > factoryTimestamp + 60000L) {
                factory = null;
            }
            if (factory == null) {
                try {
                    factory = AES.getBlockCipherFactory();
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    } else {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.warn("Failed to initialize an optimized AES implementation: " + t.getLocalizedMessage());
                    }
                }
                finally {
                    if (factory == null && (factory = AES.factory) == null) {
                        factory = BOUNCYCASTLE_FACTORY;
                    }
                    AES.factory = factory;
                    factoryTimestamp = now;
                }
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            try {
                return factory.createBlockCipher();
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
        }
    }

    private static BlockCipherFactory getBlockCipherFactory() {
        BlockCipherFactory[] factories = AES.factories;
        if (factories == null) {
            AES.factories = factories = new BlockCipherFactory[FACTORY_CLASSES.length];
            int i = 0;
            for (Class<?> clazz : FACTORY_CLASSES) {
                try {
                    if (!BlockCipherFactory.class.isAssignableFrom(clazz)) continue;
                    BlockCipherFactory factory = BouncyCastleBlockCipherFactory.class.equals(clazz) ? BOUNCYCASTLE_FACTORY : (BlockCipherFactory)clazz.newInstance();
                    factories[i++] = factory;
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    if (!(t instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)t;
                }
            }
        }
        Random random = AES.random;
        byte[] key = AES.key;
        byte[] in = AES.in;
        random.nextBytes(key);
        random.nextBytes(in);
        KeyParameter params = new KeyParameter(key);
        int blockSize = 16;
        int inEnd = in.length - blockSize + 1;
        byte[] out = AES.out;
        long minTime = Long.MAX_VALUE;
        BlockCipherFactory minFactory = null;
        for (int f = 0; f < factories.length; ++f) {
            BlockCipherFactory factory = factories[f];
            try {
                BlockCipher cipher = factory.createBlockCipher();
                if (cipher == null) {
                    factories[f] = null;
                    continue;
                }
                cipher.init(true, (CipherParameters)params);
                long startTime = System.nanoTime();
                for (int inOff = 0; inOff < inEnd; inOff += blockSize) {
                    cipher.processBlock(in, inOff, out, 0);
                }
                long endTime = System.nanoTime();
                long time = endTime - startTime;
                if (time >= minTime) continue;
                minTime = time;
                minFactory = factory;
                continue;
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        return minFactory;
    }

    static {
        FACTORY_CLASSES = new Class[]{BouncyCastleBlockCipherFactory.class, OpenSSLBlockCipherFactory.class, SunJCEBlockCipherFactory.class, SunPKCS11BlockCipherFactory.class};
        in = new byte[16384];
        key = new byte[16];
        logger = Logger.getLogger(AES.class);
        out = new byte[16];
        random = new Random();
    }

    public static class SunPKCS11BlockCipherFactory
    extends SecurityProviderBlockCipherFactory {
        private static Provider provider;
        private static boolean useProvider;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static synchronized Provider getProvider() throws Exception {
            Provider provider = SunPKCS11BlockCipherFactory.provider;
            if (provider == null && useProvider) {
                try {
                    Class<?> clazz = Class.forName("sun.security.pkcs11.SunPKCS11");
                    if (Provider.class.isAssignableFrom(clazz)) {
                        Constructor<?> contructor = clazz.getConstructor(String.class);
                        String name = null;
                        Package pkg = AES.class.getPackage();
                        if (pkg != null) {
                            name = pkg.getName();
                        }
                        if (name == null || name.length() == 0) {
                            name = "org.jitsi.impl.neomedia.transform.srtp";
                        }
                        provider = (Provider)contructor.newInstance("--name=" + name + "\\n" + "nssDbMode=noDb\\n" + "attributes=compatibility");
                    }
                }
                finally {
                    if (provider == null) {
                        useProvider = false;
                    } else {
                        SunPKCS11BlockCipherFactory.provider = provider;
                    }
                }
            }
            return provider;
        }

        public SunPKCS11BlockCipherFactory() throws Exception {
            super("AES_128/ECB/NoPadding", SunPKCS11BlockCipherFactory.getProvider());
        }

        static {
            useProvider = true;
        }
    }

    public static class SunJCEBlockCipherFactory
    extends SecurityProviderBlockCipherFactory {
        public SunJCEBlockCipherFactory() {
            super("AES_128/ECB/NoPadding", "SunJCE");
        }
    }

    public static class OpenSSLBlockCipherFactory
    implements BlockCipherFactory {
        @Override
        public BlockCipher createBlockCipher() throws Exception {
            return new OpenSSLBlockCipher(2);
        }
    }

    public static class BouncyCastleBlockCipherFactory
    implements BlockCipherFactory {
        @Override
        public BlockCipher createBlockCipher() throws Exception {
            return new AESFastEngine();
        }
    }
}

