/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.libjitsi;

import java.util.HashMap;
import java.util.Map;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.util.Logger;

public class LibJitsiImpl
extends LibJitsi {
    private static final Logger logger = Logger.getLogger(LibJitsiImpl.class);
    private final Map<String, Object> services = new HashMap<String, Object>();

    public LibJitsiImpl() {
        String key = "org.jitsi.service.audionotifier.AudioNotifierService";
        String value = System.getProperty(key);
        if (value == null || value.length() == 0) {
            System.setProperty(key, "org.jitsi.impl.neomedia.notify.AudioNotifierServiceImpl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T getService(Class<T> serviceClass) {
        Object service;
        Throwable exception;
        String serviceImplClassName;
        String serviceClassName;
        block21: {
            serviceClassName = serviceClass.getName();
            Map<String, Object> map = this.services;
            synchronized (map) {
                if (this.services.containsKey(serviceClassName)) {
                    Object service2 = this.services.get(serviceClassName);
                    return (T)service2;
                }
                this.services.put(serviceClassName, null);
            }
            serviceImplClassName = System.getProperty(serviceClassName);
            boolean suppressClassNotFoundException = false;
            if (serviceImplClassName == null || serviceImplClassName.length() == 0) {
                serviceImplClassName = serviceClassName.replace(".service.", ".impl.").concat("Impl");
                suppressClassNotFoundException = true;
            }
            Class<?> serviceImplClass = null;
            exception = null;
            try {
                serviceImplClass = Class.forName(serviceImplClassName);
            }
            catch (ClassNotFoundException cnfe) {
                if (!suppressClassNotFoundException) {
                    exception = cnfe;
                }
            }
            catch (ExceptionInInitializerError eiie) {
                exception = eiie;
            }
            catch (LinkageError le) {
                exception = le;
            }
            service = null;
            if (serviceImplClass != null && serviceClass.isAssignableFrom(serviceImplClass)) {
                try {
                    Object t = serviceImplClass.newInstance();
                    service = t;
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    exception = t;
                    if (!(t instanceof InterruptedException)) break block21;
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (exception == null) {
            if (service != null) {
                Map<String, Object> map = this.services;
                synchronized (map) {
                    this.services.put(serviceClassName, service);
                }
            }
        } else if (logger.isInfoEnabled()) {
            logger.info("Failed to initialize service implementation " + serviceImplClassName + ". Will continue without it.", exception);
        }
        return (T)service;
    }
}

