/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.colibri;

import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.jinglesdp.JingleUtils;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.packet.IQ;

public class ColibriBuilder {
    private static final Logger logger = Logger.getLogger(ColibriBuilder.class);
    private final ColibriConferenceIQ conferenceState;
    private RequestType requestType = RequestType.UNDEFINED;
    private ColibriConferenceIQ request;
    private boolean hasAnyChannelsToExpire = false;

    public ColibriBuilder(ColibriConferenceIQ conferenceState) {
        this.conferenceState = conferenceState;
        this.reset();
    }

    public void reset() {
        this.requestType = RequestType.UNDEFINED;
        this.request = new ColibriConferenceIQ();
        this.request.setID(this.conferenceState.getID());
    }

    public ColibriBuilder addAllocateChannelsReq(boolean useBundle, String endpointName, boolean peerIsInitiator, List<ContentPacketExtension> contents) {
        this.assertRequestType(RequestType.ALLOCATE_CHANNELS);
        this.request.setType(IQ.Type.GET);
        for (ContentPacketExtension cpe : contents) {
            MediaType mediaType = JingleUtils.getMediaType(cpe);
            String contentName = mediaType.toString();
            ColibriConferenceIQ.Content contentRequest = this.request.getOrCreateContent(contentName);
            ColibriConferenceIQ.ChannelCommon remoteChannelRequest = mediaType != MediaType.DATA ? new ColibriConferenceIQ.Channel() : new ColibriConferenceIQ.SctpConnection();
            remoteChannelRequest.setEndpoint(endpointName);
            remoteChannelRequest.setInitiator(peerIsInitiator);
            if (useBundle) {
                remoteChannelRequest.setChannelBundleId(endpointName);
            }
            if (mediaType != MediaType.DATA) {
                RtpDescriptionPacketExtension rdpe = cpe.getFirstChildOfType(RtpDescriptionPacketExtension.class);
                ColibriConferenceIQ.Channel remoteRtpChannelRequest = (ColibriConferenceIQ.Channel)remoteChannelRequest;
                for (PayloadTypePacketExtension ptpe : rdpe.getPayloadTypes()) {
                    remoteRtpChannelRequest.addPayloadType(ptpe);
                }
            }
            if (!useBundle) {
                this.copyTransportOnChannel(cpe, remoteChannelRequest);
            }
            if (mediaType != MediaType.DATA) {
                contentRequest.addChannel((ColibriConferenceIQ.Channel)remoteChannelRequest);
                continue;
            }
            contentRequest.addSctpConnection((ColibriConferenceIQ.SctpConnection)remoteChannelRequest);
        }
        if (useBundle) {
            ColibriConferenceIQ.ChannelBundle bundle = new ColibriConferenceIQ.ChannelBundle(endpointName);
            ContentPacketExtension firstContent = contents.get(0);
            IceUdpTransportPacketExtension transport = firstContent.getFirstChildOfType(IceUdpTransportPacketExtension.class);
            if (transport != null) {
                try {
                    bundle.setTransport(IceUdpTransportPacketExtension.cloneTransportAndCandidates(transport, true));
                }
                catch (Exception e) {
                    logger.error((Object)"Error cloning transport", (Throwable)e);
                }
            }
            this.request.addChannelBundle(bundle);
        }
        return this;
    }

    public ColibriBuilder addTransportUpdateReq(boolean initiator, Map<String, IceUdpTransportPacketExtension> map, ColibriConferenceIQ localChannelsInfo) {
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            return null;
        }
        this.assertRequestType(RequestType.TRANSPORT_UPDATE);
        this.request.setType(IQ.Type.SET);
        for (Map.Entry<String, IceUdpTransportPacketExtension> e : map.entrySet()) {
            IceUdpTransportPacketExtension transport;
            String contentName = e.getKey();
            ColibriConferenceIQ.ChannelCommon channel = this.getColibriChannel(localChannelsInfo, contentName);
            if (channel == null) continue;
            try {
                transport = IceUdpTransportPacketExtension.cloneTransportAndCandidates(e.getValue(), true);
            }
            catch (Exception ofe) {
                transport = null;
            }
            if (transport == null) continue;
            ColibriConferenceIQ.ChannelCommon channelRequest = channel instanceof ColibriConferenceIQ.Channel ? new ColibriConferenceIQ.Channel() : new ColibriConferenceIQ.SctpConnection();
            channelRequest.setID(channel.getID());
            channelRequest.setEndpoint(channel.getEndpoint());
            channelRequest.setInitiator(initiator);
            channelRequest.setTransport(transport);
            if (channelRequest instanceof ColibriConferenceIQ.Channel) {
                this.request.getOrCreateContent(contentName).addChannel((ColibriConferenceIQ.Channel)channelRequest);
                continue;
            }
            this.request.getOrCreateContent(contentName).addSctpConnection((ColibriConferenceIQ.SctpConnection)channelRequest);
        }
        return this;
    }

    public ColibriBuilder addBundleTransportUpdateReq(boolean initiator, IceUdpTransportPacketExtension transport, ColibriConferenceIQ localChannelsInfo) throws IllegalArgumentException {
        IceUdpTransportPacketExtension transportUpdate;
        ColibriConferenceIQ.ChannelBundle localBundle;
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            return null;
        }
        this.assertRequestType(RequestType.BUNDLE_TRANSPORT_UPDATE);
        this.request.setType(IQ.Type.SET);
        if (localChannelsInfo.getChannelBundles().size() > 0) {
            localBundle = localChannelsInfo.getChannelBundles().get(0);
            if (localChannelsInfo.getChannelBundles().size() > 1) {
                logger.error((Object)"More than one bundle in local channels info !");
            }
        } else {
            throw new IllegalArgumentException("Expected ChannelBundle as not found");
        }
        ColibriConferenceIQ.ChannelBundle bundleUpdate = new ColibriConferenceIQ.ChannelBundle(localBundle.getId());
        try {
            transportUpdate = IceUdpTransportPacketExtension.cloneTransportAndCandidates(transport, true);
        }
        catch (Exception ofe) {
            transportUpdate = null;
        }
        bundleUpdate.setTransport(transportUpdate);
        this.request.addChannelBundle(bundleUpdate);
        return this;
    }

    public ColibriBuilder addExpireChannelsReq(ColibriConferenceIQ channelInfo) {
        ColibriConferenceIQ.Content stateContent;
        if (this.conferenceState == null || StringUtils.isNullOrEmpty((String)this.conferenceState.getID())) {
            return null;
        }
        this.assertRequestType(RequestType.EXPIRE_CHANNELS);
        this.request.setType(IQ.Type.SET);
        for (ColibriConferenceIQ.Content expiredContent : channelInfo.getContents()) {
            stateContent = this.conferenceState.getContent(expiredContent.getName());
            if (stateContent == null) continue;
            ColibriConferenceIQ.Content requestContent = this.request.getOrCreateContent(stateContent.getName());
            for (ColibriConferenceIQ.Channel expiredChannel : expiredContent.getChannels()) {
                ColibriConferenceIQ.Channel stateChannel = stateContent.getChannel(expiredChannel.getID());
                if (stateChannel == null) continue;
                ColibriConferenceIQ.Channel channelRequest = new ColibriConferenceIQ.Channel();
                channelRequest.setExpire(0);
                channelRequest.setID(stateChannel.getID());
                requestContent.addChannel(channelRequest);
                this.hasAnyChannelsToExpire = true;
            }
            for (ColibriConferenceIQ.SctpConnection expiredConn : expiredContent.getSctpConnections()) {
                ColibriConferenceIQ.SctpConnection stateConn = stateContent.getSctpConnection(expiredConn.getID());
                if (stateConn == null) continue;
                ColibriConferenceIQ.SctpConnection connRequest = new ColibriConferenceIQ.SctpConnection();
                connRequest.setID(stateConn.getID());
                connRequest.setExpire(0);
                connRequest.setEndpoint(stateConn.getEndpoint());
                requestContent.addSctpConnection(connRequest);
                this.hasAnyChannelsToExpire = true;
            }
        }
        for (ColibriConferenceIQ.Content requestContent : this.request.getContents()) {
            stateContent = this.conferenceState.getContent(requestContent.getName());
            for (ColibriConferenceIQ.Channel requestChannel : requestContent.getChannels()) {
                ColibriConferenceIQ.Channel stateChannel = stateContent.getChannel(requestChannel.getID());
                stateContent.removeChannel(stateChannel);
            }
            for (ColibriConferenceIQ.SctpConnection requestConn : requestContent.getSctpConnections()) {
                ColibriConferenceIQ.SctpConnection stateConn = stateContent.getSctpConnection(requestConn.getID());
                stateContent.removeSctpConnection(stateConn);
            }
        }
        return this;
    }

    private ColibriConferenceIQ.ChannelCommon getColibriChannel(ColibriConferenceIQ localChannels, String contentName) {
        ColibriConferenceIQ.Content content = localChannels.getContent(contentName);
        if (content == null) {
            return null;
        }
        if (content.getChannelCount() > 0) {
            return content.getChannel(0);
        }
        if (content.getSctpConnections().size() > 0) {
            return content.getSctpConnections().get(0);
        }
        return null;
    }

    public ColibriConferenceIQ getRequest(String videobridge) {
        if (StringUtils.isNullOrEmpty((String)videobridge)) {
            throw new NullPointerException("videobridge");
        }
        this.request.setTo(videobridge);
        if (this.requestType == RequestType.EXPIRE_CHANNELS && !this.hasAnyChannelsToExpire) {
            return null;
        }
        return this.request;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    private void assertRequestType(RequestType currentReqType) {
        if (this.requestType == RequestType.UNDEFINED) {
            this.requestType = currentReqType;
        }
        if (this.requestType != currentReqType) {
            throw new IllegalStateException("Current request type");
        }
    }

    private void copyTransportOnChannel(ContentPacketExtension content, ColibriConferenceIQ.ChannelCommon remoteChannelRequest) {
        IceUdpTransportPacketExtension iceUdpTransportPacketExtension = content.getFirstChildOfType(IceUdpTransportPacketExtension.class);
        try {
            IceUdpTransportPacketExtension iceUdpCopy = IceUdpTransportPacketExtension.cloneTransportAndCandidates(iceUdpTransportPacketExtension, true);
            remoteChannelRequest.setTransport(iceUdpCopy);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public boolean hasAnyChannelsToExpire() {
        return this.hasAnyChannelsToExpire;
    }

    public static enum RequestType {
        ALLOCATE_CHANNELS,
        BUNDLE_TRANSPORT_UPDATE,
        TRANSPORT_UPDATE,
        EXPIRE_CHANNELS,
        UNDEFINED;

    }
}

