/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.util.Enumeration;
import java.util.Vector;
import net.sf.antcontrib.property.Math;
import net.sf.antcontrib.property.Num;
import org.apache.tools.ant.BuildException;

public class Op {
    private String datatype = null;
    Vector nums = new Vector();
    Vector ops = new Vector();
    String operation = null;
    private boolean _strict = false;

    public void setOp(String string) {
        this.operation = string.equals("+") ? "add" : (string.equals("-") ? "subtract" : (string.equals("*") ? "multiply" : (string.equals("/") ? "divide" : (string.equals("%") ? "mod" : string))));
    }

    public void addNum(Num num) {
        this.nums.addElement(num);
    }

    public void setDatatype(String string) {
        if (!(string.equals("int") || string.equals("long") || string.equals("float") || string.equals("double"))) {
            throw new BuildException("Invalid datatype: " + string + ". Must be one of int, long, float, or double.");
        }
        this.datatype = string;
    }

    public void addConfiguredOp(Op op) {
        if (this.datatype != null) {
            op.setDatatype(this.datatype);
        }
        this.ops.addElement(op);
    }

    public void setStrict(boolean bl) {
        this._strict = bl;
    }

    public Num calculate() {
        Object object;
        String[] stringArray;
        if (this.operation == null) {
            throw new BuildException("Operation not specified.");
        }
        Enumeration enumeration = this.ops.elements();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            if (this.datatype != null) {
                stringArray.setDatatype(this.datatype);
            }
            this.nums.addElement(stringArray.calculate());
        }
        stringArray = new String[this.nums.size()];
        enumeration = this.nums.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            object = (Num)enumeration.nextElement();
            if (this.datatype != null) {
                ((Num)object).setDatatype(this.datatype);
            }
            stringArray[n++] = ((Num)object).toString();
        }
        object = new Math(this._strict);
        Number number = ((Math)object).calculate(this.operation, this.datatype, stringArray);
        Num num = new Num();
        num.setValue(number.toString());
        num.setDatatype(this.datatype);
        return num;
    }
}

