/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.soap;

import java.io.ByteArrayInputStream;
import java.net.Socket;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jml.protocol.soap.XmlEntity;
import net.sf.jml.util.Base64;
import net.sf.jml.util.XmlUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SSO {
    private static final Log logger = LogFactory.getLog(SSO.class);
    private String userName = null;
    private String password = null;
    private String policy = null;
    private String nonce = null;
    private String webTicket = null;
    private String contactTicket = null;
    private String oimTicket = null;
    private String spaceTicket = null;
    private String storageTicket = null;
    Pattern redirectPattern = Pattern.compile("<psf:redirectUrl>(.*)</psf:redirectUrl>");

    public SSO(String string, String string2, String string3, String string4) {
        this.userName = string;
        this.password = string2;
        this.policy = string3;
        this.nonce = string4;
    }

    public String getTicket() {
        return this.getTicket(null);
    }

    public String getTicket(String string) {
        try {
            Matcher matcher;
            if (string == null) {
                string = "http://login.live.com/RST.srf";
            }
            URL uRL = new URL(string);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
            stringBuilder.append("<Envelope xmlns=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n");
            stringBuilder.append(" xmlns:wsse=\"http://schemas.xmlsoap.org/ws/2003/06/secext\"\r\n");
            stringBuilder.append(" xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"\r\n");
            stringBuilder.append(" xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2002/12/policy\"\r\n");
            stringBuilder.append(" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"\r\n");
            stringBuilder.append(" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/03/addressing\"\r\n");
            stringBuilder.append(" xmlns:wssc=\"http://schemas.xmlsoap.org/ws/2004/04/sc\"\r\n");
            stringBuilder.append(" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2004/04/trust\">\r\n");
            stringBuilder.append("<Header>\r\n");
            stringBuilder.append("  <ps:AuthInfo xmlns:ps=\"http://schemas.microsoft.com/Passport/SoapServices/PPCRL\" Id=\"PPAuthInfo\">\r\n");
            stringBuilder.append("    <ps:HostingApp>{7108E71A-9926-4FCB-BCC9-9A9D3F32E423}</ps:HostingApp>\r\n");
            stringBuilder.append("    <ps:BinaryVersion>4</ps:BinaryVersion>\r\n");
            stringBuilder.append("    <ps:UIVersion>1</ps:UIVersion>\r\n");
            stringBuilder.append("    <ps:Cookies></ps:Cookies>\r\n");
            stringBuilder.append("    <ps:RequestParams>AQAAAAIAAABsYwQAAAAxMDMz</ps:RequestParams>\r\n");
            stringBuilder.append("  </ps:AuthInfo>\r\n");
            stringBuilder.append("  <wsse:Security>\r\n");
            stringBuilder.append("    <wsse:UsernameToken Id=\"user\">\r\n");
            stringBuilder.append("      <wsse:Username>" + this.userName + "</wsse:Username>\r\n");
            stringBuilder.append("      <wsse:Password>" + this.password + "</wsse:Password>\r\n");
            stringBuilder.append("    </wsse:UsernameToken>\r\n");
            stringBuilder.append("  </wsse:Security>\r\n");
            stringBuilder.append("</Header>\r\n");
            stringBuilder.append("<Body>\r\n");
            stringBuilder.append("<ps:RequestMultipleSecurityTokens xmlns:ps=\"http://schemas.microsoft.com/Passport/SoapServices/PPCRL\" Id=\"RSTS\">\r\n");
            stringBuilder.append("  <wst:RequestSecurityToken Id=\"RST0\">\r\n");
            stringBuilder.append("    <wst:RequestType>http://schemas.xmlsoap.org/ws/2004/04/security/trust/Issue</wst:RequestType>\r\n");
            stringBuilder.append("    <wsp:AppliesTo>\r\n");
            stringBuilder.append("      <wsa:EndpointReference>\r\n");
            stringBuilder.append("        <wsa:Address>http://Passport.NET/tb</wsa:Address>\r\n");
            stringBuilder.append("      </wsa:EndpointReference>\r\n");
            stringBuilder.append("    </wsp:AppliesTo>\r\n");
            stringBuilder.append("  </wst:RequestSecurityToken>\r\n");
            stringBuilder.append("<wst:RequestSecurityToken Id=\"RST1\">\r\n");
            stringBuilder.append("  <wst:RequestType>http://schemas.xmlsoap.org/ws/2004/04/security/trust/Issue</wst:RequestType>\r\n");
            stringBuilder.append("  <wsp:AppliesTo>\r\n");
            stringBuilder.append("    <wsa:EndpointReference>\r\n");
            stringBuilder.append("      <wsa:Address>messengerclear.live.com</wsa:Address>\r\n");
            stringBuilder.append("     </wsa:EndpointReference>\r\n");
            stringBuilder.append("    </wsp:AppliesTo>\r\n");
            stringBuilder.append("   <wsse:PolicyReference URI=\"" + this.policy + "\"></wsse:PolicyReference>\r\n");
            stringBuilder.append("</wst:RequestSecurityToken>\r\n");
            stringBuilder.append("<wst:RequestSecurityToken Id=\"RST2\">\r\n");
            stringBuilder.append("  <wst:RequestType>http://schemas.xmlsoap.org/ws/2004/04/security/trust/Issue</wst:RequestType>\r\n");
            stringBuilder.append("  <wsp:AppliesTo>\r\n");
            stringBuilder.append("   <wsa:EndpointReference>\r\n");
            stringBuilder.append("     <wsa:Address>messenger.msn.com</wsa:Address>\r\n");
            stringBuilder.append("   </wsa:EndpointReference>\r\n");
            stringBuilder.append("  </wsp:AppliesTo>\r\n");
            stringBuilder.append("  <wsse:PolicyReference URI=\"?id=507\"></wsse:PolicyReference>\r\n");
            stringBuilder.append("</wst:RequestSecurityToken>\r\n");
            stringBuilder.append("<wst:RequestSecurityToken Id=\"RST3\">\r\n");
            stringBuilder.append("  <wst:RequestType>http://schemas.xmlsoap.org/ws/2004/04/security/trust/Issue</wst:RequestType>\r\n");
            stringBuilder.append("   <wsp:AppliesTo>\r\n");
            stringBuilder.append("        <wsa:EndpointReference>\r\n");
            stringBuilder.append("          <wsa:Address>contacts.msn.com</wsa:Address>\r\n");
            stringBuilder.append("        </wsa:EndpointReference>\r\n");
            stringBuilder.append("      </wsp:AppliesTo>\r\n");
            stringBuilder.append("      <wsse:PolicyReference URI=\"MBI\"></wsse:PolicyReference>\r\n");
            stringBuilder.append("    </wst:RequestSecurityToken>\r\n");
            stringBuilder.append("    <wst:RequestSecurityToken Id=\"RST4\">\r\n");
            stringBuilder.append("      <wst:RequestType>http://schemas.xmlsoap.org/ws/2004/04/security/trust/Issue</wst:RequestType>\r\n");
            stringBuilder.append("      <wsp:AppliesTo>\r\n");
            stringBuilder.append("        <wsa:EndpointReference>\r\n");
            stringBuilder.append("          <wsa:Address>messengersecure.live.com</wsa:Address>\r\n");
            stringBuilder.append("        </wsa:EndpointReference>\r\n");
            stringBuilder.append("      </wsp:AppliesTo>\r\n");
            stringBuilder.append("      <wsse:PolicyReference URI=\"MBI_SSL\"></wsse:PolicyReference>\r\n");
            stringBuilder.append("    </wst:RequestSecurityToken>\r\n");
            stringBuilder.append("    <wst:RequestSecurityToken Id=\"RST5\">\r\n");
            stringBuilder.append("      <wst:RequestType>http://schemas.xmlsoap.org/ws/2004/04/security/trust/Issue</wst:RequestType>\r\n");
            stringBuilder.append("      <wsp:AppliesTo>\r\n");
            stringBuilder.append("        <wsa:EndpointReference>\r\n");
            stringBuilder.append("          <wsa:Address>spaces.live.com</wsa:Address>\r\n");
            stringBuilder.append("        </wsa:EndpointReference>\r\n");
            stringBuilder.append("      </wsp:AppliesTo>\r\n");
            stringBuilder.append("      <wsse:PolicyReference URI=\"MBI\"></wsse:PolicyReference>\r\n");
            stringBuilder.append("    </wst:RequestSecurityToken>\r\n");
            stringBuilder.append("    <wst:RequestSecurityToken Id=\"RST6\">\r\n");
            stringBuilder.append("      <wst:RequestType>http://schemas.xmlsoap.org/ws/2004/04/security/trust/Issue</wst:RequestType>\r\n");
            stringBuilder.append("      <wsp:AppliesTo>\r\n");
            stringBuilder.append("        <wsa:EndpointReference>\r\n");
            stringBuilder.append("          <wsa:Address>storage.msn.com</wsa:Address>\r\n");
            stringBuilder.append("        </wsa:EndpointReference>\r\n");
            stringBuilder.append("      </wsp:AppliesTo>\r\n");
            stringBuilder.append("      <wsse:PolicyReference URI=\"MBI\"></wsse:PolicyReference>\r\n");
            stringBuilder.append("    </wst:RequestSecurityToken>\r\n");
            stringBuilder.append("  </ps:RequestMultipleSecurityTokens>\r\n");
            stringBuilder.append("</Body>\r\n");
            stringBuilder.append("</Envelope>");
            DefaultHttpClientConnection defaultHttpClientConnection = new DefaultHttpClientConnection();
            BasicHttpParams basicHttpParams = null;
            BasicHttpProcessor basicHttpProcessor = null;
            basicHttpParams = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)basicHttpParams, (String)"UTF-8");
            HttpProtocolParams.setUserAgent((HttpParams)basicHttpParams, (String)"MSN Explorer/9.0 (MSN 8.0; TmstmpExt)");
            HttpProtocolParams.setUseExpectContinue((HttpParams)basicHttpParams, (boolean)false);
            basicHttpProcessor = new BasicHttpProcessor();
            basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestContent());
            basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestTargetHost());
            basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestConnControl());
            basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestUserAgent());
            basicHttpProcessor.addInterceptor((HttpRequestInterceptor)new RequestExpectContinue());
            HttpRequestExecutor httpRequestExecutor = new HttpRequestExecutor();
            BasicHttpContext basicHttpContext = new BasicHttpContext(null);
            HttpHost httpHost = new HttpHost(uRL.getHost(), 443, "https");
            basicHttpContext.setAttribute("http.connection", (Object)defaultHttpClientConnection);
            basicHttpContext.setAttribute("http.target_host", (Object)httpHost);
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Socket socket = sSLSocketFactory.createSocket(httpHost.getHostName(), httpHost.getPort());
            defaultHttpClientConnection.bind(socket, (HttpParams)basicHttpParams);
            BasicHttpEntityEnclosingRequest basicHttpEntityEnclosingRequest = new BasicHttpEntityEnclosingRequest("POST", uRL.getPath());
            basicHttpEntityEnclosingRequest.setEntity((HttpEntity)new XmlEntity(stringBuilder.toString()));
            basicHttpContext.setAttribute("http.request", (Object)basicHttpEntityEnclosingRequest);
            basicHttpEntityEnclosingRequest.setParams((HttpParams)basicHttpParams);
            basicHttpEntityEnclosingRequest.addHeader("Host", uRL.getHost());
            httpRequestExecutor.preProcess((HttpRequest)basicHttpEntityEnclosingRequest, (HttpProcessor)basicHttpProcessor, (HttpContext)basicHttpContext);
            HttpResponse httpResponse = httpRequestExecutor.execute((HttpRequest)basicHttpEntityEnclosingRequest, (HttpClientConnection)defaultHttpClientConnection, (HttpContext)basicHttpContext);
            httpRequestExecutor.postProcess(httpResponse, (HttpProcessor)basicHttpProcessor, (HttpContext)basicHttpContext);
            logger.debug((Object)httpResponse.getStatusLine());
            String string2 = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            logger.debug((Object)(httpResponse.getStatusLine() + " / " + string2));
            defaultHttpClientConnection.close();
            int n = httpResponse.getStatusLine().getStatusCode();
            if (n > -1 && n != 200) {
                if (string2.indexOf("<faultcode>psf:Redirect</faultcode>") == -1) {
                    logger.error((Object)("*** Can't get passport ticket! http code = " + n));
                    return null;
                }
                Matcher matcher2 = this.redirectPattern.matcher(string2);
                if (!matcher2.find()) {
                    logger.error((Object)"*** redirect, but can't get redirect URL!");
                    return null;
                }
                String string3 = matcher2.group(1);
                if (string.equals(string3)) {
                    logger.error((Object)"*** redirect, but redirect to same URL!");
                    return null;
                }
                return this.getTicket(string3);
            }
            if (string2.indexOf("<faultcode>psf:Redirect</faultcode>") != -1 && (matcher = this.redirectPattern.matcher(string2)).find()) {
                String string4 = matcher.group(1);
                if (string.equals(string4)) {
                    logger.error((Object)"*** redirect, but redirect to same URL!");
                    return null;
                }
                return this.getTicket(string4);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                logger.error((Object)"something wrong!", (Throwable)new Exception());
                return null;
            }
            return this.getTicketFromResponseXml(string2);
        }
        catch (Exception exception) {
            logger.error((Object)"Login error ", (Throwable)exception);
            return null;
        }
    }

    private String getTicketFromResponseXml(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            Document document = documentBuilder.parse(byteArrayInputStream);
            Element element = XmlUtils.locateElement(document.getDocumentElement(), "wsse:BinarySecurityToken", "Id", "Compact1");
            Element element2 = (Element)element.getParentNode().getParentNode();
            Element element3 = XmlUtils.findChild(element2, "wst:RequestedProofToken");
            Element element4 = XmlUtils.findChild(element3, "wst:BinarySecret");
            String string2 = XmlUtils.getText(element);
            String string3 = XmlUtils.getText(element4).trim();
            Element element5 = XmlUtils.locateElement(document.getDocumentElement(), "wsse:BinarySecurityToken", "Id", "PPToken2");
            this.webTicket = XmlUtils.getText(element5);
            Element element6 = XmlUtils.locateElement(document.getDocumentElement(), "wsse:BinarySecurityToken", "Id", "Compact3");
            this.contactTicket = XmlUtils.getText(element6);
            Element element7 = XmlUtils.locateElement(document.getDocumentElement(), "wsse:BinarySecurityToken", "Id", "Compact4");
            this.oimTicket = XmlUtils.getText(element7);
            Element element8 = XmlUtils.locateElement(document.getDocumentElement(), "wsse:BinarySecurityToken", "Id", "Compact5");
            this.spaceTicket = XmlUtils.getText(element8);
            Element element9 = XmlUtils.locateElement(document.getDocumentElement(), "wsse:BinarySecurityToken", "Id", "Compact6");
            this.storageTicket = XmlUtils.getText(element9);
            SSOticket sSOticket = new SSOticket(string3, this.nonce.trim());
            return string2.trim() + " " + sSOticket.value;
        }
        catch (Exception exception) {
            logger.error((Object)"Login error ", (Throwable)exception);
            return null;
        }
    }

    public String getContactTicket() {
        return this.contactTicket;
    }

    public String getOimTicket() {
        return this.oimTicket;
    }

    public String getSpaceTicket() {
        return this.spaceTicket;
    }

    public String getStorageTicket() {
        return this.storageTicket;
    }

    public String getWebTicket() {
        return this.webTicket;
    }

    static class SSOticket {
        public String value;
        private byte[] beginning = new byte[28];

        public SSOticket(String string, String string2) throws Exception {
            this.beginning[0] = 28;
            this.beginning[1] = 0;
            this.beginning[2] = 0;
            this.beginning[3] = 0;
            this.beginning[4] = 1;
            this.beginning[5] = 0;
            this.beginning[6] = 0;
            this.beginning[7] = 0;
            this.beginning[8] = 3;
            this.beginning[9] = 102;
            this.beginning[10] = 0;
            this.beginning[11] = 0;
            this.beginning[12] = 4;
            this.beginning[13] = -128;
            this.beginning[14] = 0;
            this.beginning[15] = 0;
            this.beginning[16] = 8;
            this.beginning[17] = 0;
            this.beginning[18] = 0;
            this.beginning[19] = 0;
            this.beginning[20] = 20;
            this.beginning[21] = 0;
            this.beginning[22] = 0;
            this.beginning[23] = 0;
            this.beginning[24] = 72;
            this.beginning[25] = 0;
            this.beginning[26] = 0;
            this.beginning[27] = 0;
            byte[] byArray = Base64.decode(string);
            byte[] byArray2 = this.deriveKey(byArray, "WS-SecureConversationSESSION KEY HASH");
            byte[] byArray3 = this.deriveKey(byArray, "WS-SecureConversationSESSION KEY ENCRYPTION");
            byte[] byArray4 = this.HMAC(byArray2, string2.getBytes());
            byte[] byArray5 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            byte[] byArray6 = new byte[]{8, 8, 8, 8, 8, 8, 8, 8};
            byte[] byArray7 = this.DES3(byArray3, this.combine(string2.getBytes(), byArray6), byArray5);
            String string3 = new String(this.beginning, "ISO-8859-1") + new String(byArray5, "ISO-8859-1") + new String(byArray4, "ISO-8859-1") + new String(byArray7, "ISO-8859-1");
            this.value = new String(Base64.encode(string3.getBytes("ISO-8859-1")));
        }

        private byte[] combine(byte[] byArray, byte[] byArray2) {
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            return byArray3;
        }

        private byte[] deriveKey(byte[] byArray, String string) throws Exception {
            byte[] byArray2 = this.HMAC(byArray, string.getBytes());
            byte[] byArray3 = this.HMAC(byArray, this.combine(byArray2, string.getBytes()));
            byte[] byArray4 = this.HMAC(byArray, byArray2);
            byte[] byArray5 = this.HMAC(byArray, this.combine(byArray4, string.getBytes()));
            byte[] byArray6 = new byte[]{byArray5[0], byArray5[1], byArray5[2], byArray5[3]};
            return this.combine(byArray3, byArray6);
        }

        private byte[] HMAC(byte[] byArray, byte[] byArray2) {
            try {
                Mac mac = Mac.getInstance("HmacSHA1");
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HmacSHA1");
                mac.init(secretKeySpec);
                return mac.doFinal(byArray2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
            }
            catch (InvalidKeyException invalidKeyException) {
                invalidKeyException.printStackTrace();
            }
            return null;
        }

        private byte[] DES3(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            try {
                Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "DESede");
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
                cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
                return cipher.doFinal(byArray2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }
}

