/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import org.hsqldb.Database;
import org.hsqldb.HsqlName;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TextCache;
import org.hsqldb.Trace;

class TextTable
extends Table {
    private String readRoots = "";
    private String emptyRoots = "";
    private String dataSource = "";
    private String firstLine = "";
    private boolean isReversed = false;

    TextTable(Database database, HsqlName hsqlName, int n, Session session) throws SQLException {
        super(database, hsqlName, n, session);
    }

    private void openCache(String string, boolean bl, boolean bl2) throws SQLException {
        if (!this.dataSource.equals("")) {
            this.dDatabase.logger.closeTextCache(this.tableName.name);
        }
        this.cCache = null;
        int n = this.getIndexCount();
        int n2 = 0;
        while (n2 < n) {
            this.getIndex(n2).setRoot(null);
            ++n2;
        }
        if (string != null && !string.equals("")) {
            try {
                this.cCache = this.dDatabase.logger.openTextCache(this.tableName.name, string, bl2, bl);
                int n3 = this.cCache.getFreePos();
                String string2 = this.readRoots;
                if (n3 <= TextCache.NL.length()) {
                    string2 = this.emptyRoots;
                }
                string2 = string2 + n3;
                super.setIndexRoots(string2);
            }
            catch (SQLException sQLException) {
                if (!this.dataSource.equals(string) || bl != this.isReversed || bl2 != this.isReadOnly) {
                    this.openCache(this.dataSource, this.isReversed, this.isReadOnly);
                } else {
                    if (this.cCache != null) {
                        this.cCache.closeFile();
                    }
                    this.dataSource = "";
                    this.isReversed = false;
                }
                throw sQLException;
            }
        }
        if (string == null) {
            string = "";
        }
        this.dataSource = string;
        this.isReversed = bl && !string.equals("");
    }

    boolean equals(String string, Session session) {
        boolean bl = super.equals(string, session);
        if (bl && this.isReversed) {
            try {
                this.openCache(this.dataSource, this.isReversed, this.isReadOnly);
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return bl;
    }

    boolean equals(String string) {
        boolean bl = super.equals(string);
        if (bl && this.isReversed) {
            try {
                this.openCache(this.dataSource, this.isReversed, this.isReadOnly);
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return bl;
    }

    protected void setDataSource(String string, boolean bl, Session session) throws SQLException {
        if (this.isTemp) {
            Trace.check(session.getId() == this.ownerSession.getId(), 33);
        } else {
            session.checkAdmin();
        }
        if (bl || bl != this.isReversed || !this.dataSource.equals(string)) {
            this.openCache(string, bl, this.isReadOnly);
        }
        if (this.isReversed) {
            this.isReadOnly = true;
        }
    }

    protected String getDataSource() throws SQLException {
        return this.dataSource;
    }

    protected boolean isDescDataSource() throws SQLException {
        return this.isReversed;
    }

    void setDataReadOnly(boolean bl) throws SQLException {
        if (this.isReversed && bl) {
            throw Trace.error(32);
        }
        this.openCache(this.dataSource, this.isReversed, bl);
        this.isReadOnly = bl;
    }

    String getIndexRoots() throws SQLException {
        Trace.doAssert(this.isCached, "Table.getIndexRootData");
        return this.readRoots + "0";
    }

    void setIndexRoots(String string) throws SQLException {
        Trace.check(this.isCached, 22);
    }

    boolean isIndexCached() {
        return false;
    }

    protected Table duplicate() throws SQLException {
        return new TextTable(this.dDatabase, this.tableName, this.tableType, this.ownerSession);
    }

    void indexRow(Row row, boolean bl) throws SQLException {
        if (bl) {
            super.indexRow(row, true);
        } else {
            Node node = row.getNextNode(null);
            Node node2 = this.getPrimaryIndex().insertUncached(node);
            if (node2 == node) {
                node = row.getNextNode(node);
                int n = 1;
                while (node != null) {
                    this.getIndex(n).insertUncached(node);
                    node = row.getNextNode(node);
                    ++n;
                }
            } else {
                row.setPrimaryNode(node2);
            }
        }
    }

    void checkUpdate(int[] nArray, Result result, Result result2) throws SQLException {
        Trace.check(!this.dataSource.equals(""), 48);
        super.checkUpdate(nArray, result, result2);
    }

    void insert(Object[] objectArray, Session session) throws SQLException {
        Trace.check(!this.dataSource.equals(""), 48);
        super.insert(objectArray, session);
    }

    void delete(Object[] objectArray, Session session) throws SQLException {
        Trace.check(!this.dataSource.equals(""), 48);
        super.delete(objectArray, session);
    }

    Index createIndexPrivate(int[] nArray, HsqlName hsqlName, boolean bl) throws SQLException {
        this.readRoots = this.readRoots + "0 ";
        this.emptyRoots = this.emptyRoots + "-1 ";
        return super.createIndexPrivate(nArray, hsqlName, bl);
    }

    void createPrimaryKey(String string, int[] nArray) throws SQLException {
        if (!(nArray == null || nArray.length == 1 && this.getColumn((int)nArray[0]).columnName.name.equals(""))) {
            throw Trace.error(24);
        }
        super.createPrimaryKey(null, nArray);
    }
}

