/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import org.hsqldb.Column;
import org.hsqldb.HsqlName;
import org.hsqldb.Node;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class Index {
    static final int MEMORY_INDEX = 0;
    static final int DISK_INDEX = 1;
    static final int POINTER_INDEX = 2;
    private HsqlName indexName;
    private Table table;
    private int iFields;
    private int[] iColumn;
    private int[] iType;
    private boolean bUnique;
    private int visibleColumns;
    private Node root;
    private int iColumn_0;
    private int iType_0;
    private static int iNeedCleanUp;
    private boolean cleanUp;

    Index(HsqlName hsqlName, Table table, int[] nArray, int[] nArray2, boolean bl, int n) {
        this.indexName = hsqlName;
        this.table = table;
        this.cleanUp = table.isCached();
        this.iFields = nArray.length;
        this.iColumn = nArray;
        this.iType = nArray2;
        this.bUnique = bl;
        this.iColumn_0 = this.iColumn[0];
        this.iType_0 = this.iType[0];
        this.visibleColumns = n;
    }

    Node getRoot() {
        return this.root;
    }

    void setRoot(Node node) {
        this.root = node;
    }

    HsqlName getName() {
        return this.indexName;
    }

    void setName(String string, boolean bl) {
        this.indexName.rename(string, bl);
    }

    int getVisibleColumns() {
        return this.visibleColumns;
    }

    boolean isUnique() {
        return this.bUnique;
    }

    int[] getColumns() {
        return this.iColumn;
    }

    boolean isEquivalent(Index index) {
        if (this.bUnique == index.bUnique && this.iColumn.length == index.iColumn.length) {
            int n = 0;
            while (n < this.iColumn.length) {
                if (this.iColumn[n] != index.iColumn[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    void insert(Node node) throws SQLException {
        Node node2;
        Object[] objectArray = node.getData();
        Node node3 = node2 = this.root;
        boolean bl = true;
        int n = -1;
        while (true) {
            if (node2 == null) {
                if (node3 == null) {
                    this.root = node;
                    return;
                }
                this.set(node3, bl, node);
                break;
            }
            Object[] objectArray2 = node2.getData();
            if (objectArray == objectArray2) {
                this.set(node3, bl, node);
                break;
            }
            n = this.compareRow(objectArray, objectArray2);
            if (n == 0) {
                throw Trace.error(9, this.indexName.name);
            }
            bl = n < 0;
            node3 = node2;
            node2 = this.child(node3, bl);
        }
        this.balance(node3, bl);
    }

    Node insertUncached(Node node) throws SQLException {
        Node node2;
        Object[] objectArray = node.getData();
        Node node3 = node2 = this.root;
        boolean bl = true;
        int n = -1;
        while (true) {
            if (node2 == null) {
                if (node3 == null) {
                    this.root = node;
                    return node;
                }
                break;
            }
            node3 = node2;
            n = this.compareRow(objectArray, node3.getData());
            if (n == 0) {
                return node2;
            }
            bl = n < 0;
            node2 = bl ? node3.getLeft() : node3.getRightPointer();
        }
        this.set(node3, bl, node);
        this.balance(node3, bl);
        return node;
    }

    private void balance(Node node, boolean bl) throws SQLException {
        while (true) {
            int n = bl ? 1 : -1;
            switch (node.getBalance() * n) {
                case 1: {
                    node.setBalance(0);
                    return;
                }
                case 0: {
                    node.setBalance(-n);
                    break;
                }
                case -1: {
                    Node node2 = this.child(node, bl);
                    if (node2.getBalance() == -n) {
                        this.replace(node, node2);
                        this.set(node, bl, this.child(node2, !bl));
                        this.set(node2, !bl, node);
                        node.setBalance(0);
                        node2.setBalance(0);
                    } else {
                        Node node3 = this.child(node2, !bl);
                        this.replace(node, node3);
                        this.set(node2, !bl, this.child(node3, bl));
                        this.set(node3, bl, node2);
                        this.set(node, bl, this.child(node3, !bl));
                        this.set(node3, !bl, node);
                        int n2 = node3.getBalance();
                        node.setBalance(n2 == -n ? n : 0);
                        node2.setBalance(n2 == n ? -n : 0);
                        node3.setBalance(0);
                    }
                    return;
                }
            }
            if (node.equals(this.root)) {
                return;
            }
            bl = node.from();
            node = node.getParent();
        }
    }

    void delete(Object[] objectArray, boolean bl) throws SQLException {
        Node node;
        int n;
        Node node2;
        Node node3 = this.search(objectArray);
        if (node3 == null) {
            return;
        }
        if (node3.getLeft() == null) {
            node2 = node3.getRight();
        } else if (node3.getRight() == null) {
            node2 = node3.getLeft();
        } else {
            Node node4 = node3;
            node3 = node3.getLeft();
            while (node3.getRight() != null) {
                node3 = node3.getRight();
            }
            node2 = node3.getLeft();
            n = node3.getBalance();
            node3.setBalance(node4.getBalance());
            node4.setBalance(n);
            node = node3.getParent();
            Node node5 = node4.getParent();
            if (node4 == this.root) {
                this.root = node3;
            }
            node3.setParent(node5);
            if (node5 != null) {
                if (node5.getRight().equals(node4)) {
                    node5.setRight(node3);
                } else {
                    node5.setLeft(node3);
                }
            }
            if (node == node4) {
                node4.setParent(node3);
                if (node4.getLeft().equals(node3)) {
                    node3.setLeft(node4);
                    node3.setRight(node4.getRight());
                } else {
                    node3.setRight(node4);
                    node3.setLeft(node4.getLeft());
                }
            } else {
                node4.setParent(node);
                node.setRight(node4);
                node3.setRight(node4.getRight());
                node3.setLeft(node4.getLeft());
            }
            node3.getRight().setParent(node3);
            node3.getLeft().setParent(node3);
            node4.setLeft(node2);
            if (node2 != null) {
                node2.setParent(node4);
            }
            node4.setRight(null);
            node3 = node4;
        }
        boolean bl2 = node3.from();
        this.replace(node3, node2);
        node2 = node3.getParent();
        if (bl) {
            node3.getRow().delete();
        }
        node3.delete();
        while (node2 != null) {
            node3 = node2;
            n = bl2 ? 1 : -1;
            switch (node3.getBalance() * n) {
                case -1: {
                    node3.setBalance(0);
                    break;
                }
                case 0: {
                    node3.setBalance(n);
                    return;
                }
                case 1: {
                    node = this.child(node3, !bl2);
                    int n2 = node.getBalance();
                    if (n2 * n >= 0) {
                        this.replace(node3, node);
                        this.set(node3, !bl2, this.child(node, bl2));
                        this.set(node, bl2, node3);
                        if (n2 == 0) {
                            node3.setBalance(n);
                            node.setBalance(-n);
                            return;
                        }
                        node3.setBalance(0);
                        node.setBalance(0);
                        node3 = node;
                        break;
                    }
                    Node node6 = this.child(node, bl2);
                    this.replace(node3, node6);
                    n2 = node6.getBalance();
                    this.set(node, bl2, this.child(node6, !bl2));
                    this.set(node6, !bl2, node);
                    this.set(node3, !bl2, this.child(node6, bl2));
                    this.set(node6, bl2, node3);
                    node3.setBalance(n2 == n ? -n : 0);
                    node.setBalance(n2 == -n ? n : 0);
                    node6.setBalance(0);
                    node3 = node6;
                }
            }
            bl2 = node3.from();
            node2 = node3.getParent();
        }
    }

    /*
     * Unable to fully structure code
     */
    Node findSimple(Object[] var1_1, boolean var2_2) throws SQLException {
        var3_3 = this.root;
        var5_4 = null;
        if (var1_1[0] != null) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            var6_6 = this.comparePartialRowNonUnique(var1_1, var3_3.getData());
            if (var6_6 == 0) {
                if (!var2_2) {
                    var5_4 = var3_3;
                    break;
                }
                if (var5_4 == var3_3) break;
                var5_4 = var3_3;
                var4_5 = var3_3.getLeft();
            } else {
                var4_5 = var6_6 > 0 ? var3_3.getRight() : var3_3.getLeft();
            }
            if (var4_5 == null) break;
            var3_3 = var4_5;
lbl17:
            // 2 sources

            ** while (var3_3 != null)
        }
lbl18:
        // 4 sources

        return var5_4;
    }

    Node find(Object[] objectArray) throws SQLException {
        Node node = this.root;
        while (node != null) {
            int n = this.compareRowNonUnique(objectArray, node.getData());
            if (n == 0) {
                return node;
            }
            Node node2 = n > 0 ? node.getRight() : node.getLeft();
            if (node2 == null) {
                return null;
            }
            node = node2;
        }
        return null;
    }

    Node findFirst(Object object, int n) throws SQLException {
        Trace.doAssert(n == 23 || n == 21 || n == 22, "Index.findFirst");
        Node node = this.root;
        int n2 = 1;
        if (n == 23) {
            n2 = 0;
        }
        while (node != null) {
            Node node2;
            boolean bl;
            boolean bl2 = bl = this.compareValue(object, node.getData()[this.iColumn_0]) >= n2;
            if (bl) {
                node2 = node.getRight();
                if (node2 == null) break;
                node = node2;
                continue;
            }
            node2 = node.getLeft();
            if (node2 == null) break;
            node = node2;
        }
        while (node != null && this.compareValue(object, node.getData()[this.iColumn_0]) >= n2) {
            node = this.next(node);
        }
        return node;
    }

    Node first() throws SQLException {
        Node node;
        Node node2 = node = this.root;
        while (node2 != null) {
            node = node2;
            node2 = node.getLeft();
        }
        return node;
    }

    Node next(Node node) throws SQLException {
        Node node2;
        if (node == null) {
            return null;
        }
        if (this.cleanUp && (++iNeedCleanUp & 0x7F) == 0) {
            this.table.cleanUp();
        }
        if ((node2 = node.getRight()) != null) {
            node = node2;
            Node node3 = node.getLeft();
            while (node3 != null) {
                node = node3;
                node3 = node.getLeft();
            }
            return node;
        }
        Node node4 = node;
        node = node.getParent();
        while (node != null && node4.equals(node.getRight())) {
            node4 = node;
            node = node.getParent();
        }
        return node;
    }

    private Node child(Node node, boolean bl) throws SQLException {
        return bl ? node.getLeft() : node.getRight();
    }

    private void replace(Node node, Node node2) throws SQLException {
        if (node.equals(this.root)) {
            this.root = node2;
            if (node2 != null) {
                node2.setParent(null);
            }
        } else {
            this.set(node.getParent(), node.from(), node2);
        }
    }

    private void set(Node node, boolean bl, Node node2) throws SQLException {
        if (bl) {
            node.setLeft(node2);
        } else {
            node.setRight(node2);
        }
        if (node2 != null) {
            node2.setParent(node);
        }
    }

    private Node search(Object[] objectArray) throws SQLException {
        Node node = this.root;
        while (node != null) {
            int n = this.compareRow(objectArray, node.getData());
            if (n == 0) {
                return node;
            }
            node = n < 0 ? node.getLeft() : node.getRight();
        }
        return null;
    }

    int comparePartialRowNonUnique(Object[] objectArray, Object[] objectArray2) throws SQLException {
        int n = Column.compare(objectArray[0], objectArray2[this.iColumn_0], this.iType_0);
        if (n != 0) {
            return n;
        }
        int n2 = this.visibleColumns;
        int n3 = 1;
        while (n3 < objectArray.length && n3 < n2) {
            Object object = objectArray[n3];
            if (object != null && (n = Column.compare(object, objectArray2[this.iColumn[n3]], this.iType[n3])) != 0) {
                return n;
            }
            ++n3;
        }
        return 0;
    }

    private int compareRowNonUnique(Object[] objectArray, Object[] objectArray2) throws SQLException {
        int n = Column.compare(objectArray[this.iColumn_0], objectArray2[this.iColumn_0], this.iType_0);
        if (n != 0) {
            return n;
        }
        int n2 = this.visibleColumns;
        int n3 = 1;
        while (n3 < n2) {
            n = Column.compare(objectArray[this.iColumn[n3]], objectArray2[this.iColumn[n3]], this.iType[n3]);
            if (n != 0) {
                return n;
            }
            ++n3;
        }
        return 0;
    }

    private int compareRow(Object[] objectArray, Object[] objectArray2) throws SQLException {
        int n = Column.compare(objectArray[this.iColumn_0], objectArray2[this.iColumn_0], this.iType_0);
        if (n != 0) {
            return n;
        }
        int n2 = 1;
        while (n2 < this.iFields) {
            n = Column.compare(objectArray[this.iColumn[n2]], objectArray2[this.iColumn[n2]], this.iType[n2]);
            if (n != 0) {
                return n;
            }
            ++n2;
        }
        return 0;
    }

    private int compareValue(Object object, Object object2) throws SQLException {
        return Column.compare(object, object2, this.iType_0);
    }
}

