/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

class DatabaseFile
extends RandomAccessFile {
    protected byte[] in;
    protected long pos;
    protected int index;
    protected int count;

    DatabaseFile(String string, String string2, int n) throws FileNotFoundException, IOException {
        super(string, string2);
        this.in = new byte[n];
    }

    protected void realSeek(long l) throws IOException {
        super.seek(l);
    }

    public void seek(long l) throws IOException {
        super.seek(l);
        this.pos = l;
        this.count = 0;
        this.index = 0;
    }

    public void readSeek(long l) throws IOException {
        if (this.in == null) {
            this.seek(l);
        } else if (l != this.pos) {
            this.index += (int)(l - this.pos);
            if (this.index < 0 || this.index > this.count) {
                this.seek(l);
            } else {
                this.pos = l;
            }
        }
    }

    public int read() throws IOException {
        if (this.in == null) {
            return super.read();
        }
        if (this.index == this.count) {
            this.index = 0;
            this.count = super.read(this.in);
            if (this.count == -1) {
                this.count = 0;
            }
        }
        if (this.index == this.count) {
            return -1;
        }
        ++this.pos;
        return this.in[this.index++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        int n = 0;
        while (n < byArray.length) {
            int n2 = this.read();
            if (n2 == -1) {
                return -1;
            }
            byArray[n] = (byte)n2;
            ++n;
        }
        return n;
    }

    public int readInteger() throws IOException {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = this.read();
            if (n3 == -1) {
                throw new EOFException();
            }
            n <<= 8;
            n += n3 & 0xFF;
            ++n2;
        }
        return n;
    }

    public void write(byte[] byArray) throws IOException {
        this.count = 0;
        this.index = 0;
        this.pos += (long)byArray.length;
        super.write(byArray);
    }

    public void writeInteger(int n) throws IOException {
        this.count = 0;
        this.index = 0;
        this.pos += 4L;
        this.writeInt(n);
    }

    public void close() throws IOException {
        super.close();
        this.in = null;
    }
}

