/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class HeadFilter
extends BaseParamFilterReader
implements ChainableReader {
    private static final String LINES_KEY = "lines";
    private long linesRead = 0L;
    private long lines = 10L;

    public HeadFilter() {
    }

    public HeadFilter(Reader in) {
        super(in);
    }

    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int ch = -1;
        if (this.linesRead < this.lines && (ch = this.in.read()) == 10) {
            ++this.linesRead;
        }
        return ch;
    }

    public final void setLines(long lines) {
        this.lines = lines;
    }

    private final long getLines() {
        return this.lines;
    }

    public final Reader chain(Reader rdr) {
        HeadFilter newFilter = new HeadFilter(rdr);
        newFilter.setLines(this.getLines());
        newFilter.setInitialized(true);
        return newFilter;
    }

    private final void initialize() {
        Parameter[] params = this.getParameters();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                if (LINES_KEY.equals(params[i].getName())) {
                    this.lines = new Long(params[i].getValue());
                    break;
                }
                ++i;
            }
        }
    }
}

