/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.utils.collections.CircularQueue;
import weblogic.xml.babel.adapters.SAXAdapter;
import weblogic.xml.babel.baseparser.SAXElementFactory;
import weblogic.xml.babel.stream.XMLInputStreamBase;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.NullEvent;
import weblogic.xml.stream.util.XMLPullReader;
import weblogic.xml.stream.util.XMLPullReaderBase;

public class SAXInputStream
extends XMLInputStreamBase {
    private XMLPullReader inputStream;
    private SAXAdapter adapter;

    public SAXInputStream(XMLPullReader xMLPullReader) {
        this.open = false;
        this.children = new ArrayList();
        this.inputStream = xMLPullReader;
        this.adapter = new SAXAdapter(this);
        this.inputStream.setContentHandler((ContentHandler)this.adapter);
        this.inputStream.setDTDHandler((DTDHandler)this.adapter);
        this.inputStream.setErrorHandler((ErrorHandler)this.adapter);
    }

    public void open(InputSource inputSource) throws XMLStreamException {
        this.elementQ = new CircularQueue(8);
        try {
            this.inputStream.parseSomeSetup(inputSource);
            this.inputStream.parseSome();
            this.open = true;
        }
        catch (IOException iOException) {
            throw new XMLStreamException("Unable to instantiate the stream, the error was: " + iOException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException("Unable to instantiate the stream, the error was: " + sAXException.getMessage());
        }
    }

    public boolean parseSome() throws XMLStreamException {
        boolean bl = true;
        do {
            try {
                bl = this.inputStream.parseSome();
            }
            catch (SAXException sAXException) {
                throw new XMLStreamException((Throwable)sAXException);
            }
        } while (bl && this.elementQ.isEmpty());
        return bl;
    }

    public boolean hasNext() throws XMLStreamException {
        if (!this.open) {
            return false;
        }
        if (!this.elementQ.isEmpty()) {
            return true;
        }
        if (this.inputStream != null && this.parseSome()) {
            return true;
        }
        return !this.elementQ.isEmpty();
    }

    public XMLEvent peek() throws XMLStreamException {
        if (this.hasNext()) {
            return (XMLEvent)this.elementQ.peek();
        }
        return new NullEvent();
    }

    public void close() throws XMLStreamException {
        super.close();
    }

    public static void main(String[] stringArray) throws Exception {
        SAXInputStream sAXInputStream = new SAXInputStream((XMLPullReader)new XMLPullReaderBase());
        sAXInputStream.open(SAXElementFactory.createInputSource(stringArray[0]));
        while (sAXInputStream.hasNext()) {
            XMLEvent xMLEvent = sAXInputStream.next();
            System.out.print("EVENT: " + xMLEvent.getTypeAsString() + " [");
            System.out.print(xMLEvent);
            System.out.println("]");
        }
    }
}

