/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.dtd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.Element;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.dtd.Choice;
import weblogic.xml.babel.dtd.Name;
import weblogic.xml.babel.dtd.OneOrMore;
import weblogic.xml.babel.dtd.Option;
import weblogic.xml.babel.dtd.Sequence;
import weblogic.xml.babel.dtd.WildCard;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.Token;

public class ContentParticle
extends Element {
    protected char delimeter = (char)32;
    ArrayList children = new ArrayList();

    public void setDelimeter(char c) {
        this.delimeter = c;
    }

    public void parse(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        Sequence sequence = new Sequence();
        Choice choice = new Choice();
        Name name = new Name();
        ContentParticle contentParticle = new ContentParticle();
        switch (baseParser.getCurrentToken().tokenType) {
            case 0: 
            case 18: {
                name.parse(baseParser);
                contentParticle = name;
                break;
            }
            case 56: {
                choice.parse(baseParser);
                contentParticle = choice;
                break;
            }
            case 57: {
                sequence.parse(baseParser);
                contentParticle = sequence;
                break;
            }
            default: {
                throw new ParseException("Expected a NAME, CHOICE, or SEQUENCE", baseParser.getLine(), baseParser.getCurrentToken());
            }
        }
        this.parseOperator(baseParser, contentParticle);
    }

    public void parseOperator(BaseParser baseParser, ContentParticle contentParticle) throws IOException, ScannerException, ParseException {
        switch (baseParser.getCurrentToken().tokenType) {
            case 32: {
                Option option = new Option();
                option.parse(baseParser);
                option.addChild(contentParticle);
                this.addChild(option);
                break;
            }
            case 33: {
                WildCard wildCard = new WildCard();
                wildCard.parse(baseParser);
                wildCard.addChild(contentParticle);
                this.addChild(wildCard);
                break;
            }
            case 34: {
                OneOrMore oneOrMore = new OneOrMore();
                oneOrMore.parse(baseParser);
                oneOrMore.addChild(contentParticle);
                this.addChild(oneOrMore);
                break;
            }
            default: {
                this.addChild(contentParticle);
            }
        }
    }

    public void getChildren(ArrayList arrayList) {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            ContentParticle contentParticle = (ContentParticle)iterator.next();
            contentParticle.getChildren(arrayList);
        }
    }

    protected void init() {
        super.init();
        this.children.clear();
    }

    public void addChild(ContentParticle contentParticle) {
        this.children.add(contentParticle);
    }

    public Iterator getIterator() {
        return this.children.iterator();
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public static boolean isStarter(Token token) {
        switch (token.tokenType) {
            case 0: 
            case 18: 
            case 56: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    public ContentParticle getFirstChild() {
        return (ContentParticle)this.children.get(0);
    }

    public String toString() {
        String string = "";
        if (this.children.size() == 1) {
            string = this.getFirstChild().toString();
        } else {
            ContentParticle contentParticle;
            string = "( ";
            Iterator iterator = this.children.iterator();
            if (iterator.hasNext()) {
                contentParticle = (ContentParticle)iterator.next();
                string = string + contentParticle.toString();
            }
            while (iterator.hasNext()) {
                contentParticle = (ContentParticle)iterator.next();
                string = string + " " + this.delimeter + " " + contentParticle.toString();
            }
            string = string + " )";
        }
        return string;
    }
}

