/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.logging.Loggerf;
import com.voxeo.utils.IRetryTemplate;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryTemplate
implements IRetryTemplate {
    private Loggerf log = Loggerf.getLogger(RetryTemplate.class);
    private int maxAttempts = -1;
    private long sleepBetweenRetriesMS = -1L;
    private Class<? extends Throwable>[] exceptions = new Class[]{Exception.class};
    private boolean logExceptionOnRetry = true;
    private boolean traverseExceptionChains = true;

    @Override
    public <T> T execute(Callable<T> callable) throws Exception {
        try {
            int retries = -1;
            this.log.debug("Engaging retry logic with max retries %d and exception list %s", this.maxAttempts, this.exceptions);
            T result = null;
            Throwable lastExceptionThrown = null;
            block7: while (!(++retries >= this.maxAttempts && this.maxAttempts != -1 || Thread.currentThread().isInterrupted())) {
                lastExceptionThrown = null;
                try {
                    result = callable.call();
                    break;
                }
                catch (Throwable throwable) {
                    for (Class<? extends Throwable> clazz : this.exceptions) {
                        if (!this.triggersRetry(throwable, clazz)) continue;
                        String msg = "Encountered exception %s, which is in the list, performing retry #%d";
                        if (this.logExceptionOnRetry) {
                            this.log.error("Encountered exception %s, which is in the list, performing retry #%d", throwable, retries + 1, throwable);
                        } else {
                            this.log.debug("Encountered exception %s, which is in the list, performing retry #%d", throwable, retries + 1);
                        }
                        lastExceptionThrown = throwable;
                        if (this.sleepBetweenRetriesMS == -1L) continue block7;
                        try {
                            Thread.sleep(this.sleepBetweenRetriesMS);
                            continue block7;
                        }
                        catch (InterruptedException e) {
                            this.log.info("Interrupted while sleeping", e);
                            throw e;
                        }
                    }
                    this.log.error("Encountered exception %s, which is NOT in the list, not retrying", throwable);
                    throw throwable;
                }
            }
            if (lastExceptionThrown != null) {
                throw lastExceptionThrown;
            }
            return result;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private boolean triggersRetry(Throwable throwable, Class<?> clazz) {
        boolean result = false;
        do {
            if (clazz.isAssignableFrom(throwable.getClass())) {
                result = true;
                break;
            }
            throwable = throwable.getCause();
        } while (this.traverseExceptionChains && throwable != null);
        return result;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public long getSleepBetweenRetriesMS() {
        return this.sleepBetweenRetriesMS;
    }

    public void setSleepBetweenRetriesMS(long sleepBetweenRetriesMS) {
        this.sleepBetweenRetriesMS = sleepBetweenRetriesMS;
    }

    public Class<? extends Throwable>[] getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(Class<? extends Throwable>[] exceptions) {
        this.exceptions = exceptions;
    }

    public boolean isLogExceptionOnRetry() {
        return this.logExceptionOnRetry;
    }

    public void setLogExceptionOnRetry(boolean logExceptionOnRetry) {
        this.logExceptionOnRetry = logExceptionOnRetry;
    }

    public boolean isTraverseExceptionChains() {
        return this.traverseExceptionChains;
    }

    public void setTraverseExceptionChains(boolean traverseExceptionChains) {
        this.traverseExceptionChains = traverseExceptionChains;
    }
}

