/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.DelegatingSocket;
import org.ice4j.socket.MultiplexedSocket;
import org.ice4j.socket.MultiplexingDatagramSocket;
import org.ice4j.socket.TCPInputStream;
import org.ice4j.socket.TCPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexingSocket
extends DelegatingSocket {
    private static final Logger logger = Logger.getLogger(MultiplexingSocket.class.getName());
    private static final MultiplexedSocket[] NO_SOCKETS = new MultiplexedSocket[0];
    private boolean inReceive = false;
    private final List<DatagramPacket> received = new LinkedList<DatagramPacket>();
    private final TCPInputStream inputStream = new TCPInputStream();
    private TCPOutputStream outputStream = null;
    private final Object receiveSyncRoot = new Object();
    private MultiplexedSocket[] sockets = NO_SOCKETS;
    private final Object socketsSyncRoot = new Object();
    private int soTimeout = 0;

    public MultiplexingSocket() {
        try {
            this.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            logger.info("Cannot SO_TCPNODELAY");
        }
    }

    public MultiplexingSocket(InetAddress address, int port) throws IOException {
        super(address, port);
        try {
            this.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            logger.info("Cannot SO_TCPNODELAY");
        }
    }

    public MultiplexingSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        super(address, port, localAddr, localPort);
        try {
            this.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            logger.info("Cannot SO_TCPNODELAY");
        }
    }

    public MultiplexingSocket(Proxy proxy) {
        super(proxy);
        try {
            this.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            logger.info("Cannot SO_TCPNODELAY");
        }
    }

    protected MultiplexingSocket(SocketImpl impl) throws SocketException {
        super(impl);
        try {
            this.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            logger.info("Cannot SO_TCPNODELAY");
        }
    }

    public MultiplexingSocket(String host, int port) throws UnknownHostException, IOException {
        super(host, port);
        try {
            this.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            logger.info("Cannot SO_TCPNODELAY");
        }
    }

    public MultiplexingSocket(String host, int port, InetAddress localAddr, int localPort) {
        super(host, port, localAddr, localPort);
        try {
            this.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            logger.info("Cannot SO_TCPNODELAY");
        }
    }

    public MultiplexingSocket(Socket socket) {
        super(socket);
        try {
            this.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            logger.info("Cannot SO_TCPNODELAY");
        }
    }

    @Override
    public void receive(DatagramPacket p) throws SocketTimeoutException, IOException {
        try {
            this.setOriginalInputStream(super.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.receive(this.received, p, this.soTimeout);
    }

    void receive(MultiplexedSocket multiplexed, DatagramPacket p) throws SocketTimeoutException, IOException {
        try {
            this.setOriginalInputStream(super.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.receive(multiplexed.received, p, multiplexed.getSoTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive(List<DatagramPacket> received, DatagramPacket p, int timeout) throws SocketTimeoutException, IOException {
        long start = System.currentTimeMillis();
        DatagramPacket r = null;
        do {
            boolean doReceive;
            long now = System.currentTimeMillis();
            if (timeout > 0 && now - start >= (long)timeout) {
                throw new SocketTimeoutException("Socket timeout");
            }
            Object object = this.receiveSyncRoot;
            synchronized (object) {
                block29: {
                    if (received.isEmpty()) {
                        if (this.inReceive) {
                            doReceive = false;
                            try {
                                if (timeout > 0) {
                                    this.receiveSyncRoot.wait((long)timeout - (now - start));
                                } else {
                                    this.receiveSyncRoot.wait();
                                }
                                break block29;
                            }
                            catch (InterruptedException iex) {
                                continue;
                            }
                        }
                        doReceive = true;
                        this.inReceive = true;
                    } else {
                        doReceive = false;
                        r = received.remove(0);
                    }
                }
            }
            if (!doReceive) continue;
            try {
                super.receive(p);
                object = this.receiveSyncRoot;
                synchronized (object) {
                    Object object2 = this.socketsSyncRoot;
                    synchronized (object2) {
                        boolean accepted = false;
                        for (MultiplexedSocket socket : this.sockets) {
                            if (!socket.getFilter().accept(p)) continue;
                            socket.received.add(MultiplexingDatagramSocket.clone(p));
                            accepted = true;
                        }
                        if (!accepted) {
                            this.addReceivedPacket(p);
                        }
                    }
                }
            }
            finally {
                object = this.receiveSyncRoot;
                synchronized (object) {
                    this.inReceive = false;
                    this.receiveSyncRoot.notify();
                }
            }
        } while (r == null);
        MultiplexingDatagramSocket.copy(r, p);
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(MultiplexedSocket multiplexed) {
        Object object = this.socketsSyncRoot;
        synchronized (object) {
            int socketCount = this.sockets.length;
            for (int i = 0; i < socketCount; ++i) {
                if (!this.sockets[i].equals(multiplexed)) continue;
                if (socketCount == 1) {
                    this.sockets = NO_SOCKETS;
                    break;
                }
                MultiplexedSocket[] newSockets = new MultiplexedSocket[socketCount - 1];
                System.arraycopy(this.sockets, 0, newSockets, 0, i);
                System.arraycopy(this.sockets, i + 1, newSockets, i, newSockets.length - i);
                this.sockets = newSockets;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiplexedSocket getSocket(DatagramPacketFilter filter) throws SocketException {
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        Object object = this.socketsSyncRoot;
        synchronized (object) {
            for (MultiplexedSocket socket : this.sockets) {
                if (!filter.equals(socket.getFilter())) continue;
                return socket;
            }
            MultiplexedSocket socket = new MultiplexedSocket(this, filter);
            int socketCount = this.sockets.length;
            if (socketCount == 0) {
                this.sockets = new MultiplexedSocket[]{socket};
            } else {
                MultiplexedSocket[] newSockets = new MultiplexedSocket[socketCount + 1];
                System.arraycopy(this.sockets, 0, newSockets, 0, socketCount);
                newSockets[socketCount] = socket;
                this.sockets = newSockets;
            }
            return socket;
        }
    }

    public void addReceivedPacket(DatagramPacket p) {
        byte[] data = p.getData();
        int len = p.getLength();
        byte[] newData = new byte[len];
        System.arraycopy(data, p.getOffset(), newData, 0, len);
        this.inputStream.addPacket(newData);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new TCPOutputStream(super.getOutputStream());
        }
        return this.outputStream;
    }

    public InputStream getOriginalInputStream() throws IOException {
        return super.getInputStream();
    }

    public OutputStream getOriginalOutputStream() throws IOException {
        return super.getOutputStream();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        super.setSoTimeout(timeout);
        this.soTimeout = timeout;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }
}

