/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public final class SerializableCollection
implements IdentifiedDataSerializable,
Iterable<Data> {
    private Collection<Data> collection;

    public SerializableCollection() {
    }

    public SerializableCollection(Collection<Data> collection) {
        this.collection = collection;
    }

    public Collection<Data> getCollection() {
        return this.collection;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        if (this.collection == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(this.collection.size());
        for (Data data : this.collection) {
            data.writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        if (size == -1) {
            return;
        }
        this.collection = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            this.collection.add(IOUtil.readData(in));
        }
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 7;
    }

    @Override
    public Iterator<Data> iterator() {
        final Iterator<Data> iterator = this.collection == null ? null : this.collection.iterator();
        return new Iterator<Data>(){

            @Override
            public boolean hasNext() {
                return iterator == null ? false : iterator.hasNext();
            }

            @Override
            public Data next() {
                return (Data)iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public int size() {
        return this.collection == null ? 0 : this.collection.size();
    }
}

