/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.PartitionService;
import java.net.InetSocketAddress;
import java.util.Hashtable;

@ManagedDescription(value="HazelcastInstance.PartitionServiceMBean")
public class PartitionServiceMBean
extends HazelcastMBean<PartitionService> {
    private final HazelcastInstanceImpl hazelcastInstance;

    public PartitionServiceMBean(HazelcastInstanceImpl hazelcastInstance, PartitionService partitionService, ManagementService service) {
        super(partitionService, service);
        this.hazelcastInstance = hazelcastInstance;
        Hashtable<String, String> properties = new Hashtable<String, String>(3);
        properties.put("type", ManagementService.quote("HazelcastInstance.PartitionServiceMBean"));
        properties.put("name", ManagementService.quote(hazelcastInstance.getName()));
        properties.put("instance", ManagementService.quote(hazelcastInstance.getName()));
        this.setObjectName(properties);
    }

    @ManagedAnnotation(value="partitionCount")
    @ManagedDescription(value="Number of partitions")
    public int getPartitionCount() {
        return ((PartitionService)this.managedObject).getPartitionCount();
    }

    @ManagedAnnotation(value="activePartitionCount")
    @ManagedDescription(value="Number of active partitions")
    public int getActivePartitionCount() {
        InetSocketAddress address = this.hazelcastInstance.getCluster().getLocalMember().getInetSocketAddress();
        return ((PartitionService)this.managedObject).getMemberPartitions(new Address(address)).size();
    }
}

