/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.tx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.Permission;
import java.util.Map;
import org.mortbay.io.tx.Transformer;
import org.mortbay.log.Log;
import org.mortbay.util.IO;

public class Handler
extends URLStreamHandler {
    public static final String PROTOCOL = "tx";

    public static void register() {
        String handlers = System.getProperty("java.protocol.handler.pkgs");
        if (handlers != null && handlers.indexOf("org.mortbay.io") >= 0) {
            return;
        }
        handlers = (handlers == null ? "" : handlers + "|") + "org.mortbay.io";
        Log.info((String)("set -Djava.protocol.handler.pkgs=" + handlers));
        System.setProperty("java.protocol.handler.pkgs", handlers);
        try {
            new URL("tx:file:/");
        }
        catch (MalformedURLException e) {
            Log.ignore((Throwable)e);
            Log.info((String)"setURLStreanHandlerFactory for org.mortbay.io.tx.Handler");
            URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){
                Handler _handler = new Handler();

                public URLStreamHandler createURLStreamHandler(String protocol) {
                    if (Handler.PROTOCOL.equals(protocol)) {
                        return this._handler;
                    }
                    return null;
                }
            });
        }
    }

    protected URLConnection openConnection(URL url) throws IOException {
        String s = url.toString();
        if (!s.startsWith("tx:")) {
            throw new IllegalArgumentException();
        }
        return new BufferedURLConnection(url, new URL(s.substring(3)));
    }

    class BufferedURLConnection
    extends URLConnection {
        URLConnection _connection;
        protected byte[] _content;
        URL _src;

        public BufferedURLConnection(URL url, URL src) {
            super(url);
            this._src = src;
            try {
                if (this._connection == null) {
                    this._connection = this._src.openConnection();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void addRequestProperty(String key, String value) {
            this._connection.addRequestProperty(key, value);
        }

        public void connect() throws IOException {
            this._connection.connect();
        }

        private void doContent() {
            try {
                InputStream in;
                if (this._content == null && (in = this._connection.getInputStream()) != null) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IO.copy((InputStream)in, (OutputStream)out);
                    this._content = out.toByteArray();
                    this._content = this.transform(this._src, this._content);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected byte[] transform(URL src, byte[] content) {
            ClassLoader loader;
            for (loader = Thread.currentThread().getContextClassLoader(); loader != null && !(loader instanceof Transformer); loader = loader.getParent()) {
            }
            if (loader != null) {
                content = ((Transformer)((Object)loader)).transform(src, content);
            }
            return content;
        }

        public boolean equals(Object obj) {
            return this._connection.equals(obj);
        }

        public boolean getAllowUserInteraction() {
            return this._connection.getAllowUserInteraction();
        }

        public int getConnectTimeout() {
            return 0;
        }

        public Object getContent() throws IOException {
            return this._connection.getContent();
        }

        public Object getContent(Class[] classes) throws IOException {
            return this._connection.getContent(classes);
        }

        public String getContentEncoding() {
            return this._connection.getContentEncoding();
        }

        public int getContentLength() {
            this.doContent();
            if (this._content != null) {
                return this._content.length;
            }
            return this._connection.getContentLength();
        }

        public String getContentType() {
            return this._connection.getContentType();
        }

        public long getDate() {
            return this._connection.getDate();
        }

        public boolean getDefaultUseCaches() {
            return this._connection.getDefaultUseCaches();
        }

        public boolean getDoInput() {
            return this._connection.getDoInput();
        }

        public boolean getDoOutput() {
            return this._connection.getDoOutput();
        }

        public long getExpiration() {
            return this._connection.getExpiration();
        }

        public String getHeaderField(int n) {
            return this._connection.getHeaderField(n);
        }

        public String getHeaderField(String name) {
            return this._connection.getHeaderField(name);
        }

        public long getHeaderFieldDate(String name, long Default) {
            return this._connection.getHeaderFieldDate(name, Default);
        }

        public int getHeaderFieldInt(String name, int Default) {
            return this._connection.getHeaderFieldInt(name, Default);
        }

        public String getHeaderFieldKey(int n) {
            return this._connection.getHeaderFieldKey(n);
        }

        public Map getHeaderFields() {
            return this._connection.getHeaderFields();
        }

        public long getIfModifiedSince() {
            return this._connection.getIfModifiedSince();
        }

        public InputStream getInputStream() throws IOException {
            this.doContent();
            if (this._content == null) {
                throw new IOException("no content");
            }
            return new ByteArrayInputStream(this._content);
        }

        public long getLastModified() {
            return this._connection.getLastModified();
        }

        public OutputStream getOutputStream() throws IOException {
            return this._connection.getOutputStream();
        }

        public Permission getPermission() throws IOException {
            return this._connection.getPermission();
        }

        public int getReadTimeout() {
            return 0;
        }

        public Map getRequestProperties() {
            return this._connection.getRequestProperties();
        }

        public String getRequestProperty(String key) {
            return this._connection.getRequestProperty(key);
        }

        public URL getURL() {
            return this._connection.getURL();
        }

        public boolean getUseCaches() {
            return this._connection.getUseCaches();
        }

        public int hashCode() {
            return this._connection.hashCode();
        }

        public void setAllowUserInteraction(boolean allowuserinteraction) {
            this._connection.setAllowUserInteraction(allowuserinteraction);
        }

        public void setConnectTimeout(int timeout) {
        }

        public void setDefaultUseCaches(boolean defaultusecaches) {
            this._connection.setDefaultUseCaches(defaultusecaches);
        }

        public void setDoInput(boolean doinput) {
            this._connection.setDoInput(doinput);
        }

        public void setDoOutput(boolean dooutput) {
            this._connection.setDoOutput(dooutput);
        }

        public void setIfModifiedSince(long ifmodifiedsince) {
            this._connection.setIfModifiedSince(ifmodifiedsince);
        }

        public void setReadTimeout(int timeout) {
        }

        public void setRequestProperty(String key, String value) {
            this._connection.setRequestProperty(key, value);
        }

        public void setUseCaches(boolean usecaches) {
            this._connection.setUseCaches(usecaches);
        }

        public String toString() {
            return "tx:" + this._connection.toString();
        }
    }
}

