/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.media;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallEvent;
import net.java.sip.communicator.service.protocol.event.CallListener;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.recording.Recorder;

public abstract class AbstractOperationSetBasicTelephony<T extends ProtocolProviderService>
implements OperationSetBasicTelephony<T> {
    private static final Logger logger = Logger.getLogger(AbstractOperationSetBasicTelephony.class);
    private final List<CallListener> callListeners = new ArrayList<CallListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallListener(CallListener listener) {
        List<CallListener> list = this.callListeners;
        synchronized (list) {
            if (!this.callListeners.contains(listener)) {
                this.callListeners.add(listener);
            }
        }
    }

    public Call createCall(Contact callee) throws OperationFailedException {
        return this.createCall(callee, null);
    }

    public Call createCall(Contact callee, CallConference conference) throws OperationFailedException {
        try {
            return this.createCall(callee.getAddress(), conference);
        }
        catch (ParseException pe) {
            throw new OperationFailedException(pe.getMessage(), 11, (Throwable)pe);
        }
    }

    public Call createCall(String uri) throws OperationFailedException, ParseException {
        return this.createCall(uri, null);
    }

    public Call createCall(ConferenceDescription cd, ChatRoom chatRoom) throws OperationFailedException {
        throw new OperationFailedException("Creating a call with a ConferenceDescription is not implemented in " + this.getClass(), 4);
    }

    public void fireCallEvent(int eventID, Call sourceCall) {
        this.fireCallEvent(eventID, sourceCall, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCallEvent(int eventID, Call sourceCall, Map<MediaType, MediaDirection> mediaDirections) {
        ArrayList<CallListener> listeners;
        CallEvent event = new CallEvent(sourceCall, eventID, mediaDirections);
        List<CallListener> list = this.callListeners;
        synchronized (list) {
            listeners = new ArrayList<CallListener>(this.callListeners);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a CallEvent to " + listeners.size() + " listeners. The event is: " + event));
        }
        for (CallListener listener : listeners) {
            switch (eventID) {
                case 1: {
                    listener.outgoingCallCreated(event);
                    break;
                }
                case 2: {
                    listener.incomingCallReceived(event);
                    break;
                }
                case 3: {
                    listener.callEnded(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallListener(CallListener listener) {
        List<CallListener> list = this.callListeners;
        synchronized (list) {
            this.callListeners.remove(listener);
        }
    }

    public void setMute(Call call, boolean mute) {
        if (call instanceof MediaAwareCall) {
            ((MediaAwareCall)call).setMute(mute);
        }
    }

    public Recorder createRecorder(Call call) throws OperationFailedException {
        return call instanceof MediaAwareCall ? ((MediaAwareCall)call).createRecorder() : null;
    }
}

