/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;

public class AbsSendTimeEngine
extends SinglePacketTransformer
implements TransformEngine {
    private static final int b = 1000000000;
    private int extensionID = -1;

    @Override
    public RawPacket transform(RawPacket pkt) {
        if (this.extensionID != -1 && pkt.getExtensionBit()) {
            this.replaceAbsSendTime(pkt);
        }
        return pkt;
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        return pkt;
    }

    @Override
    public void close() {
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    private void replaceAbsSendTime(RawPacket pkt) {
        byte[] buf = pkt.getBuffer();
        int extensionOffset = pkt.getOffset();
        extensionOffset += 12;
        extensionOffset += pkt.getCsrcCount() * 4;
        if ((extensionOffset += 2) + 1 < buf.length) {
            int len;
            int lengthInWords = buf[extensionOffset] << 8 | buf[extensionOffset + 1];
            int lengthInBytes = 4 * (1 + lengthInWords);
            extensionOffset += 2;
            for (int innerOffset = 0; extensionOffset < buf.length && innerOffset < lengthInBytes; innerOffset += 1 + len + 1, extensionOffset += 1 + len + 1) {
                int id = (buf[extensionOffset] & 0xF0) >> 4;
                len = buf[extensionOffset] & 0xF;
                if (id != this.extensionID) continue;
                if (len == 2 && extensionOffset + 3 < buf.length) {
                    this.setTimestamp(buf, extensionOffset + 1);
                }
                return;
            }
        }
    }

    private void setTimestamp(byte[] buf, int off) {
        long ns = System.nanoTime();
        int fraction = (int)(ns % 1000000000L * 262144L / 1000000000L);
        int seconds = (int)(ns / 1000000000L % 64L);
        int timestamp = (seconds << 18 | fraction) & 0xFFFFFF;
        buf[off] = (byte)(timestamp >> 16);
        buf[off + 1] = (byte)(timestamp >> 8);
        buf[off + 2] = (byte)timestamp;
    }

    public void setExtensionID(int id) {
        this.extensionID = id;
    }
}

