/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.SessionAddress;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.rtp.OverallStats;
import net.sf.fmj.media.rtp.util.BadFormatException;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketFilter;
import net.sf.fmj.media.rtp.util.RTPPacket;
import net.sf.fmj.media.rtp.util.RTPPacketReceiver;
import net.sf.fmj.media.rtp.util.UDPPacketReceiver;

public class RTPRawReceiver
extends PacketFilter {
    private OverallStats stats = null;
    private boolean recvBufSizeSet = false;
    public DatagramSocket socket;
    private RTPConnector rtpConnector = null;

    public RTPRawReceiver() {
    }

    public RTPRawReceiver(DatagramSocket datagramsocket, OverallStats overallstats) {
        this.setSource(new UDPPacketReceiver(datagramsocket, 2000));
        this.stats = overallstats;
    }

    public RTPRawReceiver(int i, String s, OverallStats overallstats) throws UnknownHostException, IOException, SocketException {
        UDPPacketReceiver udppacketreceiver = new UDPPacketReceiver(i & 0xFFFFFFFE, s, -1, null, 2000, null);
        this.setSource(udppacketreceiver);
        this.socket = udppacketreceiver.getSocket();
        this.stats = overallstats;
    }

    public RTPRawReceiver(RTPConnector rtpconnector, OverallStats overallstats) {
        try {
            this.setSource(new RTPPacketReceiver(rtpconnector.getDataInputStream()));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
        this.rtpConnector = rtpconnector;
        this.stats = overallstats;
    }

    public RTPRawReceiver(RTPPushDataSource rtppushdatasource, OverallStats overallstats) {
        this.setSource(new RTPPacketReceiver(rtppushdatasource));
        this.stats = overallstats;
    }

    public RTPRawReceiver(SessionAddress sessionaddress, SessionAddress sessionaddress1, OverallStats overallstats, DatagramSocket datagramsocket) throws UnknownHostException, IOException, SocketException {
        this.stats = overallstats;
        UDPPacketReceiver udppacketreceiver = new UDPPacketReceiver(sessionaddress.getDataPort(), sessionaddress.getDataHostAddress(), sessionaddress1.getDataPort(), sessionaddress1.getDataHostAddress(), 2000, datagramsocket);
        this.setSource(udppacketreceiver);
        this.socket = udppacketreceiver.getSocket();
    }

    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.getSource() instanceof RTPPacketReceiver) {
            this.getSource().closeSource();
        }
    }

    public String filtername() {
        return "RTP Raw Packet Receiver";
    }

    public int getRecvBufSize() {
        try {
            Class<?> class1 = this.socket.getClass();
            Method method = class1.getMethod("getReceiveBufferSize", new Class[0]);
            Integer integer = (Integer)method.invoke((Object)this.socket, new Object[0]);
            return integer;
        }
        catch (Exception e) {
            if (this.rtpConnector != null) {
                return this.rtpConnector.getReceiveBufferSize();
            }
            return -1;
        }
    }

    public Packet handlePacket(Packet packet) {
        RTPPacket rtppacket;
        this.stats.update(0, 1);
        this.stats.update(1, packet.length);
        try {
            rtppacket = this.parse(packet);
        }
        catch (BadFormatException badformatexception) {
            this.stats.update(2, 1);
            return null;
        }
        if (!this.recvBufSizeSet) {
            this.recvBufSizeSet = true;
            switch (rtppacket.payloadType) {
                case 14: 
                case 26: 
                case 34: 
                case 42: {
                    this.setRecvBufSize(64000);
                    break;
                }
                case 31: {
                    this.setRecvBufSize(128000);
                    break;
                }
                case 32: {
                    this.setRecvBufSize(128000);
                    break;
                }
                default: {
                    if (rtppacket.payloadType < 96 || rtppacket.payloadType > 127) break;
                    this.setRecvBufSize(64000);
                }
            }
        }
        return rtppacket;
    }

    public Packet handlePacket(Packet packet, int i) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionaddress) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionaddress, boolean flag) {
        return null;
    }

    public RTPPacket parse(Packet packet) throws BadFormatException {
        RTPPacket rtppacket = new RTPPacket(packet);
        DataInputStream datainputstream = new DataInputStream(new ByteArrayInputStream(rtppacket.data, rtppacket.offset, rtppacket.length));
        try {
            int firstByte = datainputstream.readUnsignedByte();
            if ((firstByte & 0xC0) != 128) {
                throw new BadFormatException();
            }
            if ((firstByte & 0x10) != 0) {
                rtppacket.extensionPresent = true;
            }
            int paddingLength = 0;
            if ((firstByte & 0x20) != 0) {
                paddingLength = rtppacket.data[rtppacket.offset + rtppacket.length - 1] & 0xFF;
            }
            firstByte &= 0xF;
            rtppacket.payloadType = datainputstream.readUnsignedByte();
            rtppacket.marker = rtppacket.payloadType >> 7;
            rtppacket.payloadType &= 0x7F;
            rtppacket.seqnum = datainputstream.readUnsignedShort();
            rtppacket.timestamp = (long)datainputstream.readInt() & 0xFFFFFFFFL;
            rtppacket.ssrc = datainputstream.readInt();
            int offset = 0;
            rtppacket.csrc = new int[firstByte];
            for (int i1 = 0; i1 < rtppacket.csrc.length; ++i1) {
                rtppacket.csrc[i1] = datainputstream.readInt();
            }
            offset += 12 + (rtppacket.csrc.length << 2);
            if (rtppacket.extensionPresent) {
                rtppacket.extensionType = datainputstream.readUnsignedShort();
                int l = datainputstream.readUnsignedShort();
                rtppacket.extension = new byte[l <<= 2];
                datainputstream.readFully(rtppacket.extension);
                offset += l + 4;
            }
            rtppacket.payloadlength = rtppacket.length - (offset + paddingLength);
            if (rtppacket.payloadlength < 0) {
                throw new BadFormatException();
            }
            rtppacket.payloadoffset = offset + rtppacket.offset;
        }
        catch (EOFException eofexception) {
            throw new BadFormatException("Unexpected end of RTP packet");
        }
        catch (IOException ioexception) {
            throw new IllegalArgumentException("Impossible Exception");
        }
        return rtppacket;
    }

    public void setRecvBufSize(int i) {
        try {
            if (this.socket == null && this.rtpConnector != null) {
                this.rtpConnector.setReceiveBufferSize(i);
            }
        }
        catch (Exception exception) {
            Log.comment("Cannot set receive buffer size: " + exception);
        }
    }
}

