/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.io.IOException;
import java.io.InputStream;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class PullSourceStreamInputStream
extends InputStream {
    private final PullSourceStream pss;
    private final Seekable seekable;
    private long markPosition = -1L;

    public PullSourceStreamInputStream(PullSourceStream pss) {
        this.pss = pss;
        this.seekable = pss instanceof Seekable ? (Seekable)((Object)pss) : null;
    }

    public synchronized void mark(int readlimit) {
        if (!this.markSupported()) {
            super.mark(readlimit);
        }
        this.markPosition = this.seekable.tell();
    }

    public boolean markSupported() {
        return this.seekable != null;
    }

    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int nRead = this.pss.read(buffer, 0, 1);
        if (nRead <= 0) {
            return -1;
        }
        return buffer[0] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.pss.read(b, off, len);
        return result;
    }

    public synchronized void reset() throws IOException {
        if (!this.markSupported()) {
            super.reset();
        }
        if (this.markPosition < 0L) {
            throw new IOException("mark must be called before reset");
        }
        this.seekable.seek(this.markPosition);
    }

    public long skip(long n) throws IOException {
        if (this.seekable == null) {
            return super.skip(n);
        }
        if (n <= 0L) {
            return 0L;
        }
        long beforeSeek = this.seekable.tell();
        long afterSeek = this.seekable.seek(beforeSeek + n);
        return afterSeek - beforeSeek;
    }
}

