/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jitsi.impl.neomedia.transform.srtp.BlockCipherAdapter;
import org.jitsi.impl.neomedia.transform.srtp.NIOBlockCipher;
import org.jitsi.impl.neomedia.transform.srtp.OpenSSLBlockCipher;
import org.jitsi.impl.neomedia.transform.srtp.OpenSSLDigest;
import org.jitsi.impl.neomedia.transform.srtp.OpenSSLHMAC;
import sun.security.pkcs11.SunPKCS11;

public class CryptoBenchmark {
    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Exception {
        void var12_22;
        BlockCipher[] blockCipherArray;
        boolean benchmarkJavaxCryptoCipher = false;
        boolean benchmarkNIOBlockCipher = false;
        for (String arg : args) {
            if ("-javax-crypto-cipher".equalsIgnoreCase(arg)) {
                benchmarkJavaxCryptoCipher = true;
                continue;
            }
            if (!"-nio-block-cipher".equalsIgnoreCase(arg)) continue;
            benchmarkNIOBlockCipher = true;
        }
        SunPKCS11 sunPKCS11 = new SunPKCS11("--name=CryptoBenchmark\\nnssDbMode=noDb\\nattributes=compatibility");
        Provider sunJCE = Security.getProvider("SunJCE");
        Digest[] digests = new Digest[]{new SHA1Digest(), new OpenSSLDigest(1)};
        MessageDigest[] messageDigests = new MessageDigest[]{MessageDigest.getInstance("SHA-1"), MessageDigest.getInstance("SHA-1", sunPKCS11)};
        int maxDigestSize = 0;
        int maxByteLength = 0;
        for (Digest digest : digests) {
            int byteLength;
            int digestSize = digest.getDigestSize();
            if (maxDigestSize < digestSize) {
                maxDigestSize = digestSize;
            }
            int n = byteLength = digest instanceof ExtendedDigest ? ((ExtendedDigest)digest).getByteLength() : 64;
            if (maxByteLength < byteLength) {
                maxByteLength = byteLength;
            }
            System.err.println(digest.getClass().getName() + ": digestSize " + digestSize + ", byteLength " + byteLength + ".");
        }
        for (MessageDigest messageDigest : messageDigests) {
            int digestLength = messageDigest.getDigestLength();
            if (maxDigestSize < digestLength) {
                maxDigestSize = digestLength;
            }
            System.err.println(messageDigest.getProvider().getClass().getName() + ": digestLength " + digestLength + ".");
        }
        BlockCipher[] blockCipherArray2 = blockCipherArray = new BlockCipher[]{new AESFastEngine(), new BlockCipherAdapter(Cipher.getInstance("AES_128/ECB/NoPadding", sunPKCS11)), new BlockCipherAdapter(Cipher.getInstance("AES_128/ECB/NoPadding", sunJCE)), new OpenSSLBlockCipher(2)};
        int n = blockCipherArray2.length;
        boolean bl = false;
        while (var12_22 < n) {
            BlockCipher cipher = blockCipherArray2[var12_22];
            Class<?> clazz = cipher instanceof BlockCipherAdapter ? ((BlockCipherAdapter)cipher).getCipher().getProvider().getClass() : cipher.getClass();
            System.err.println(clazz.getName() + ": blockSize " + cipher.getBlockSize());
            ++var12_22;
        }
        Mac[] macs = new Mac[]{new HMac((Digest)new SHA1Digest()), new HMac((Digest)new OpenSSLDigest(1)), new OpenSSLHMAC(1)};
        Random random = new Random(System.currentTimeMillis());
        byte[] byArray = new byte[1024 * maxByteLength];
        ByteBuffer inNIO = ByteBuffer.allocateDirect(byArray.length);
        byte[] out = new byte[maxDigestSize];
        ByteBuffer outNIO = ByteBuffer.allocateDirect(out.length);
        long time0 = 0L;
        int dMax = Math.max(digests.length, messageDigests.length);
        int iEnd = 1000;
        int jEnd = 1000;
        inNIO.order(ByteOrder.nativeOrder());
        outNIO.order(ByteOrder.nativeOrder());
        for (int i = 0; i < 1000; ++i) {
            long time;
            System.err.println("========================================");
            random.nextBytes(byArray);
            inNIO.clear();
            inNIO.put(byArray);
            time0 = 0L;
            for (BlockCipher blockCipher : blockCipherArray) {
                long endTime;
                int off;
                int j;
                long startTime;
                Class<?> clazz;
                Cipher cipher;
                NIOBlockCipher nioBlockCipher;
                NIOBlockCipher nIOBlockCipher = nioBlockCipher = blockCipher instanceof NIOBlockCipher ? (NIOBlockCipher)blockCipher : null;
                if (blockCipher instanceof BlockCipherAdapter) {
                    cipher = ((BlockCipherAdapter)blockCipher).getCipher();
                    clazz = cipher.getProvider().getClass();
                } else {
                    cipher = null;
                    clazz = blockCipher.getClass();
                }
                int blockSize = blockCipher.getBlockSize();
                blockCipher.init(true, (CipherParameters)new KeyParameter(byArray, 0, blockSize));
                int offEnd = byArray.length - blockSize;
                if (nioBlockCipher != null && benchmarkNIOBlockCipher) {
                    inNIO.clear();
                    outNIO.clear();
                    startTime = System.nanoTime();
                    for (j = 0; j < 1000; ++j) {
                        for (off = 0; off < offEnd; off += blockSize) {
                            nioBlockCipher.processBlock(inNIO, off, outNIO, 0);
                        }
                    }
                    endTime = System.nanoTime();
                    outNIO.get(out);
                } else if (cipher != null && benchmarkJavaxCryptoCipher) {
                    startTime = System.nanoTime();
                    for (j = 0; j < 1000; ++j) {
                        off = 0;
                        while (off < offEnd) {
                            int nextOff = off + blockSize;
                            inNIO.limit(nextOff);
                            inNIO.position(off);
                            outNIO.clear();
                            cipher.update(inNIO, outNIO);
                            off = nextOff;
                        }
                    }
                    endTime = System.nanoTime();
                    outNIO.clear();
                    outNIO.get(out);
                } else {
                    startTime = System.nanoTime();
                    for (j = 0; j < 1000; ++j) {
                        for (off = 0; off < offEnd; off += blockSize) {
                            blockCipher.processBlock(byArray, off, out, 0);
                        }
                    }
                    endTime = System.nanoTime();
                }
                long time2 = endTime - startTime;
                if (time0 == 0L) {
                    time0 = time2;
                }
                Arrays.fill(out, blockSize, out.length, (byte)0);
                System.err.println(clazz.getName() + ": ratio " + String.format("%.2f", (double)time2 / (double)time0) + ", time " + time2 + ", out " + ".");
            }
            System.err.println("----------------------------------------");
            time0 = 0L;
            for (int d = 0; d < dMax; ++d) {
                MessageDigest messageDigest;
                long endTime;
                long l;
                Arrays.fill(out, (byte)0);
                Digest digest = d < digests.length ? digests[d] : null;
                int byteLength = digest instanceof ExtendedDigest ? ((ExtendedDigest)digest).getByteLength() : 64;
                int offEnd = byArray.length - byteLength;
                if (digest != null) {
                    l = System.nanoTime();
                    for (int j = 0; j < 1000; ++j) {
                        for (int off = 0; off < offEnd; off += byteLength) {
                            digest.update(byArray, off, byteLength);
                        }
                        digest.doFinal(out, 0);
                    }
                    endTime = System.nanoTime();
                    long time3 = endTime - l;
                    if (time0 == 0L) {
                        time0 = time3;
                    }
                    System.err.println(digest.getClass().getName() + ": ratio " + String.format("%.2f", (double)time3 / (double)time0) + ", time " + time3 + ", digest " + ".");
                }
                MessageDigest messageDigest2 = messageDigest = d < messageDigests.length ? messageDigests[d] : null;
                if (messageDigest == null) continue;
                byte[] t = null;
                l = System.nanoTime();
                for (int j = 0; j < 1000; ++j) {
                    for (int off = 0; off < offEnd; off += byteLength) {
                        messageDigest.update(byArray, off, byteLength);
                    }
                    t = messageDigest.digest();
                }
                endTime = System.nanoTime();
                time = endTime - l;
                if (time0 == 0L) {
                    time0 = time;
                }
                System.err.println(messageDigest.getProvider().getClass().getName() + ": ratio " + String.format("%.2f", (double)time / (double)time0) + ", time " + (endTime - l) + ", digest " + ".");
            }
            System.err.println("----------------------------------------");
            time0 = 0L;
            for (BlockCipher blockCipher : macs) {
                blockCipher.init((CipherParameters)new KeyParameter(byArray, 0, maxByteLength));
                int offEnd = byArray.length - maxByteLength;
                long startTime = System.nanoTime();
                for (int j = 0; j < 1000; ++j) {
                    for (int off = 0; off < offEnd; off += maxByteLength) {
                        blockCipher.update(byArray, off, maxByteLength);
                    }
                    blockCipher.doFinal(out, 0);
                }
                long endTime = System.nanoTime();
                int macSize = blockCipher.getMacSize();
                time = endTime - startTime;
                if (time0 == 0L) {
                    time0 = time;
                }
                Arrays.fill(out, macSize, out.length, (byte)0);
                System.err.println(blockCipher.getClass().getName() + ": ratio " + String.format("%.2f", (double)time / (double)time0) + ", time " + time + ", out " + ".");
            }
        }
    }
}

