/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.translator;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.media.Buffer;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import org.jitsi.impl.neomedia.rtp.translator.PushSourceStreamDesc;
import org.jitsi.impl.neomedia.rtp.translator.RTPConnectorDesc;
import org.jitsi.impl.neomedia.rtp.translator.RTPConnectorImpl;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.util.Logger;

class PushSourceStreamImpl
implements PushSourceStream,
Runnable,
SourceTransferHandler {
    private static final Logger logger = Logger.getLogger(PushSourceStreamImpl.class);
    private boolean closed = false;
    private final RTPConnectorImpl connector;
    private final boolean data;
    private boolean read = false;
    private final Queue<SourcePacket> readQ;
    private final int readQCapacity;
    private final Queue<SourcePacket> sourcePacketPool = new LinkedBlockingQueue<SourcePacket>();
    private final List<PushSourceStreamDesc> streams = new LinkedList<PushSourceStreamDesc>();
    private Thread transferDataThread;
    private SourceTransferHandler transferHandler;

    public PushSourceStreamImpl(RTPConnectorImpl connector, boolean data) {
        this.connector = connector;
        this.data = data;
        this.readQCapacity = 256;
        this.readQ = new ArrayBlockingQueue<SourcePacket>(this.readQCapacity);
        this.transferDataThread = new Thread((Runnable)this, this.getClass().getName());
        this.transferDataThread.setDaemon(true);
        this.transferDataThread.start();
    }

    public synchronized void addStream(RTPConnectorDesc connectorDesc, PushSourceStream stream) {
        for (PushSourceStreamDesc streamDesc : this.streams) {
            if (streamDesc.connectorDesc != connectorDesc || streamDesc.stream != stream) continue;
            return;
        }
        this.streams.add(new PushSourceStreamDesc(connectorDesc, stream, this.data));
        stream.setTransferHandler(this);
    }

    public void close() {
        this.closed = true;
        this.sourcePacketPool.clear();
    }

    @Override
    public boolean endOfStream() {
        return false;
    }

    @Override
    public ContentDescriptor getContentDescriptor() {
        return null;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public Object getControl(String controlType) {
        return null;
    }

    @Override
    public Object[] getControls() {
        return null;
    }

    @Override
    public synchronized int getMinimumTransferSize() {
        int minimumTransferSize = 0;
        for (PushSourceStreamDesc streamDesc : this.streams) {
            int streamMinimumTransferSize = streamDesc.stream.getMinimumTransferSize();
            if (minimumTransferSize >= streamMinimumTransferSize) continue;
            minimumTransferSize = streamMinimumTransferSize;
        }
        return minimumTransferSize;
    }

    private RTPTranslatorImpl getTranslator() {
        return this.connector.translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        RTPTranslatorImpl translator;
        int pktLength;
        SourcePacket pkt;
        if (this.closed) {
            return -1;
        }
        Queue<SourcePacket> queue = this.readQ;
        synchronized (queue) {
            pkt = this.readQ.peek();
            if (pkt == null) {
                return 0;
            }
            pktLength = pkt.getLength();
            if (length < pktLength) {
                throw new IOException("Length " + length + " is insuffient. Must be at least " + pktLength + ".");
            }
            this.readQ.remove();
            this.read = true;
            this.readQ.notifyAll();
        }
        System.arraycopy(pkt.getBuffer(), pkt.getOffset(), buffer, offset, pktLength);
        PushSourceStreamDesc streamDesc = pkt.streamDesc;
        int read = pktLength;
        int flags = pkt.getFlags();
        pkt.streamDesc = null;
        this.sourcePacketPool.offer(pkt);
        if (read > 0 && (translator = this.getTranslator()) != null) {
            read = translator.didRead(streamDesc, buffer, offset, read, flags);
        }
        return read;
    }

    public synchronized void removeStreams(RTPConnectorDesc connectorDesc) {
        Iterator<PushSourceStreamDesc> streamIter = this.streams.iterator();
        while (streamIter.hasNext()) {
            PushSourceStreamDesc streamDesc = streamIter.next();
            if (streamDesc.connectorDesc != connectorDesc) continue;
            streamDesc.stream.setTransferHandler(null);
            streamIter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block15: {
            block10: while (true) {
                while (!this.closed) {
                    SourceTransferHandler transferHandler = this.transferHandler;
                    Queue<SourcePacket> queue = this.readQ;
                    synchronized (queue) {
                        if (this.readQ.isEmpty() || transferHandler == null) {
                            try {
                                this.readQ.wait(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    try {
                        transferHandler.transferData(this);
                        continue block10;
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.warn("An RTP packet may have not been fully handled.", t);
                    }
                }
                break block15;
                {
                    continue block10;
                    break;
                }
                break;
            }
            finally {
                if (Thread.currentThread().equals(this.transferDataThread)) {
                    this.transferDataThread = null;
                }
            }
        }
    }

    @Override
    public synchronized void setTransferHandler(SourceTransferHandler transferHandler) {
        if (this.transferHandler != transferHandler) {
            this.transferHandler = transferHandler;
            for (PushSourceStreamDesc streamDesc : this.streams) {
                streamDesc.stream.setTransferHandler(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferData(PushSourceStream stream) {
        SourcePacket pkt;
        block49: {
            boolean yield;
            byte[] buf;
            if (this.closed) {
                return;
            }
            PushSourceStreamDesc streamDesc = null;
            PushSourceStreamImpl pushSourceStreamImpl = this;
            synchronized (pushSourceStreamImpl) {
                for (PushSourceStreamDesc aStreamDesc : this.streams) {
                    if (aStreamDesc.stream != stream) continue;
                    streamDesc = aStreamDesc;
                    break;
                }
            }
            if (streamDesc == null) {
                return;
            }
            int len = stream.getMinimumTransferSize();
            if (len < 1) {
                len = 2048;
            }
            if ((pkt = this.sourcePacketPool.poll()) == null || (buf = pkt.getBuffer()).length < len) {
                buf = new byte[len];
                pkt = new SourcePacket(buf, 0, 0);
            } else {
                buf = pkt.getBuffer();
                len = buf.length;
                pkt.setFlags(0);
                pkt.setLength(0);
                pkt.setOffset(0);
            }
            int read = 0;
            try {
                PushBufferStream streamAsPushBufferStream = streamDesc.streamAsPushBufferStream;
                if (streamAsPushBufferStream == null) {
                    read = stream.read(buf, 0, len);
                } else {
                    streamAsPushBufferStream.read(pkt);
                    if (pkt.isDiscard()) {
                        read = 0;
                    } else {
                        read = pkt.getLength();
                        if (read < 1 && (pkt.getFlags() & 1) == 1) {
                            read = -1;
                        }
                    }
                }
                if (read <= 0) break block49;
            }
            catch (IOException ioe) {
                block50: {
                    boolean yield2;
                    try {
                        logger.error("Failed to read from an RTP stream!", ioe);
                        if (read <= 0) break block50;
                    }
                    catch (Throwable throwable) {
                        if (read > 0) {
                            boolean yield3;
                            pkt.setLength(read);
                            pkt.streamDesc = streamDesc;
                            Queue<SourcePacket> queue = this.readQ;
                            synchronized (queue) {
                                int readQSize = this.readQ.size();
                                yield3 = readQSize < 1 ? false : (readQSize < this.readQCapacity ? !this.read : true);
                                if (yield3) {
                                    this.readQ.notifyAll();
                                }
                            }
                            if (yield3) {
                                Thread.yield();
                            }
                            queue = this.readQ;
                            synchronized (queue) {
                                if (this.readQ.size() >= this.readQCapacity) {
                                    this.readQ.remove();
                                    logger.warn("Discarded an RTP packet because the read queue is full.");
                                }
                                if (this.readQ.offer(pkt)) {
                                    // empty if block
                                }
                                this.readQ.notifyAll();
                            }
                        }
                        pkt.streamDesc = null;
                        this.sourcePacketPool.offer(pkt);
                        throw throwable;
                    }
                    pkt.setLength(read);
                    pkt.streamDesc = streamDesc;
                    Queue<SourcePacket> queue = this.readQ;
                    synchronized (queue) {
                        int readQSize = this.readQ.size();
                        yield2 = readQSize < 1 ? false : (readQSize < this.readQCapacity ? !this.read : true);
                        if (yield2) {
                            this.readQ.notifyAll();
                        }
                    }
                    if (yield2) {
                        Thread.yield();
                    }
                    queue = this.readQ;
                    synchronized (queue) {
                        if (this.readQ.size() >= this.readQCapacity) {
                            this.readQ.remove();
                            logger.warn("Discarded an RTP packet because the read queue is full.");
                        }
                        if (this.readQ.offer(pkt)) {
                            // empty if block
                        }
                        this.readQ.notifyAll();
                    }
                }
                pkt.streamDesc = null;
                this.sourcePacketPool.offer(pkt);
            }
            pkt.setLength(read);
            pkt.streamDesc = streamDesc;
            Queue<SourcePacket> queue = this.readQ;
            synchronized (queue) {
                int readQSize = this.readQ.size();
                yield = readQSize < 1 ? false : (readQSize < this.readQCapacity ? !this.read : true);
                if (yield) {
                    this.readQ.notifyAll();
                }
            }
            if (yield) {
                Thread.yield();
            }
            queue = this.readQ;
            synchronized (queue) {
                if (this.readQ.size() >= this.readQCapacity) {
                    this.readQ.remove();
                    logger.warn("Discarded an RTP packet because the read queue is full.");
                }
                if (this.readQ.offer(pkt)) {
                    // empty if block
                }
                this.readQ.notifyAll();
            }
        }
        pkt.streamDesc = null;
        this.sourcePacketPool.offer(pkt);
    }

    private static class SourcePacket
    extends Buffer {
        private byte[] buffer;
        public PushSourceStreamDesc streamDesc;

        public SourcePacket(byte[] buf, int off, int len) {
            this.setData(buf);
            this.setOffset(off);
            this.setLength(len);
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        @Override
        public void setData(Object data) {
            super.setData(data);
            this.buffer = (byte[])data;
        }
    }
}

