/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp.util;

import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.utility.ByteBufferOutputStream;

public class RTPPacket
extends Packet {
    public Packet base;
    public boolean extensionPresent;
    public int marker;
    public int payloadType;
    public int seqnum;
    public long timestamp;
    public int ssrc;
    public int[] csrc;
    public int extensionType;
    public byte[] extension;
    public int payloadoffset;
    public int payloadlength;

    public RTPPacket() {
    }

    public RTPPacket(Packet p) {
        super(p);
        this.base = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assemble(int len, boolean encrypted) {
        this.length = len;
        this.offset = 0;
        byte[] d = new byte[len];
        ByteBufferOutputStream bbos = new ByteBufferOutputStream(d, 0, len);
        DataOutputStream dos = new DataOutputStream(bbos);
        try {
            dos.writeByte(128);
            int mp = this.payloadType;
            if (this.marker == 1) {
                mp = this.payloadType | 0x80;
            }
            dos.writeByte((byte)mp);
            dos.writeShort(this.seqnum);
            dos.writeInt((int)this.timestamp);
            dos.writeInt(this.ssrc);
            dos.write(this.base.data, this.payloadoffset, this.payloadlength);
            this.data = d;
        }
        catch (IOException e) {
            System.out.println("caught IOException in DOS");
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException e) {}
        }
    }

    public int calcLength() {
        return this.payloadlength + 12;
    }

    public RTPPacket clone() {
        RTPPacket p = new RTPPacket(this.base.clone());
        p.extensionPresent = this.extensionPresent;
        p.marker = this.marker;
        p.payloadType = this.payloadType;
        p.seqnum = this.seqnum;
        p.timestamp = this.timestamp;
        p.ssrc = this.ssrc;
        p.csrc = (int[])this.csrc.clone();
        p.extensionType = this.extensionType;
        p.extension = this.extension;
        p.payloadoffset = this.payloadoffset;
        p.payloadlength = this.payloadlength;
        return p;
    }

    public String toString() {
        String s = "RTP Packet:\n\tPayload Type: " + this.payloadType + "    Marker: " + this.marker + "\n\tSequence Number: " + this.seqnum + "\n\tTimestamp: " + this.timestamp + "\n\tSSRC (Sync Source): " + this.ssrc + "\n\tPayload Length: " + this.payloadlength + "    Payload Offset: " + this.payloadoffset + "\n";
        if (this.csrc.length > 0) {
            s = s + "Contributing sources:  " + this.csrc[0];
            for (int i = 1; i < this.csrc.length; ++i) {
                s = s + ", " + this.csrc[i];
            }
            s = s + "\n";
        }
        if (this.extensionPresent) {
            s = s + "\tExtension:  type " + this.extensionType + ", length " + this.extension.length + "\n";
        }
        return s;
    }
}

