/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

public class PresenceStatus
implements Comparable<PresenceStatus> {
    public static final int ONLINE_THRESHOLD = 20;
    public static final int EXTENDED_AWAY_THRESHOLD = 31;
    public static final int AWAY_THRESHOLD = 36;
    public static final int AVAILABLE_THRESHOLD = 50;
    public static final int EAGER_TO_COMMUNICATE_THRESHOLD = 80;
    public static final int MAX_STATUS_VALUE = 100;
    protected final byte[] statusIcon;
    protected final int status;
    protected final String statusName;

    protected PresenceStatus(int status, String statusName) {
        this(status, statusName, null);
    }

    protected PresenceStatus(int status, String statusName, byte[] statusIcon) {
        this.status = status;
        this.statusName = statusName;
        this.statusIcon = statusIcon;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public String toString() {
        return "PresenceStatus:" + this.getStatusName();
    }

    public boolean isOnline() {
        return this.getStatus() >= 20;
    }

    public boolean isAvailable() {
        return this.getStatus() >= 50;
    }

    public boolean isEagerToCommunicate() {
        return this.getStatus() >= 80;
    }

    @Override
    public int compareTo(PresenceStatus target) throws ClassCastException, NullPointerException {
        return this.getStatus() - target.getStatus();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PresenceStatus)) {
            return false;
        }
        PresenceStatus status = (PresenceStatus)obj;
        return status.getStatus() == this.getStatus() && status.getStatusName().equals(this.getStatusName());
    }

    public int hashCode() {
        return this.getStatusName().hashCode();
    }

    public byte[] getStatusIcon() {
        return this.statusIcon;
    }
}

