/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidateType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.util.NetworkUtils;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.neomedia.DefaultStreamConnector;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.TransportManager;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.xmpp.ComponentImpl;
import org.osgi.framework.BundleContext;

public class RawUdpTransportManager
extends TransportManager {
    private static final Logger logger = Logger.getLogger(RawUdpTransportManager.class);
    private final Channel channel;
    private final int generation;
    private final String rtcpCandidateID;
    private final String rtpCandidateID;
    private final StreamConnector streamConnector;

    public RawUdpTransportManager(Channel channel) throws IOException {
        this.channel = channel;
        this.addChannel(channel);
        this.streamConnector = this.createStreamConnector();
        this.generation = 0;
        this.rtpCandidateID = this.generateCandidateID();
        this.rtcpCandidateID = this.generateCandidateID();
        channel.transportConnected();
    }

    public boolean addChannel(Channel c) {
        return this.getChannels().isEmpty() ? super.addChannel(c) : false;
    }

    public void close() {
        super.close();
        if (this.streamConnector != null) {
            this.streamConnector.close();
        }
    }

    public boolean close(Channel channel) {
        if (channel == this.channel) {
            super.close(channel);
            channel.transportClosed();
            this.close();
            return true;
        }
        return false;
    }

    private StreamConnector createStreamConnector() throws IOException {
        BundleContext bundleContext = this.channel.getBundleContext();
        NetworkAddressManagerService nams = (NetworkAddressManagerService)ServiceUtils.getService((BundleContext)bundleContext, NetworkAddressManagerService.class);
        InetAddress bindAddr = null;
        if (nams != null) {
            Content content = this.channel.getContent();
            Conference conference = content.getConference();
            Videobridge videobridge = conference.getVideobridge();
            for (ComponentImpl component : videobridge.getComponents()) {
                String domain = component.getDomain();
                if (domain != null && domain.length() != 0) {
                    int subdomainEnd = domain.indexOf(46);
                    if (subdomainEnd >= 0) {
                        domain = domain.substring(subdomainEnd + 1);
                    }
                    if (domain.length() != 0) {
                        try {
                            bindAddr = nams.getLocalHost(NetworkUtils.getInetAddress((String)domain));
                        }
                        catch (UnknownHostException uhe) {
                            logger.info((Object)("Failed to get InetAddress from " + domain + " for channel " + this.channel.getID() + " of content " + content.getName() + " of conference " + conference.getID() + "."), (Throwable)uhe);
                        }
                    }
                }
                if (bindAddr == null) continue;
                break;
            }
        }
        if (bindAddr == null) {
            bindAddr = InetAddress.getLocalHost();
        }
        DefaultStreamConnector streamConnector = new DefaultStreamConnector(bindAddr);
        streamConnector.getDataSocket();
        streamConnector.getControlSocket();
        return streamConnector;
    }

    public void describe(ColibriConferenceIQ.ChannelCommon iq) {
        super.describe(iq);
        IceUdpTransportPacketExtension transport = iq.getTransport();
        if (transport != null) {
            String host = null;
            int rtcpPort = 0;
            int rtpPort = 0;
            block4: for (CandidatePacketExtension candidate : transport.getCandidateList()) {
                switch (candidate.getComponent()) {
                    case 2: {
                        rtcpPort = candidate.getPort();
                        break;
                    }
                    case 1: {
                        rtpPort = candidate.getPort();
                        break;
                    }
                    default: {
                        continue block4;
                    }
                }
                if (host != null && host.length() != 0) continue;
                host = candidate.getIP();
            }
            if (iq instanceof ColibriConferenceIQ.Channel) {
                ColibriConferenceIQ.Channel channelIq = (ColibriConferenceIQ.Channel)iq;
                channelIq.setHost(host);
                channelIq.setRTCPPort(rtcpPort);
                channelIq.setRTPPort(rtpPort);
            }
        }
    }

    protected void describe(IceUdpTransportPacketExtension pe) {
        StreamConnector streamConnector = this.getStreamConnector(this.channel);
        DatagramSocket socket = streamConnector.getDataSocket();
        CandidatePacketExtension candidate = new CandidatePacketExtension();
        candidate.setComponent(1);
        candidate.setGeneration(this.generation);
        candidate.setID(this.rtpCandidateID);
        candidate.setIP(socket.getLocalAddress().getHostAddress());
        candidate.setPort(socket.getLocalPort());
        candidate.setType(CandidateType.host);
        pe.addCandidate(candidate);
        socket = streamConnector.getControlSocket();
        candidate = new CandidatePacketExtension();
        candidate.setComponent(2);
        candidate.setGeneration(this.generation);
        candidate.setID(this.rtcpCandidateID);
        candidate.setIP(socket.getLocalAddress().getHostAddress());
        candidate.setPort(socket.getLocalPort());
        candidate.setType(CandidateType.host);
        pe.addCandidate(candidate);
    }

    public DtlsControl getDtlsControl(Channel channel) {
        return null;
    }

    public StreamConnector getStreamConnector(Channel channel) {
        return this.streamConnector;
    }

    public MediaStreamTarget getStreamTarget(Channel channel) {
        return null;
    }

    public String getXmlNamespace() {
        return "urn:xmpp:jingle:transports:raw-udp:1";
    }

    public void startConnectivityEstablishment(IceUdpTransportPacketExtension transport) {
    }
}

