/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.outgoing;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sf.jml.MsnProtocol;
import net.sf.jml.protocol.MsnOutgoingMessage;
import net.sf.jml.util.DigestUtils;
import net.sf.jml.util.NumberUtils;

public class OutgoingQRY
extends MsnOutgoingMessage {
    private static final String PRODUCT_ID = "msmsgs@msnmsgr.com";
    private static final String PRODUCT_KEY = "Q1P7W2E4J9R8U3S5";
    private static final String MSNP11_PRODUCT_ID = "PROD0090YUAUV{2B";
    private static final String MSNP11_PRODUCT_KEY = "YMM8C_H7KCQ2S_KL";
    private static final long MSNP11_MAGIC_NUM = 242854337L;
    public static final String CLIENT_VER = "8.5.1288.816";
    private static final String MSNP15_PRODUCT_ID = "PROD0119GSJUC$18";
    private static final String MSNP15_PRODUCT_KEY = "ILTXC!4IXB5FB*PX";
    private static final long MSNP15_MAGIC_NUM = 242854337L;
    private static long MAGIC_NUM = 242854337L;

    public OutgoingQRY(MsnProtocol msnProtocol) {
        super(msnProtocol);
        this.setCommand("QRY");
        this.addParam(this.getProductId());
    }

    protected boolean isSupportChunkData() {
        return true;
    }

    public String getProductId() {
        if (this.protocol.before(MsnProtocol.MSNP11)) {
            return PRODUCT_ID;
        }
        if (this.protocol.before(MsnProtocol.MSNP13)) {
            return MSNP11_PRODUCT_ID;
        }
        return MSNP15_PRODUCT_ID;
    }

    public void setDigestNum(String string) {
        this.setChunkData(this.calc(string));
    }

    public String calc(String string) {
        String string2 = null;
        String string3 = null;
        if (this.protocol.before(MsnProtocol.MSNP11)) {
            return DigestUtils.md5(string + PRODUCT_KEY);
        }
        if (this.protocol.before(MsnProtocol.MSNP13)) {
            string2 = MSNP11_PRODUCT_KEY;
            string3 = MSNP11_PRODUCT_ID;
        } else {
            string2 = MSNP15_PRODUCT_KEY;
            string3 = MSNP15_PRODUCT_ID;
        }
        byte[] byArray = DigestUtils.md5((string + string2).getBytes());
        int[] nArray = this.getMd5Ints(byArray);
        int[] nArray2 = this.getChlInts(string + string3);
        long l = this.getKey(nArray, nArray2);
        return this.getChallenge(l, byArray);
    }

    private int[] getMd5Ints(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        int[] nArray = new int[4];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = byteBuffer.getInt() & Integer.MAX_VALUE;
        }
        return nArray;
    }

    private int[] getChlInts(String string) {
        byte[] byArray = string.getBytes();
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)Math.ceil((double)byArray.length / 8.0) * 8).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(byArray);
        while (byteBuffer.hasRemaining()) {
            byteBuffer.put((byte)48);
        }
        byteBuffer.flip();
        int[] nArray = new int[byteBuffer.remaining() / 4];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = byteBuffer.getInt();
        }
        return nArray;
    }

    private long getKey(int[] nArray, int[] nArray2) {
        MAGIC_NUM = this.protocol.before(MsnProtocol.MSNP13) ? 242854337L : 242854337L;
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < nArray2.length; i += 2) {
            long l3 = (long)nArray2[i] * MAGIC_NUM % Integer.MAX_VALUE + l;
            l3 = (l3 * (long)nArray[0] + (long)nArray[1]) % Integer.MAX_VALUE;
            l = ((long)nArray2[i + 1] + l3) % Integer.MAX_VALUE;
            l = ((long)nArray[2] * l + (long)nArray[3]) % Integer.MAX_VALUE;
            l2 = l2 + l + l3;
        }
        l = (l + (long)nArray[1]) % Integer.MAX_VALUE;
        l2 = (l2 + (long)nArray[3]) % Integer.MAX_VALUE;
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt((int)l);
        byteBuffer.putInt((int)l2);
        byteBuffer.flip();
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return byteBuffer.getLong();
    }

    private String getChallenge(long l, byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        String string = NumberUtils.toHexValue(byteBuffer.getLong() ^ l);
        String string2 = NumberUtils.toHexValue(byteBuffer.getLong() ^ l);
        return string + string2;
    }
}

