/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.request;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.Member;
import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.management.MapConfigAdapter;
import com.hazelcast.management.operation.GetMapConfigOperation;
import com.hazelcast.management.operation.UpdateMapConfigOperation;
import com.hazelcast.management.request.ConsoleRequest;
import com.hazelcast.util.JsonUtil;
import java.util.Set;

public class MapConfigRequest
implements ConsoleRequest {
    private String mapName;
    private MapConfigAdapter config;
    private boolean update;

    public MapConfigRequest() {
    }

    public MapConfigRequest(String mapName, MapConfigAdapter config, boolean update) {
        this.mapName = mapName;
        this.config = config;
        this.update = update;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject root) {
        JsonObject result = new JsonObject();
        result.add("update", this.update);
        if (this.update) {
            Set<Member> members = mcs.getHazelcastInstance().getCluster().getMembers();
            for (Member member : members) {
                mcs.callOnMember(member, new UpdateMapConfigOperation(this.mapName, this.config.getMapConfig()));
            }
            result.add("updateResult", "success");
        } else {
            MapConfig cfg = (MapConfig)mcs.callOnThis(new GetMapConfigOperation(this.mapName));
            if (cfg != null) {
                result.add("hasMapConfig", true);
                result.add("mapConfig", new MapConfigAdapter(cfg).toJson());
            } else {
                result.add("hasMapConfig", false);
            }
        }
        root.add("result", result);
    }

    @Override
    public Object readResponse(JsonObject json) {
        this.update = JsonUtil.getBoolean(json, "update", false);
        if (!this.update) {
            boolean hasMapConfig = JsonUtil.getBoolean(json, "hasMapConfig", false);
            if (hasMapConfig) {
                MapConfigAdapter adapter = new MapConfigAdapter();
                adapter.fromJson(JsonUtil.getObject(json, "mapConfig"));
                return adapter.getMapConfig();
            }
            return null;
        }
        return JsonUtil.getString(json, "updateResult");
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("mapName", this.mapName);
        root.add("update", this.update);
        root.add("config", this.config.toJson());
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.mapName = JsonUtil.getString(json, "mapName");
        this.update = JsonUtil.getBoolean(json, "update");
        this.config = new MapConfigAdapter();
        this.config.fromJson(JsonUtil.getObject(json, "config"));
    }
}

