/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server;

import java.util.Objects;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.spdy.api.server.ServerSessionFrameListener;
import org.eclipse.jetty.spdy.server.NPNServerConnectionFactory;
import org.eclipse.jetty.spdy.server.NegotiatingServerConnectionFactory;
import org.eclipse.jetty.spdy.server.SPDYServerConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SPDYServerConnector
extends ServerConnector {
    public SPDYServerConnector(Server server, ServerSessionFrameListener listener) {
        super(server, (SslContextFactory)null, new ConnectionFactory[]{new SPDYServerConnectionFactory(2, listener)});
    }

    public SPDYServerConnector(Server server, SslContextFactory sslContextFactory, ServerSessionFrameListener listener) {
        this(server, sslContextFactory, listener, new NPNServerConnectionFactory(new String[]{"spdy/3", "spdy/2", "http/1.1"}));
    }

    public SPDYServerConnector(Server server, SslContextFactory sslContextFactory, ServerSessionFrameListener listener, NegotiatingServerConnectionFactory negotiator) {
        super(server, Objects.requireNonNull(sslContextFactory), new ConnectionFactory[]{negotiator, new SPDYServerConnectionFactory(3, listener), new SPDYServerConnectionFactory(2, listener), new HttpConnectionFactory()});
        negotiator.setDefaultProtocol("http/1.1");
    }
}

