/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.nio.Address;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.impl.PartitionListener;
import com.hazelcast.partition.impl.PartitionReplicaChangeEvent;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

class InternalPartitionImpl
implements InternalPartition {
    private static final AtomicReferenceFieldUpdater<InternalPartitionImpl, Address[]> ADDRESSES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(InternalPartitionImpl.class, Address[].class, "addresses");
    @SuppressWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"})
    volatile Address[] addresses = new Address[7];
    private final int partitionId;
    private final PartitionListener partitionListener;
    private volatile boolean isMigrating;

    InternalPartitionImpl(int partitionId, PartitionListener partitionListener) {
        this.partitionId = partitionId;
        this.partitionListener = partitionListener;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public boolean isMigrating() {
        return this.isMigrating;
    }

    public void setMigrating(boolean isMigrating) {
        this.isMigrating = isMigrating;
    }

    @Override
    public Address getOwnerOrNull() {
        return this.addresses[0];
    }

    void setOwner(Address ownerAddress) {
        this.setReplicaAddress(0, ownerAddress);
    }

    @Override
    public Address getReplicaAddress(int replicaIndex) {
        return this.addresses[replicaIndex];
    }

    void setReplicaAddress(int replicaIndex, Address newAddress) {
        Address oldAddress;
        Address[] newAddresses;
        Address[] oldAddresses;
        boolean changed = false;
        do {
            oldAddresses = this.addresses;
            oldAddress = oldAddresses[replicaIndex];
            if (this.partitionListener == null) continue;
            if (oldAddress == null) {
                changed = newAddress != null;
                continue;
            }
            boolean bl = changed = !oldAddress.equals(newAddress);
        } while (!ADDRESSES_UPDATER.compareAndSet(this, oldAddresses, newAddresses = this.createNewAddresses(replicaIndex, newAddress, oldAddresses)));
        if (changed) {
            PartitionReplicaChangeEvent event = new PartitionReplicaChangeEvent(this.partitionId, replicaIndex, oldAddress, newAddress);
            this.partitionListener.replicaChanged(event);
        }
    }

    private Address[] createNewAddresses(int replicaIndex, Address newAddress, Address[] oldAddresses) {
        Address[] newAddresses = new Address[7];
        System.arraycopy(oldAddresses, 0, newAddresses, 0, 7);
        newAddresses[replicaIndex] = newAddress;
        return newAddresses;
    }

    boolean onDeadAddress(Address deadAddress) {
        for (int i = 0; i < 7; ++i) {
            if (!deadAddress.equals(this.addresses[i])) continue;
            int a = i;
            while (a + 1 < 7) {
                this.setReplicaAddress(a, this.addresses[a + 1]);
                ++a;
            }
            this.setReplicaAddress(6, null);
            return true;
        }
        return false;
    }

    void setPartitionInfo(Address[] replicas) {
        for (int i = 0; i < 7; ++i) {
            this.setReplicaAddress(i, replicas[i]);
        }
    }

    @Override
    public boolean isOwnerOrBackup(Address address) {
        for (int i = 0; i < 7; ++i) {
            if (!address.equals(this.getReplicaAddress(i))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Partition [").append(this.partitionId).append("]{\n");
        for (int i = 0; i < 7; ++i) {
            Address address = this.addresses[i];
            if (address == null) continue;
            sb.append('\t');
            sb.append(i).append(":").append(address);
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }
}

