/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.util.Clock;
import com.hazelcast.util.JsonUtil;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalQueueStatsImpl
implements LocalQueueStats {
    private static final AtomicLongFieldUpdater<LocalQueueStatsImpl> NUMBER_OF_OFFERS_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalQueueStatsImpl.class, "numberOfOffers");
    private static final AtomicLongFieldUpdater<LocalQueueStatsImpl> NUMBER_OF_REJECTED_OFFERS_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalQueueStatsImpl.class, "numberOfRejectedOffers");
    private static final AtomicLongFieldUpdater<LocalQueueStatsImpl> NUMBER_OF_POLLS_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalQueueStatsImpl.class, "numberOfPolls");
    private static final AtomicLongFieldUpdater<LocalQueueStatsImpl> NUMBER_OF_EMPTY_POLLS_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalQueueStatsImpl.class, "numberOfEmptyPolls");
    private static final AtomicLongFieldUpdater<LocalQueueStatsImpl> NUMBER_OF_OTHER_OPERATIONS_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalQueueStatsImpl.class, "numberOfOtherOperations");
    private static final AtomicLongFieldUpdater<LocalQueueStatsImpl> NUMBER_OF_EVENTS_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalQueueStatsImpl.class, "numberOfEvents");
    private int ownedItemCount;
    private int backupItemCount;
    private long minAge;
    private long maxAge;
    private long aveAge;
    private long creationTime = Clock.currentTimeMillis();
    private volatile long numberOfOffers;
    private volatile long numberOfRejectedOffers;
    private volatile long numberOfPolls;
    private volatile long numberOfEmptyPolls;
    private volatile long numberOfOtherOperations;
    private volatile long numberOfEvents;

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("ownedItemCount", this.ownedItemCount);
        root.add("backupItemCount", this.backupItemCount);
        root.add("minAge", this.minAge);
        root.add("maxAge", this.maxAge);
        root.add("aveAge", this.aveAge);
        root.add("creationTime", this.creationTime);
        root.add("numberOfOffers", this.numberOfOffers);
        root.add("numberOfPolls", this.numberOfPolls);
        root.add("numberOfRejectedOffers", this.numberOfRejectedOffers);
        root.add("numberOfEmptyPolls", this.numberOfEmptyPolls);
        root.add("numberOfOtherOperations", this.numberOfOtherOperations);
        root.add("numberOfEvents", this.numberOfEvents);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.ownedItemCount = JsonUtil.getInt(json, "ownedItemCount", -1);
        this.backupItemCount = JsonUtil.getInt(json, "backupItemCount", -1);
        this.minAge = JsonUtil.getLong(json, "minAge", -1L);
        this.maxAge = JsonUtil.getLong(json, "maxAge", -1L);
        this.aveAge = JsonUtil.getLong(json, "aveAge", -1L);
        this.creationTime = JsonUtil.getLong(json, "creationTime", -1L);
        NUMBER_OF_OFFERS_UPDATER.set(this, JsonUtil.getLong(json, "numberOfOffers", -1L));
        NUMBER_OF_POLLS_UPDATER.set(this, JsonUtil.getLong(json, "numberOfPolls", -1L));
        NUMBER_OF_REJECTED_OFFERS_UPDATER.set(this, JsonUtil.getLong(json, "numberOfRejectedOffers", -1L));
        NUMBER_OF_EMPTY_POLLS_UPDATER.set(this, JsonUtil.getLong(json, "numberOfEmptyPolls", -1L));
        NUMBER_OF_OTHER_OPERATIONS_UPDATER.set(this, JsonUtil.getLong(json, "numberOfOtherOperations", -1L));
        NUMBER_OF_EVENTS_UPDATER.set(this, JsonUtil.getLong(json, "numberOfEvents", -1L));
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.ownedItemCount);
        out.writeInt(this.backupItemCount);
        out.writeLong(this.minAge);
        out.writeLong(this.maxAge);
        out.writeLong(this.aveAge);
        out.writeLong(this.creationTime);
        out.writeLong(this.numberOfOffers);
        out.writeLong(this.numberOfPolls);
        out.writeLong(this.numberOfRejectedOffers);
        out.writeLong(this.numberOfEmptyPolls);
        out.writeLong(this.numberOfOtherOperations);
        out.writeLong(this.numberOfEvents);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.ownedItemCount = in.readInt();
        this.backupItemCount = in.readInt();
        this.minAge = in.readLong();
        this.maxAge = in.readLong();
        this.aveAge = in.readLong();
        this.creationTime = in.readLong();
        NUMBER_OF_OFFERS_UPDATER.set(this, in.readLong());
        NUMBER_OF_POLLS_UPDATER.set(this, in.readLong());
        NUMBER_OF_REJECTED_OFFERS_UPDATER.set(this, in.readLong());
        NUMBER_OF_EMPTY_POLLS_UPDATER.set(this, in.readLong());
        NUMBER_OF_OTHER_OPERATIONS_UPDATER.set(this, in.readLong());
        NUMBER_OF_EVENTS_UPDATER.set(this, in.readLong());
    }

    @Override
    public long getMinAge() {
        return this.minAge;
    }

    public void setMinAge(long minAge) {
        this.minAge = minAge;
    }

    @Override
    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    public long getAvgAge() {
        return this.aveAge;
    }

    public void setAveAge(long aveAge) {
        this.aveAge = aveAge;
    }

    @Override
    public long getOwnedItemCount() {
        return this.ownedItemCount;
    }

    public void setOwnedItemCount(int ownedItemCount) {
        this.ownedItemCount = ownedItemCount;
    }

    @Override
    public long getBackupItemCount() {
        return this.backupItemCount;
    }

    public void setBackupItemCount(int backupItemCount) {
        this.backupItemCount = backupItemCount;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    public long total() {
        return this.numberOfOffers + this.numberOfPolls + this.numberOfOtherOperations;
    }

    @Override
    public long getOfferOperationCount() {
        return this.numberOfOffers;
    }

    @Override
    public long getRejectedOfferOperationCount() {
        return this.numberOfRejectedOffers;
    }

    @Override
    public long getPollOperationCount() {
        return this.numberOfPolls;
    }

    @Override
    public long getEmptyPollOperationCount() {
        return this.numberOfEmptyPolls;
    }

    @Override
    public long getOtherOperationsCount() {
        return this.numberOfOtherOperations;
    }

    public void incrementOtherOperations() {
        NUMBER_OF_OTHER_OPERATIONS_UPDATER.incrementAndGet(this);
    }

    public void incrementOffers() {
        NUMBER_OF_OFFERS_UPDATER.incrementAndGet(this);
    }

    public void incrementRejectedOffers() {
        NUMBER_OF_REJECTED_OFFERS_UPDATER.incrementAndGet(this);
    }

    public void incrementPolls() {
        NUMBER_OF_POLLS_UPDATER.incrementAndGet(this);
    }

    public void incrementEmptyPolls() {
        NUMBER_OF_EMPTY_POLLS_UPDATER.incrementAndGet(this);
    }

    public void incrementReceivedEvents() {
        NUMBER_OF_EVENTS_UPDATER.incrementAndGet(this);
    }

    @Override
    public long getEventOperationCount() {
        return this.numberOfEvents;
    }
}

