/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.HashUserRealm;
import org.mortbay.http.HttpRequest;
import org.mortbay.util.Loader;
import org.mortbay.util.Resource;

public class JDBCUserRealm
extends HashUserRealm {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$http$JDBCUserRealm == null ? (class$org$mortbay$http$JDBCUserRealm = JDBCUserRealm.class$("org.mortbay.http.JDBCUserRealm")) : class$org$mortbay$http$JDBCUserRealm));
    private String _jdbcDriver;
    private String _url;
    private String _userName;
    private String _password;
    private String _userTable;
    private String _userTableKey;
    private String _userTableUserField;
    private String _userTablePasswordField;
    private String _roleTable;
    private String _roleTableKey;
    private String _roleTableRoleField;
    private String _userRoleTable;
    private String _userRoleTableUserKey;
    private String _userRoleTableRoleKey;
    private int _cacheTime;
    private long _lastHashPurge;
    private Connection _con;
    private String _userSql;
    private String _roleSql;
    static /* synthetic */ Class class$org$mortbay$http$JDBCUserRealm;

    public JDBCUserRealm(String name) {
        super(name);
    }

    public JDBCUserRealm(String name, String config) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        super(name);
        this.loadConfig(config);
        Loader.loadClass(this.getClass(), this._jdbcDriver).newInstance();
        this.connectDatabase();
    }

    public void loadConfig(String config) throws IOException {
        Properties properties = new Properties();
        Resource resource = Resource.newResource(config);
        properties.load(resource.getInputStream());
        this._jdbcDriver = properties.getProperty("jdbcdriver");
        this._url = properties.getProperty("url");
        this._userName = properties.getProperty("username");
        this._password = properties.getProperty("password");
        this._userTable = properties.getProperty("usertable");
        this._userTableKey = properties.getProperty("usertablekey");
        this._userTableUserField = properties.getProperty("usertableuserfield");
        this._userTablePasswordField = properties.getProperty("usertablepasswordfield");
        this._roleTable = properties.getProperty("roletable");
        this._roleTableKey = properties.getProperty("roletablekey");
        this._roleTableRoleField = properties.getProperty("roletablerolefield");
        this._userRoleTable = properties.getProperty("userroletable");
        this._userRoleTableUserKey = properties.getProperty("userroletableuserkey");
        this._userRoleTableRoleKey = properties.getProperty("userroletablerolekey");
        this._cacheTime = new Integer(properties.getProperty("cachetime"));
        if ((this._jdbcDriver == null || this._jdbcDriver.equals("") || this._url == null || this._url.equals("") || this._userName == null || this._userName.equals("") || this._password == null || this._cacheTime < 0) && log.isDebugEnabled()) {
            log.debug((Object)("UserRealm " + this.getName() + " has not been properly configured"));
        }
        this._cacheTime *= 1000;
        this._lastHashPurge = 0L;
        this._userSql = "select " + this._userTableKey + "," + this._userTablePasswordField + " from " + this._userTable + " where " + this._userTableUserField + " = ?";
        this._roleSql = "select r." + this._roleTableRoleField + " from " + this._roleTable + " r, " + this._userRoleTable + " u where u." + this._userRoleTableUserKey + " = ?" + " and r." + this._roleTableKey + " = u." + this._userRoleTableRoleKey;
    }

    public void logout(Principal user) {
        this.remove(user.getName());
    }

    public void connectDatabase() {
        try {
            this._con = DriverManager.getConnection(this._url, this._userName, this._password);
        }
        catch (SQLException e) {
            log.warn((Object)("UserRealm " + this.getName() + " could not connect to database; will try later"), (Throwable)e);
        }
    }

    public Principal authenticate(String username, Object credentials, HttpRequest request) {
        if (credentials == null) {
            return this.authenticate(username, null, request);
        }
        if (credentials instanceof String) {
            return this.authenticate(username, (String)credentials, request);
        }
        return this.authenticate(username, credentials.toString(), request);
    }

    public synchronized Principal authenticate(String username, String credentials, HttpRequest request) {
        Principal user;
        long now = System.currentTimeMillis();
        if (now - this._lastHashPurge > (long)this._cacheTime || this._cacheTime == 0) {
            super.clear();
            this._roles.clear();
            this._lastHashPurge = now;
        }
        if ((user = (Principal)super.get(username)) == null) {
            this.loadUser(username);
            user = (Principal)super.get(username);
        }
        return super.authenticate(username, credentials, request);
    }

    private void loadUser(String username) {
        try {
            if (null == this._con) {
                this.connectDatabase();
            }
            if (null == this._con) {
                throw new SQLException("Can't connect to database");
            }
            PreparedStatement stat = this._con.prepareStatement(this._userSql);
            stat.setObject(1, username);
            ResultSet rs = stat.executeQuery();
            if (rs.next()) {
                Object key = rs.getObject(this._userTableKey);
                this.put(username, rs.getString(this._userTablePasswordField));
                stat.close();
                stat = this._con.prepareStatement(this._roleSql);
                stat.setObject(1, key);
                rs = stat.executeQuery();
                while (rs.next()) {
                    this.addUserToRole(username, rs.getString(this._roleTableRoleField));
                }
                stat.close();
            }
        }
        catch (SQLException e) {
            log.warn((Object)("UserRealm " + this.getName() + " could not load user information from database"), (Throwable)e);
            this.connectDatabase();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

