/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.sentinel.client;

import com.voxeo.sentinel.local.LocalSentinel;
import com.voxeo.sentinel.protocols.SentinelClientProtocol;
import com.voxeo.versioning.Module;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SentinelClient {
    private static final Logger Log = Logger.getLogger(SentinelClient.class);
    private final String localIP = "127.0.0.1";
    private final int[] PORT_SEQ = new int[]{101, 201, 301, 401, 501};
    private final int[] RANGE_SEQ = new int[]{9000, 8000, 7000, 6000, 5000};
    private LocalSentinel currentSentinel = null;
    private Integer configuredPort = null;
    private Module localModule;
    private int sentinelPort;
    private boolean runSentinel = true;
    private boolean daemonMode = false;
    private boolean clientFailed = false;
    private Socket clientSocket = null;
    private BufferedReader inIO = null;
    private PrintWriter outIO = null;
    private ObjectOutputStream objOutIO = null;

    public SentinelClient(Module localComponent) {
        this.localModule = localComponent;
        this.loadProperties();
        Thread clientGo = new Thread("SentinelClient"){

            public void run() {
                while (SentinelClient.this.runSentinel) {
                    SentinelClient.this.startDaemonMode();
                }
            }
        };
        clientGo.start();
    }

    private void closeIO() {
        try {
            if (this.inIO != null) {
                this.inIO.close();
            }
            if (this.outIO != null) {
                this.outIO.close();
            }
            if (this.objOutIO != null) {
                this.objOutIO.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startDaemonMode() {
        this.daemonMode = true;
        while (this.daemonMode) {
            Log.debug((Object)"SentinelClient::startDaemonMode() - Trying..");
            if (this.connectToSentinel()) {
                SentinelClientProtocol scp = new SentinelClientProtocol(this.inIO, this.outIO, this);
                this.clientFailed = !scp.sndModule();
                continue;
            }
            this.createNewSentinel();
        }
        this.closeIO();
    }

    private void createNewSentinel() {
        this.currentSentinel = this.configuredPort != null ? new LocalSentinel(this.configuredPort) : new LocalSentinel();
        this.currentSentinel.start();
        while (!this.currentSentinel.isListening()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
    }

    public void stopDaemonMode() {
        this.daemonMode = false;
    }

    public void loadProperties() {
        try {
            Properties props = new Properties();
            InputStream in = this.getClass().getResourceAsStream("/com/voxeo/versioning/versioning.properties");
            props.load(in);
            this.configuredPort = props.getProperty("sentinel.local.port") != null ? new Integer(props.getProperty("sentinel.local.port")) : null;
            this.runSentinel = props.getProperty("sentinel.local.active") != null ? new Boolean(props.getProperty("sentinel.local.active")) : true;
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updatePropertyFile() {
        try {
            Properties props = new Properties();
            props.setProperty("sentinel.local.port", "" + this.sentinelPort);
            FileOutputStream out = new FileOutputStream(new File(this.getClass().getResource("/com/voxeo/versioning").getFile() + "/versioning.properties"));
            props.store(out, "");
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            Log.error((Object)("SentinelClient::updatePropertyFile() - Exception: " + e.toString()), (Throwable)e);
        }
    }

    private boolean connectToSentinel() {
        boolean returnValue = false;
        Socket localSocket = null;
        int currRangeSeq = 0;
        int currPortSeq = 0;
        Log.debug((Object)("CLIENT FAILED " + this.clientFailed));
        try {
            int k;
            if (this.configuredPort != null && !this.clientFailed) {
                try {
                    localSocket = new Socket("127.0.0.1", (int)this.configuredPort);
                    if (this.assignIOFromSocket(localSocket)) {
                        this.sentinelPort = this.configuredPort;
                        returnValue = true;
                    }
                }
                catch (Exception e) {
                    returnValue = false;
                    Log.debug((Object)("SentinelClient::connectToSentinel() - On the configured port " + this.configuredPort + " Exception: "), (Throwable)e);
                }
            } else if (this.clientFailed) {
                this.clientFailed = false;
                if (this.sentinelPort == 0) {
                    this.sentinelPort = this.RANGE_SEQ[currRangeSeq] + this.PORT_SEQ[currPortSeq];
                }
                for (int i = currRangeSeq; i < this.RANGE_SEQ.length; ++i) {
                    for (k = currPortSeq; k < this.PORT_SEQ.length; ++k) {
                        if (this.sentinelPort - (this.RANGE_SEQ[i] + this.PORT_SEQ[k]) != 0) continue;
                        this.sentinelPort = 0;
                        if (k + 1 < this.PORT_SEQ.length) {
                            currRangeSeq = i;
                            currPortSeq = k + 1;
                            break;
                        }
                        if (i + 1 < this.RANGE_SEQ.length) {
                            currRangeSeq = i + 1;
                            currPortSeq = 0;
                            break;
                        }
                        currRangeSeq = 0;
                        currPortSeq = 0;
                        break;
                    }
                    if (this.sentinelPort == 0) break;
                }
            }
            if (!returnValue) {
                for (int i = currRangeSeq; i < this.RANGE_SEQ.length; ++i) {
                    for (k = currPortSeq; k < this.PORT_SEQ.length; ++k) {
                        try {
                            localSocket = new Socket("127.0.0.1", this.RANGE_SEQ[i] + this.PORT_SEQ[k]);
                            if (!this.assignIOFromSocket(localSocket)) continue;
                            this.sentinelPort = this.RANGE_SEQ[i] + this.PORT_SEQ[k];
                            break;
                        }
                        catch (Exception e) {
                            Log.debug((Object)("SentinelClient::connectToSentinel() - On port " + (this.RANGE_SEQ[i] + this.PORT_SEQ[k]) + " Failed."));
                            Thread.sleep(100L);
                        }
                    }
                    if (localSocket != null) break;
                }
            }
            if (localSocket != null && localSocket.isConnected()) {
                this.clientSocket = localSocket;
                if (this.currentSentinel != null && this.sentinelPort != this.currentSentinel.getPort()) {
                    Log.info((Object)"FOUND A BETTER SENTINEL, TURNING MINE OFF");
                    this.currentSentinel.turnOff();
                }
                returnValue = true;
            }
        }
        catch (Exception e) {
            Log.debug((Object)"SentinelClient::connectToSentinel() - Exception: ", (Throwable)e);
            returnValue = false;
        }
        return returnValue;
    }

    private boolean assignIOFromSocket(Socket incomingSocket) {
        boolean returnValue = false;
        try {
            incomingSocket.setSoTimeout(1000);
            this.inIO = new BufferedReader(new InputStreamReader(incomingSocket.getInputStream()));
            this.outIO = new PrintWriter(incomingSocket.getOutputStream(), true);
            this.objOutIO = new ObjectOutputStream(incomingSocket.getOutputStream());
            returnValue = true;
        }
        catch (Exception e) {
            returnValue = false;
        }
        return returnValue;
    }

    public Module getModule() {
        return this.localModule;
    }

    public void setSocketTO(int incoming) {
        try {
            this.clientSocket.setSoTimeout(incoming);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        new SentinelClient(new Module("TestModule", "1.2.3.5", "01/08/1983"));
    }
}

