/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jitsi.videobridge.Channel;

public class Endpoint {
    private final List<WeakReference<Channel>> channels = new LinkedList<WeakReference<Channel>>();
    private final String id;

    public Endpoint(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChannel(Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        List<WeakReference<Channel>> list = this.channels;
        synchronized (list) {
            Iterator<WeakReference<Channel>> i = this.channels.iterator();
            while (i.hasNext()) {
                Channel c = (Channel)((Object)i.next().get());
                if (c == null) {
                    i.remove();
                    continue;
                }
                if (!((Object)((Object)c)).equals((Object)channel)) continue;
                return false;
            }
            return this.channels.add(new WeakReference<Channel>(channel));
        }
    }

    public final String getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChannel(Channel channel) {
        if (channel == null) {
            return false;
        }
        List<WeakReference<Channel>> list = this.channels;
        synchronized (list) {
            Iterator<WeakReference<Channel>> i = this.channels.iterator();
            while (i.hasNext()) {
                Channel c = (Channel)((Object)i.next().get());
                if (c == null) {
                    i.remove();
                    continue;
                }
                if (!((Object)((Object)c)).equals((Object)channel)) continue;
                i.remove();
                return true;
            }
        }
        return false;
    }
}

