/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetCusaxUtils;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderActivator;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallEvent;
import net.java.sip.communicator.service.protocol.event.CallListener;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class SingleCallInProgressPolicy {
    private static final String ACCOUNT_PROPERTY_REJECT_IN_CALL_ON_DND = "RejectIncomingCallsWhenDnD";
    private static final Logger logger = Logger.getLogger(SingleCallInProgressPolicy.class);
    private static final String PNAME_CALL_WAITING_DISABLED = "net.java.sip.communicator.impl.protocol.CallWaitingDisabled";
    private static final String PNAME_ON_THE_PHONE_STATUS_ENABLED = "net.java.sip.communicator.impl.protocol.OnThePhoneStatusPolicy.enabled";
    private static final String PNAME_REJECT_IN_CALL_ON_DND = "net.java.sip.communicator.impl.protocol.RejectIncomingCallsWhenDnD";
    private static final String PNAME_SINGLE_CALL_IN_PROGRESS_POLICY_ENABLED = "net.java.sip.communicator.impl.protocol.SingleCallInProgressPolicy.enabled";
    private final BundleContext bundleContext;
    private final List<Call> calls = new ArrayList<Call>();
    private final SingleCallInProgressPolicyListener listener = new SingleCallInProgressPolicyListener();
    private final OnThePhoneStatusPolicy onThePhoneStatusPolicy = new OnThePhoneStatusPolicy();

    public SingleCallInProgressPolicy(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.bundleContext.addServiceListener((ServiceListener)this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCallListener(Call call) {
        List<Call> list = this.calls;
        synchronized (list) {
            CallState callState;
            if (!this.calls.contains(call) && (callState = call.getCallState()) != null && !callState.equals(CallState.CALL_ENDED)) {
                this.calls.add(call);
            }
        }
        call.addCallChangeListener(this.listener);
    }

    private void addOperationSetBasicTelephonyListener(OperationSetBasicTelephony<? extends ProtocolProviderService> telephony) {
        telephony.addCallListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callStateChanged(CallChangeEvent ev) {
        Call call = ev.getSourceCall();
        if (CallState.CALL_INITIALIZATION.equals(ev.getOldValue()) && CallState.CALL_IN_PROGRESS.equals(call.getCallState()) && ProtocolProviderActivator.getConfigurationService().getBoolean(PNAME_SINGLE_CALL_IN_PROGRESS_POLICY_ENABLED, true)) {
            CallConference conference = call.getConference();
            List<Call> list = this.calls;
            synchronized (list) {
                for (Call otherCall : this.calls) {
                    boolean putOnHold;
                    if (call.equals(otherCall) || !CallState.CALL_IN_PROGRESS.equals(otherCall.getCallState())) continue;
                    CallConference otherConference = otherCall.getConference();
                    if (conference == null) {
                        putOnHold = otherConference == null;
                    } else {
                        boolean bl = putOnHold = conference != otherConference;
                    }
                    if (!putOnHold) continue;
                    this.putOnHold(otherCall);
                }
            }
        }
        this.onThePhoneStatusPolicy.callStateChanged(ev);
    }

    public void dispose() {
        this.bundleContext.removeServiceListener((ServiceListener)this.listener);
    }

    private void handleCallEvent(int type, CallEvent ev) {
        Call call = ev.getSourceCall();
        switch (type) {
            case 3: {
                this.removeCallListener(call);
                break;
            }
            case 1: 
            case 2: {
                this.addCallListener(call);
            }
        }
        this.onThePhoneStatusPolicy.handleCallEvent(type, ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incomingCallReceived(CallEvent ev) {
        Call call = ev.getSourceCall();
        if (CallState.CALL_INITIALIZATION.equals(call.getCallState())) {
            ConfigurationService config = ProtocolProviderActivator.getConfigurationService();
            if (config.getBoolean(PNAME_CALL_WAITING_DISABLED, false)) {
                boolean rejectCallWithBusyHere = false;
                List<Call> list = this.calls;
                synchronized (list) {
                    for (Call otherCall : this.calls) {
                        if (call.equals(otherCall) || !CallState.CALL_IN_PROGRESS.equals(otherCall.getCallState())) continue;
                        rejectCallWithBusyHere = true;
                        break;
                    }
                }
                if (rejectCallWithBusyHere) {
                    this.rejectCallWithBusyHere(call);
                    return;
                }
            }
            ProtocolProviderService provider = call.getProtocolProvider();
            if (config.getBoolean(PNAME_REJECT_IN_CALL_ON_DND, false) || provider.getAccountID().getAccountPropertyBoolean(ACCOUNT_PROPERTY_REJECT_IN_CALL_ON_DND, false)) {
                ProtocolProviderService linkedCusaxProvider;
                OperationSetCusaxUtils cusaxOpSet;
                OperationSetPresence presence = provider.getOperationSet(OperationSetPresence.class);
                if (presence == null && (cusaxOpSet = provider.getOperationSet(OperationSetCusaxUtils.class)) != null && (linkedCusaxProvider = cusaxOpSet.getLinkedCusaxProvider()) != null) {
                    presence = linkedCusaxProvider.getOperationSet(OperationSetPresence.class);
                }
                if (presence != null) {
                    int presenceStatus;
                    int n = presenceStatus = presence == null ? 50 : presence.getPresenceStatus().getStatus();
                    if (presenceStatus > 20 && presenceStatus <= 31) {
                        this.rejectCallWithBusyHere(call);
                        return;
                    }
                }
            }
        }
        this.handleCallEvent(2, ev);
    }

    private void putOnHold(Call call) {
        OperationSetBasicTelephony telephony = call.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
        if (telephony != null) {
            Iterator<? extends CallPeer> peerIter = call.getCallPeers();
            while (peerIter.hasNext()) {
                CallPeer peer = peerIter.next();
                CallPeerState peerState = peer.getState();
                if (CallPeerState.DISCONNECTED.equals(peerState) || CallPeerState.FAILED.equals(peerState) || CallPeerState.isOnHold(peerState)) continue;
                try {
                    telephony.putOnHold(peer);
                }
                catch (OperationFailedException ex) {
                    logger.error((Object)("Failed to put " + peer + " on hold."), (Throwable)ex);
                }
            }
        }
    }

    private void rejectCallWithBusyHere(Call call) {
        if (call.getCallPeerCount() == 1) {
            CallPeer peer = call.getCallPeers().next();
            OperationSetBasicTelephony telephony = call.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
            if (telephony != null) {
                try {
                    telephony.hangupCallPeer(peer, 486, null);
                }
                catch (OperationFailedException ex) {
                    logger.error((Object)("Failed to reject " + peer), (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCallListener(Call call) {
        call.removeCallChangeListener(this.listener);
        List<Call> list = this.calls;
        synchronized (list) {
            this.calls.remove(call);
        }
    }

    private void removeOperationSetBasicTelephonyListener(OperationSetBasicTelephony<? extends ProtocolProviderService> telephony) {
        telephony.removeCallListener(this.listener);
    }

    private void serviceChanged(ServiceEvent ev) {
        OperationSetBasicTelephony telephony;
        Object service = this.bundleContext.getService(ev.getServiceReference());
        if (service instanceof ProtocolProviderService && (telephony = ((ProtocolProviderService)service).getOperationSet(OperationSetBasicTelephony.class)) != null) {
            switch (ev.getType()) {
                case 1: {
                    this.addOperationSetBasicTelephonyListener(telephony);
                    break;
                }
                case 4: {
                    this.removeOperationSetBasicTelephonyListener(telephony);
                }
            }
        }
    }

    private class SingleCallInProgressPolicyListener
    implements CallChangeListener,
    CallListener,
    ServiceListener {
        private SingleCallInProgressPolicyListener() {
        }

        @Override
        public void callEnded(CallEvent ev) {
            SingleCallInProgressPolicy.this.handleCallEvent(3, ev);
        }

        @Override
        public void callPeerAdded(CallPeerEvent ev) {
        }

        @Override
        public void callPeerRemoved(CallPeerEvent ev) {
        }

        @Override
        public void callStateChanged(CallChangeEvent ev) {
            if (ev.getEventType().equals("CallState")) {
                SingleCallInProgressPolicy.this.callStateChanged(ev);
            }
        }

        @Override
        public void incomingCallReceived(CallEvent ev) {
            SingleCallInProgressPolicy.this.incomingCallReceived(ev);
        }

        @Override
        public void outgoingCallCreated(CallEvent ev) {
            SingleCallInProgressPolicy.this.handleCallEvent(1, ev);
        }

        public void serviceChanged(ServiceEvent ev) {
            SingleCallInProgressPolicy.this.serviceChanged(ev);
        }
    }

    private class OnThePhoneStatusPolicy {
        private final Pattern onThePhonePresenceStatusNameWhitespace = Pattern.compile("\\p{Space}");
        private final Map<ProtocolProviderService, PresenceStatus> presenceStatuses = Collections.synchronizedMap(new WeakHashMap());

        private OnThePhoneStatusPolicy() {
        }

        public void callStateChanged(CallChangeEvent ev) {
            Call call = ev.getSourceCall();
            Object oldCallState = ev.getOldValue();
            CallState newCallState = call.getCallState();
            if (CallState.CALL_INITIALIZATION.equals(oldCallState) && CallState.CALL_IN_PROGRESS.equals(newCallState) || CallState.CALL_IN_PROGRESS.equals(oldCallState) && CallState.CALL_ENDED.equals(newCallState)) {
                this.run();
            }
        }

        private PresenceStatus findOnThePhonePresenceStatus(OperationSetPresence presence) {
            Iterator<PresenceStatus> i = presence.getSupportedStatusSet();
            while (i.hasNext()) {
                PresenceStatus presenceStatus = i.next();
                if (!this.onThePhonePresenceStatusNameWhitespace.matcher(presenceStatus.getStatusName()).replaceAll("").equalsIgnoreCase("OnThePhone")) continue;
                return presenceStatus;
            }
            return null;
        }

        private PresenceStatus forgetPresenceStatus(ProtocolProviderService pps) {
            return this.presenceStatuses.remove(pps);
        }

        private void forgetPresenceStatuses() {
            this.presenceStatuses.clear();
        }

        public void handleCallEvent(int type, CallEvent ev) {
            this.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isOnThePhone() {
            List list = SingleCallInProgressPolicy.this.calls;
            synchronized (list) {
                for (Call call : SingleCallInProgressPolicy.this.calls) {
                    if (!CallState.CALL_IN_PROGRESS.equals(call.getCallState())) continue;
                    return true;
                }
            }
            return false;
        }

        private void publishPresenceStatus(OperationSetPresence presence, PresenceStatus presenceStatus) {
            block3: {
                try {
                    presence.publishPresenceStatus(presenceStatus, null);
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(t instanceof ThreadDeath)) break block3;
                    throw (ThreadDeath)t;
                }
            }
        }

        private PresenceStatus rememberPresenceStatus(ProtocolProviderService pps, PresenceStatus presenceStatus) {
            return this.presenceStatuses.put(pps, presenceStatus);
        }

        private void run() {
            ServiceReference[] ppsRefs;
            if (!ProtocolProviderActivator.getConfigurationService().getBoolean(SingleCallInProgressPolicy.PNAME_ON_THE_PHONE_STATUS_ENABLED, false)) {
                this.forgetPresenceStatuses();
                return;
            }
            try {
                ppsRefs = SingleCallInProgressPolicy.this.bundleContext.getServiceReferences(ProtocolProviderService.class.getName(), null);
            }
            catch (InvalidSyntaxException ise) {
                ppsRefs = null;
            }
            if (ppsRefs == null || ppsRefs.length == 0) {
                this.forgetPresenceStatuses();
            } else {
                boolean isOnThePhone = this.isOnThePhone();
                for (ServiceReference ppsRef : ppsRefs) {
                    ProtocolProviderService pps = (ProtocolProviderService)SingleCallInProgressPolicy.this.bundleContext.getService(ppsRef);
                    if (pps == null) continue;
                    OperationSetPresence presence = pps.getOperationSet(OperationSetPresence.class);
                    if (presence == null) {
                        this.forgetPresenceStatus(pps);
                        continue;
                    }
                    if (pps.isRegistered()) {
                        PresenceStatus presenceStatus;
                        PresenceStatus onThePhonePresenceStatus = this.findOnThePhonePresenceStatus(presence);
                        if (onThePhonePresenceStatus == null) {
                            this.forgetPresenceStatus(pps);
                            continue;
                        }
                        if (isOnThePhone) {
                            presenceStatus = presence.getPresenceStatus();
                            if (presenceStatus == null) {
                                this.forgetPresenceStatus(pps);
                                continue;
                            }
                            if (onThePhonePresenceStatus.equals(presenceStatus)) continue;
                            this.publishPresenceStatus(presence, onThePhonePresenceStatus);
                            if (onThePhonePresenceStatus.equals(presence.getPresenceStatus())) {
                                this.rememberPresenceStatus(pps, presenceStatus);
                                continue;
                            }
                            this.forgetPresenceStatus(pps);
                            continue;
                        }
                        presenceStatus = this.forgetPresenceStatus(pps);
                        if (presenceStatus == null || !onThePhonePresenceStatus.equals(presence.getPresenceStatus())) continue;
                        this.publishPresenceStatus(presence, presenceStatus);
                        continue;
                    }
                    this.forgetPresenceStatus(pps);
                }
            }
        }
    }
}

