/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectJabberImpl;
import net.java.sip.communicator.service.protocol.WhiteboardPoint;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObjectCircle;
import net.java.sip.communicator.util.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WhiteboardObjectCircleJabberImpl
extends WhiteboardObjectJabberImpl
implements WhiteboardObjectCircle {
    private static final Logger logger = Logger.getLogger(WhiteboardObjectCircleJabberImpl.class);
    private boolean fill;
    private WhiteboardPoint whiteboardPoint;
    private int bgColor;
    private double radius;

    public WhiteboardObjectCircleJabberImpl() {
    }

    public WhiteboardObjectCircleJabberImpl(String xml) {
        block7: {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
                Document doc = builder.parse(in);
                Element e = doc.getDocumentElement();
                String elementName = e.getNodeName();
                if (elementName.equals("circle")) {
                    String id = e.getAttribute("id");
                    double cx = Double.parseDouble(e.getAttribute("cx"));
                    double cy = Double.parseDouble(e.getAttribute("cy"));
                    double r = Double.parseDouble(e.getAttribute("r"));
                    String stroke = e.getAttribute("stroke");
                    String stroke_width = e.getAttribute("stroke-width");
                    String fill = e.getAttribute("fill");
                    this.setID(id);
                    this.setWhiteboardPoint(new WhiteboardPoint(cx, cy));
                    this.setRadius(r);
                    this.setFill(!fill.equals("none"));
                    this.setThickness(Integer.parseInt(stroke_width));
                    this.setColor(Color.decode(stroke).getRGB());
                }
            }
            catch (ParserConfigurationException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem WhiteboardObject : " + xml));
                }
            }
            catch (IOException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem WhiteboardObject : " + xml));
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug((Object)("Problem WhiteboardObject : " + xml));
            }
        }
    }

    public WhiteboardPoint getWhiteboardPoint() {
        return this.whiteboardPoint;
    }

    public void setWhiteboardPoint(WhiteboardPoint whiteboardPoint) {
        this.whiteboardPoint = whiteboardPoint;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }

    public void setBackgroundColor(int backColor) {
        this.bgColor = backColor;
    }

    public int getBackgroundColor() {
        return this.bgColor;
    }

    @Override
    public String toXML() {
        String s = "<circle id=\"#i\" cx=\"#cx\" cy=\"#cy\" r=\"#r\" fill=\"#f\" stroke=\"#s\" stroke-width=\"#ow\" />";
        s = s.replaceAll("#i", this.getID());
        s = s.replaceAll("#s", this.colorToHex(this.getColor()));
        s = s.replaceAll("#ow", "" + this.getThickness());
        WhiteboardPoint p = this.getWhiteboardPoint();
        s = s.replaceAll("#cx", "" + p.getX());
        s = s.replaceAll("#cy", "" + p.getY());
        s = s.replaceAll("#r", "" + this.getRadius());
        s = s.replaceAll("#f", this.fill ? this.colorToHex(this.getColor()) : "none");
        return s;
    }
}

