/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetContactCapabilitiesJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.caps.CapsPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.caps.EntityCapsManager;
import net.java.sip.communicator.service.protocol.OperationSetContactCapabilities;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.NodeInformationProvider;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

public class ScServiceDiscoveryManager
implements PacketInterceptor,
NodeInformationProvider {
    private static final Logger logger = Logger.getLogger(ScServiceDiscoveryManager.class);
    private static final boolean CACHE_NON_CAPS = true;
    private final Map<String, DiscoverInfo> nonCapsCache = new ConcurrentHashMap<String, DiscoverInfo>();
    private final EntityCapsManager capsManager;
    private final ServiceDiscoveryManager discoveryManager;
    private final ProtocolProviderServiceJabberImpl parentProvider;
    private final XMPPConnection connection;
    private final List<String> features;
    private final List<String> unmodifiableFeatures;
    private final List<DiscoverInfo.Identity> identities;
    private final List<String> extCapabilities = new ArrayList<String>();
    private DiscoveryInfoRetriever retriever = new DiscoveryInfoRetriever();

    public ScServiceDiscoveryManager(ProtocolProviderServiceJabberImpl parentProvider, String[] featuresToRemove, String[] featuresToAdd) {
        this.parentProvider = parentProvider;
        this.connection = parentProvider.getConnection();
        this.discoveryManager = ServiceDiscoveryManager.getInstanceFor((Connection)this.connection);
        this.features = new ArrayList<String>();
        this.unmodifiableFeatures = Collections.unmodifiableList(this.features);
        this.identities = new ArrayList<DiscoverInfo.Identity>();
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("client", ServiceDiscoveryManager.getIdentityName());
        identity.setType(ServiceDiscoveryManager.getIdentityType());
        this.identities.add(identity);
        this.discoveryManager.addFeature("http://jabber.org/protocol/caps");
        if (featuresToRemove != null) {
            for (String featureToRemove : featuresToRemove) {
                this.discoveryManager.removeFeature(featureToRemove);
            }
        }
        if (featuresToAdd != null) {
            for (String featureToAdd : featuresToAdd) {
                if (this.discoveryManager.includesFeature(featureToAdd)) continue;
                this.discoveryManager.addFeature(featureToAdd);
            }
        }
        this.capsManager = new EntityCapsManager();
        this.capsManager.addPacketListener(this.connection);
        this.initFeatures();
        this.updateEntityCapsVersion();
        this.connection.addPacketInterceptor((PacketInterceptor)this, (PacketFilter)new PacketTypeFilter(Presence.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(String feature) {
        List<String> list = this.features;
        synchronized (list) {
            this.features.add(feature);
            this.discoveryManager.addFeature(feature);
        }
        this.updateEntityCapsVersion();
    }

    private void updateEntityCapsVersion() {
        if (this.connection != null && this.capsManager != null) {
            this.capsManager.calculateEntityCapsVersion(this.getOwnDiscoverInfo());
        }
    }

    public List<String> getFeatures() {
        return this.unmodifiableFeatures;
    }

    public DiscoverInfo getOwnDiscoverInfo() {
        DiscoverInfo di = new DiscoverInfo();
        di.setType(IQ.Type.RESULT);
        di.setNode(this.capsManager.getNode() + "#" + this.getEntityCapsVersion());
        this.addDiscoverInfoTo(di);
        return di;
    }

    private String getEntityCapsVersion() {
        return this.capsManager == null ? null : this.capsManager.getCapsVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDiscoverInfoTo(DiscoverInfo response) {
        List<String> features;
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("client", ServiceDiscoveryManager.getIdentityName());
        identity.setType(ServiceDiscoveryManager.getIdentityType());
        response.addIdentity(identity);
        if (!response.containsFeature("http://jabber.org/protocol/caps")) {
            response.addFeature("http://jabber.org/protocol/caps");
        }
        List<String> list = features = this.getFeatures();
        synchronized (list) {
            for (String feature : features) {
                if (response.containsFeature(feature)) continue;
                response.addFeature(feature);
            }
        }
    }

    public boolean includesFeature(String feature) {
        return this.discoveryManager.includesFeature(feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeature(String feature) {
        List<String> list = this.features;
        synchronized (list) {
            this.features.remove(feature);
            this.discoveryManager.removeFeature(feature);
        }
        this.updateEntityCapsVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtFeature(String ext) {
        List<String> list = this.extCapabilities;
        synchronized (list) {
            this.extCapabilities.add(ext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtFeature(String ext) {
        List<String> list = this.extCapabilities;
        synchronized (list) {
            this.extCapabilities.remove(ext);
        }
    }

    public synchronized String getExtFeatures() {
        StringBuilder bldr = new StringBuilder("");
        for (String e : this.extCapabilities) {
            bldr.append(e);
            bldr.append(" ");
        }
        return bldr.toString();
    }

    public void interceptPacket(Packet packet) {
        if (packet instanceof Presence && this.capsManager != null) {
            String ver = this.getEntityCapsVersion();
            CapsPacketExtension caps = new CapsPacketExtension(this.getExtFeatures(), this.capsManager.getNode(), "sha-1", ver);
            this.discoveryManager.setNodeInformationProvider(caps.getNode() + "#" + caps.getVersion(), (NodeInformationProvider)this);
            packet.addExtension((PacketExtension)caps);
        }
    }

    public List<DiscoverItems.Item> getNodeItems() {
        return null;
    }

    public List<String> getNodeFeatures() {
        return this.getFeatures();
    }

    public List<DiscoverInfo.Identity> getNodeIdentities() {
        return this.identities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFeatures() {
        Iterator defaultFeatures = this.discoveryManager.getFeatures();
        List<String> list = this.features;
        synchronized (list) {
            while (defaultFeatures.hasNext()) {
                String feature = (String)defaultFeatures.next();
                this.features.add(feature);
            }
        }
    }

    public DiscoverInfo discoverInfo(String entityID) throws XMPPException {
        DiscoverInfo discoverInfo = this.capsManager.getDiscoverInfoByUser(entityID);
        if (discoverInfo != null) {
            return discoverInfo;
        }
        EntityCapsManager.Caps caps = this.capsManager.getCapsByUser(entityID);
        if (!(caps != null && caps.isValid(discoverInfo) || (discoverInfo = this.nonCapsCache.get(entityID)) == null)) {
            return discoverInfo;
        }
        discoverInfo = this.discoverInfo(entityID, caps == null ? null : caps.getNodeVer());
        if (caps != null && !caps.isValid(discoverInfo)) {
            if (!caps.hash.equals("")) {
                logger.error((Object)("Invalid DiscoverInfo for " + caps.getNodeVer() + ": " + discoverInfo));
            }
            caps = null;
        }
        if (caps == null) {
            this.nonCapsCache.put(entityID, discoverInfo);
        } else {
            EntityCapsManager.addDiscoverInfoByCaps(caps, discoverInfo);
        }
        return discoverInfo;
    }

    public DiscoverInfo discoverInfoNonBlocking(String entityID) throws XMPPException {
        DiscoverInfo discoverInfo = this.capsManager.getDiscoverInfoByUser(entityID);
        if (discoverInfo != null) {
            return discoverInfo;
        }
        EntityCapsManager.Caps caps = this.capsManager.getCapsByUser(entityID);
        if (!(caps != null && caps.isValid(discoverInfo) || (discoverInfo = this.nonCapsCache.get(entityID)) == null)) {
            return discoverInfo;
        }
        this.retriever.addEntityForRetrieve(entityID, caps);
        return null;
    }

    private DiscoverInfo discoverInfo(String entityID, String node) throws XMPPException {
        return this.discoveryManager.discoverInfo(entityID, node);
    }

    public DiscoverItems discoverItems(String entityID) throws XMPPException {
        return this.discoveryManager.discoverItems(entityID);
    }

    public DiscoverItems discoverItems(String entityID, String node) throws XMPPException {
        return this.discoveryManager.discoverItems(entityID, node);
    }

    public boolean supportsFeature(String jid, String feature) {
        DiscoverInfo info;
        try {
            info = this.discoverInfo(jid);
        }
        catch (XMPPException ex) {
            logger.info((Object)("failed to retrieve disco info for " + jid + " feature " + feature), (Throwable)ex);
            return false;
        }
        return info != null && info.containsFeature(feature);
    }

    public EntityCapsManager getCapsManager() {
        return this.capsManager;
    }

    public void stop() {
        if (this.retriever != null) {
            this.retriever.stop();
        }
    }

    private class DiscoveryInfoRetriever
    implements Runnable {
        private boolean stopped = true;
        private Thread retrieverThread = null;
        private Map<String, EntityCapsManager.Caps> entities = new HashMap<String, EntityCapsManager.Caps>();
        private OperationSetContactCapabilitiesJabberImpl capabilitiesOpSet;

        private DiscoveryInfoRetriever() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.stopped = false;
                while (!this.stopped) {
                    Map.Entry<String, EntityCapsManager.Caps> entityToProcess = null;
                    Map<String, EntityCapsManager.Caps> map = this.entities;
                    synchronized (map) {
                        Iterator<Map.Entry<String, EntityCapsManager.Caps>> iter;
                        if (this.entities.size() == 0) {
                            try {
                                this.entities.wait();
                            }
                            catch (InterruptedException iex) {
                                // empty catch block
                            }
                        }
                        if ((iter = this.entities.entrySet().iterator()).hasNext()) {
                            entityToProcess = iter.next();
                            iter.remove();
                        }
                    }
                    if (entityToProcess != null) {
                        this.requestDiscoveryInfo(entityToProcess.getKey(), entityToProcess.getValue());
                    }
                    entityToProcess = null;
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Error requesting discovery info, thread ended unexpectedly", t);
            }
        }

        private void requestDiscoveryInfo(String entityID, EntityCapsManager.Caps caps) {
            block7: {
                try {
                    boolean fireEvent;
                    DiscoverInfo discoverInfo = ScServiceDiscoveryManager.this.discoverInfo(entityID, caps == null ? null : caps.getNodeVer());
                    if (caps != null && !caps.isValid(discoverInfo)) {
                        if (!caps.hash.equals("")) {
                            logger.error((Object)("Invalid DiscoverInfo for " + caps.getNodeVer() + ": " + discoverInfo));
                        }
                        caps = null;
                    }
                    if (caps == null) {
                        ScServiceDiscoveryManager.this.nonCapsCache.put(entityID, discoverInfo);
                        fireEvent = true;
                    } else {
                        EntityCapsManager.addDiscoverInfoByCaps(caps, discoverInfo);
                        fireEvent = true;
                    }
                    if (fireEvent && this.capabilitiesOpSet != null) {
                        this.capabilitiesOpSet.fireContactCapabilitiesChanged(entityID);
                    }
                }
                catch (XMPPException ex) {
                    if (!logger.isTraceEnabled()) break block7;
                    logger.error((Object)("Error requesting discover info for " + entityID), (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEntityForRetrieve(String entityID, EntityCapsManager.Caps caps) {
            Map<String, EntityCapsManager.Caps> map = this.entities;
            synchronized (map) {
                if (!this.entities.containsKey(entityID)) {
                    this.entities.put(entityID, caps);
                    this.entities.notifyAll();
                    if (this.retrieverThread == null) {
                        this.start();
                    }
                }
            }
        }

        private void start() {
            this.capabilitiesOpSet = (OperationSetContactCapabilitiesJabberImpl)ScServiceDiscoveryManager.this.parentProvider.getOperationSet(OperationSetContactCapabilities.class);
            this.retrieverThread = new Thread((Runnable)this, ScServiceDiscoveryManager.class.getName());
            this.retrieverThread.setDaemon(true);
            this.retrieverThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            Map<String, EntityCapsManager.Caps> map = this.entities;
            synchronized (map) {
                this.stopped = true;
                this.entities.notifyAll();
                this.retrieverThread = null;
            }
        }
    }
}

