/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.pseudotcp;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.pseudotcp.Option;
import org.ice4j.pseudotcp.PseudoTCPBase;
import org.ice4j.pseudotcp.PseudoTcpNotify;
import org.ice4j.pseudotcp.PseudoTcpState;
import org.ice4j.pseudotcp.WriteResult;

class PseudoTcpSocketImpl
extends SocketImpl
implements PseudoTcpNotify {
    private static final Logger logger = Logger.getLogger(PseudoTcpSocketImpl.class.getName());
    private final PseudoTCPBase pseudoTcp;
    private DatagramSocket socket;
    private SocketAddress remoteAddr;
    private int DATAGRAM_RCV_BUFFER_SIZE = 8000;
    private final Object write_notify = new Object();
    private final Object read_notify = new Object();
    private final Object state_notify = new Object();
    private final Object clock_notify = new Object();
    private IOException exception;
    private long writeTimeout;
    private long readTimeout;
    private PseudoTcpInputStream inputStream;
    private PseudoTcpOutputStream outputstream;
    private Map<Integer, Object> options = new HashMap<Integer, Object>();
    private boolean runReceive = false;
    private Thread receiveThread;
    private boolean runClock = false;
    private Thread clockThread;

    public PseudoTcpSocketImpl(long conv_id, DatagramSocket sock) {
        this.pseudoTcp = new PseudoTCPBase(this, conv_id);
        this.setMTU(1450);
        this.socket = sock;
    }

    public PseudoTcpSocketImpl(long conv_id) throws SocketException {
        this(conv_id, new DatagramSocket());
    }

    public PseudoTcpSocketImpl(long conv_id, int local_port) throws SocketException {
        this(conv_id, new DatagramSocket(local_port));
    }

    public PseudoTcpSocketImpl(long conv_id, String local_ip, int local_port) throws SocketException, UnknownHostException {
        this(conv_id, new DatagramSocket(local_port, InetAddress.getByName(local_ip)));
    }

    public void setMTU(int mtu) {
        this.pseudoTcp.notifyMTU(mtu);
    }

    public int getMTU() {
        return this.pseudoTcp.getMTU();
    }

    long getConversationID() {
        return this.pseudoTcp.getConversationID();
    }

    void setConversationID(long convID) {
        this.pseudoTcp.setConversationID(convID);
    }

    public void setDebugName(String debugName) {
        this.pseudoTcp.debugName = debugName;
    }

    protected void create(boolean stream) throws IOException {
    }

    protected void connect(String host, int port) throws IOException {
        this.doConnect(new InetSocketAddress(InetAddress.getByName(host), port), 0L);
    }

    protected void connect(InetAddress address, int port) throws IOException {
        this.connect(address.getHostAddress(), port);
    }

    protected void connect(SocketAddress address, int timeout) throws IOException {
        InetSocketAddress inetAddr = (InetSocketAddress)address;
        this.doConnect(inetAddr, timeout);
    }

    public void bind(InetAddress host, int port) throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        InetSocketAddress newAddr = new InetSocketAddress(host.getHostAddress(), port);
        this.socket = new DatagramSocket(newAddr);
    }

    protected void listen(int backlog) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setOption(int optID, Object value) throws SocketException {
        this.options.put(optID, value);
    }

    public Object getOption(int optID) throws SocketException {
        if (optID == 1) {
            Object ret = this.options.get(Option.OPT_NODELAY.ordinal());
            return ret != null;
        }
        Object option = this.options.get(optID);
        if (option == null) {
            logger.warning("Asked for unknown optID" + optID);
        }
        return option;
    }

    public long getPTCPOption(Option opt) {
        if (Option.OPT_READ_TIMEOUT == opt) {
            return this.readTimeout;
        }
        if (Option.OPT_WRITE_TIMEOUT == opt) {
            return this.writeTimeout;
        }
        return this.pseudoTcp.getOption(opt);
    }

    public void setPTCPOption(Option opt, long optValue) {
        if (Option.OPT_WRITE_TIMEOUT == opt) {
            this.writeTimeout = optValue >= 0L ? optValue : 0L;
        } else if (Option.OPT_READ_TIMEOUT == opt) {
            this.readTimeout = optValue >= 0L ? optValue : 0L;
        } else {
            this.pseudoTcp.setOption(opt, optValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doConnect(InetSocketAddress remoteAddress, long timeout) throws IOException {
        logger.fine("Connecting to " + remoteAddress);
        this.remoteAddr = remoteAddress;
        this.startThreads();
        this.pseudoTcp.connect();
        this.updateClock();
        boolean noTimeout = timeout <= 0L;
        try {
            Object object = this.state_notify;
            synchronized (object) {
                long start;
                long end;
                for (long elapsed = 0L; this.pseudoTcp.getState() != PseudoTcpState.TCP_ESTABLISHED && (noTimeout || elapsed < timeout); elapsed += end - start) {
                    start = System.currentTimeMillis();
                    this.state_notify.wait(timeout);
                    end = System.currentTimeMillis();
                }
                if (this.pseudoTcp.getState() != PseudoTcpState.TCP_ESTABLISHED) {
                    throw new IOException("Connect timeout");
                }
            }
        }
        catch (InterruptedException ex) {
            this.close();
            throw new IOException("Connect aborted");
        }
    }

    void accept(SocketAddress remoteAddress, int timeout) throws IOException {
        this.remoteAddr = remoteAddress;
        this.accept(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void accept(int timeout) throws IOException {
        try {
            this.startThreads();
            PseudoTcpState state = this.pseudoTcp.getState();
            if (state == PseudoTcpState.TCP_CLOSED) {
                throw new IOException("Socket closed");
            }
            if (this.pseudoTcp.getState() != PseudoTcpState.TCP_ESTABLISHED) {
                Object object = this.state_notify;
                synchronized (object) {
                    this.state_notify.wait(timeout);
                }
            }
            if (this.pseudoTcp.getState() != PseudoTcpState.TCP_ESTABLISHED) {
                throw new IOException("Accept timeout");
            }
        }
        catch (InterruptedException ex) {
            IOException e = new IOException("Accept aborted");
            this.pseudoTcp.closedown(e);
            throw e;
        }
    }

    protected void accept(SocketImpl s) throws IOException {
        int timeout = 5000;
        this.accept(timeout);
    }

    public PseudoTcpState getState() {
        return this.pseudoTcp.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClock() {
        Object object = this.clock_notify;
        synchronized (object) {
            this.clock_notify.notifyAll();
        }
    }

    private void startThreads() {
        this.pseudoTcp.notifyClock(PseudoTCPBase.now());
        this.receiveThread = new Thread(new Runnable(){

            public void run() {
                PseudoTcpSocketImpl.this.receivePackets();
            }
        }, "PseudoTcpReceiveThread");
        this.clockThread = new Thread(new Runnable(){

            public void run() {
                PseudoTcpSocketImpl.this.runClock();
            }
        }, "PseudoTcpClockThread");
        this.runReceive = true;
        this.runClock = true;
        this.receiveThread.start();
        this.clockThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTcpOpen(PseudoTCPBase tcp) {
        logger.log(Level.FINE, "tcp opened");
        Object object = this.state_notify;
        synchronized (object) {
            this.state_notify.notifyAll();
        }
        this.onTcpWriteable(tcp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTcpReadable(PseudoTCPBase tcp) {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "TCP READABLE data available for reading: " + tcp.getAvailable());
        }
        Object object = this.read_notify;
        synchronized (object) {
            this.read_notify.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTcpWriteable(PseudoTCPBase tcp) {
        logger.log(Level.FINER, "stream writeable");
        Object object = this.write_notify;
        synchronized (object) {
            this.write_notify.notifyAll();
        }
        logger.log(Level.FINER, "write notified - now !");
    }

    public void onTcpClosed(PseudoTCPBase tcp, IOException e) {
        if (e != null) {
            logger.log(Level.SEVERE, "PseudoTcp closed: " + e);
        } else {
            logger.log(Level.FINE, "PseudoTcp closed");
        }
        this.runReceive = false;
        this.runClock = false;
        this.exception = e;
        this.releaseAllLocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAllLocks() {
        Object object = this.read_notify;
        synchronized (object) {
            this.read_notify.notifyAll();
        }
        object = this.write_notify;
        synchronized (object) {
            this.write_notify.notifyAll();
        }
        object = this.state_notify;
        synchronized (object) {
            this.state_notify.notifyAll();
        }
        this.clockThread.interrupt();
    }

    private void joinAllThreads() throws InterruptedException {
        this.clockThread.join();
        this.receiveThread.join();
    }

    public WriteResult tcpWritePacket(PseudoTCPBase tcp, byte[] buffer, int len) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "write packet to network length " + len + " address " + this.remoteAddr);
        }
        try {
            DatagramPacket packet = new DatagramPacket(buffer, len, this.remoteAddr);
            this.socket.send(packet);
            return WriteResult.WR_SUCCESS;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "TcpWritePacket exception: " + ex);
            return WriteResult.WR_FAIL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivePackets() {
        byte[] buffer = new byte[this.DATAGRAM_RCV_BUFFER_SIZE];
        DatagramPacket packet = new DatagramPacket(buffer, this.DATAGRAM_RCV_BUFFER_SIZE);
        while (this.runReceive) {
            try {
                this.socket.receive(packet);
                if (this.remoteAddr == null) {
                    this.remoteAddr = packet.getSocketAddress();
                    logger.log(Level.WARNING, "Remote addr not set previously, setting to " + this.remoteAddr);
                } else if (!packet.getSocketAddress().equals(this.remoteAddr)) {
                    logger.log(Level.WARNING, "Ignoring packet from " + packet.getAddress() + ":" + packet.getPort() + " should be: " + this.remoteAddr);
                    continue;
                }
                PseudoTCPBase pseudoTCPBase = this.pseudoTcp;
                synchronized (pseudoTCPBase) {
                    this.pseudoTcp.notifyPacket(buffer, packet.getLength());
                    this.updateClock();
                }
            }
            catch (IOException ex) {
                if (!this.runReceive) break;
                logger.log(Level.SEVERE, "ReceivePackets exception: " + ex);
                this.pseudoTcp.closedown(ex);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runClock() {
        while (this.runClock) {
            long sleep;
            Object object = this.pseudoTcp;
            synchronized (object) {
                this.pseudoTcp.notifyClock(PseudoTCPBase.now());
                sleep = this.pseudoTcp.getNextClock(PseudoTCPBase.now());
            }
            if (sleep == -1L) {
                this.releaseAllLocks();
                if (this.exception == null) break;
                logger.log(Level.SEVERE, "STATE: " + (Object)((Object)this.pseudoTcp.getState()) + " ERROR: " + this.exception.getMessage());
                break;
            }
            object = this.clock_notify;
            synchronized (object) {
                try {
                    this.clock_notify.wait(sleep);
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outputstream == null) {
            this.outputstream = new PseudoTcpOutputStream();
        }
        return this.outputstream;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new PseudoTcpInputStream();
        }
        return this.inputStream;
    }

    protected int available() throws IOException {
        return this.getInputStream().available();
    }

    public void close() throws IOException {
        try {
            this.pseudoTcp.close(true);
            this.onTcpClosed(this.pseudoTcp, null);
            this.socket.close();
            this.joinAllThreads();
        }
        catch (InterruptedException ex) {
            throw new IOException("Closing socket interrupted", ex);
        }
    }

    protected void sendUrgentData(int data) throws IOException {
        throw new RuntimeException("Sending urgent data is not supported");
    }

    protected FileDescriptor getFileDescriptor() {
        return this.fd;
    }

    protected void shutdownInput() throws IOException {
        throw new IOException("Method not implemented!");
    }

    protected void shutdownOutput() throws IOException {
        throw new IOException("Method not implemented!");
    }

    protected InetAddress getInetAddress() {
        return ((InetSocketAddress)this.remoteAddr).getAddress();
    }

    protected int getPort() {
        return ((InetSocketAddress)this.remoteAddr).getPort();
    }

    protected boolean supportsUrgentData() {
        return false;
    }

    protected int getLocalPort() {
        return this.socket.getLocalPort();
    }

    protected void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        throw new UnsupportedOperationException("setPerformancePreferences");
    }

    static /* synthetic */ long access$400(PseudoTcpSocketImpl x0) {
        return x0.readTimeout;
    }

    static /* synthetic */ Object access$500(PseudoTcpSocketImpl x0) {
        return x0.read_notify;
    }

    class PseudoTcpOutputStream
    extends OutputStream {
        PseudoTcpOutputStream() {
        }

        public void write(int b) throws IOException {
            byte[] bytes = new byte[]{(byte)b};
            this.write(bytes);
        }

        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] buffer, int offset, int length) throws IOException {
            int toSend = length;
            long start = System.currentTimeMillis();
            while (toSend > 0) {
                int sent;
                Object object = PseudoTcpSocketImpl.this.pseudoTcp;
                synchronized (object) {
                    sent = PseudoTcpSocketImpl.this.pseudoTcp.send(buffer, offset + length - toSend, toSend);
                }
                if (sent > 0) {
                    toSend -= sent;
                    continue;
                }
                try {
                    logger.log(Level.FINER, "Write wait for notify");
                    object = PseudoTcpSocketImpl.this.write_notify;
                    synchronized (object) {
                        if (PseudoTcpSocketImpl.this.writeTimeout > 0L) {
                            long elapsed = System.currentTimeMillis() - start;
                            long left = PseudoTcpSocketImpl.this.writeTimeout - elapsed;
                            if (left <= 0L) {
                                IOException exc = new IOException("Write operation timeout");
                                PseudoTcpSocketImpl.this.pseudoTcp.closedown(exc);
                                throw exc;
                            }
                            PseudoTcpSocketImpl.this.write_notify.wait(left);
                        } else {
                            PseudoTcpSocketImpl.this.write_notify.wait();
                        }
                    }
                    logger.log(Level.FINER, "Write notified, available: " + PseudoTcpSocketImpl.this.pseudoTcp.getAvailableSendBuffer());
                    if (PseudoTcpSocketImpl.this.exception == null) continue;
                    throw PseudoTcpSocketImpl.this.exception;
                }
                catch (InterruptedException ex) {
                    if (PseudoTcpSocketImpl.this.exception != null) {
                        throw new IOException("Write aborted", PseudoTcpSocketImpl.this.exception);
                    }
                    throw new IOException("Write aborted", ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void flush() throws IOException {
            Object ackNotify;
            logger.log(Level.FINE, "Flushing...");
            long start = System.currentTimeMillis();
            Object object = ackNotify = PseudoTcpSocketImpl.this.pseudoTcp.getAckNotify();
            synchronized (object) {
                while (true) {
                    if (PseudoTcpSocketImpl.this.pseudoTcp.getBytesBufferedNotSent() <= 0L) {
                        // MONITOREXIT @DISABLED, blocks:[2, 4, 7] lbl7 : MonitorExitStatement: MONITOREXIT : var4_3
                        logger.log(Level.FINE, "Flushing completed");
                        return;
                    }
                    try {
                        if (PseudoTcpSocketImpl.this.writeTimeout > 0L) {
                            long elapsed = System.currentTimeMillis() - start;
                            long left = PseudoTcpSocketImpl.this.writeTimeout - elapsed;
                            if (left <= 0L) {
                                IOException e = new IOException("Flush operation timeout");
                                PseudoTcpSocketImpl.this.pseudoTcp.closedown(e);
                                throw e;
                            }
                            ackNotify.wait(left);
                            continue;
                        }
                        ackNotify.wait();
                    }
                    catch (InterruptedException ex) {
                        throw new IOException("Flush stream interrupted", ex);
                    }
                }
            }
        }

        public void close() throws IOException {
        }
    }

    class PseudoTcpInputStream
    extends InputStream {
        public boolean markSupported() {
            return false;
        }

        public int read() throws IOException {
            byte[] buff = new byte[1];
            int readCount = this.read(buff, 0, 1);
            return readCount == 1 ? buff[0] & 0xFF : -1;
        }

        public int read(byte[] bytes) throws IOException {
            return this.read(bytes, 0, bytes.length);
        }

        /*
         * Exception decompiling
         */
        public int read(byte[] buffer, int offset, int length) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public int available() throws IOException {
            return PseudoTcpSocketImpl.this.pseudoTcp.getAvailable();
        }

        public void close() throws IOException {
        }

        public long skip(long n) throws IOException {
            throw new UnsupportedOperationException("skip");
        }

        public synchronized void mark(int readlimit) {
            throw new UnsupportedOperationException("mark");
        }

        public synchronized void reset() throws IOException {
            throw new UnsupportedOperationException("reset");
        }
    }
}

