/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.util.Arrays;
import org.ice4j.StunException;
import org.ice4j.attribute.Attribute;

public class ReservationTokenAttribute
extends Attribute {
    public static final String NAME = "RESERVATION-TOKEN";
    private byte[] reservationToken = null;

    protected ReservationTokenAttribute() {
        super('\"');
    }

    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        if (length != '\b') {
            throw new StunException("Length mismatch!");
        }
        this.reservationToken = new byte[8];
        System.arraycopy(attributeValue, offset, this.reservationToken, 0, 8);
    }

    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[12];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = 0;
        binValue[3] = 8;
        System.arraycopy(this.reservationToken, 0, binValue, 4, 8);
        return binValue;
    }

    public String getName() {
        return NAME;
    }

    public byte[] getReservationToken() {
        if (this.reservationToken == null) {
            return null;
        }
        byte[] copy = new byte[this.reservationToken.length];
        System.arraycopy(this.reservationToken, 0, copy, 0, this.reservationToken.length);
        return this.reservationToken;
    }

    public void setReservationToken(byte[] reservationToken) {
        if (reservationToken == null) {
            this.reservationToken = null;
            return;
        }
        this.reservationToken = new byte[reservationToken.length];
        System.arraycopy(reservationToken, 0, this.reservationToken, 0, reservationToken.length);
    }

    public char getDataLength() {
        return (char)this.reservationToken.length;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReservationTokenAttribute) || obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ReservationTokenAttribute att = (ReservationTokenAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.reservationToken, this.reservationToken);
    }
}

