/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.impl.neomedia.StreamRTPManager;
import org.jitsi.impl.neomedia.device.AudioMediaDeviceSession;
import org.jitsi.impl.neomedia.device.MediaDeviceSession;
import org.jitsi.impl.neomedia.transform.csrc.CsrcTransformEngine;
import org.jitsi.impl.neomedia.transform.csrc.SsrcTransformEngine;
import org.jitsi.impl.neomedia.transform.dtmf.DtmfTransformEngine;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.AudioMediaStream;
import org.jitsi.service.neomedia.DTMFInbandTone;
import org.jitsi.service.neomedia.DTMFMethod;
import org.jitsi.service.neomedia.DTMFRtpTone;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.VolumeControl;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.event.CsrcAudioLevelListener;
import org.jitsi.service.neomedia.event.DTMFListener;
import org.jitsi.service.neomedia.event.DTMFToneEvent;
import org.jitsi.service.neomedia.event.SimpleAudioLevelListener;
import org.jitsi.service.protocol.DTMFTone;
import org.jitsi.util.Logger;
import org.jitsi.util.event.PropertyChangeNotifier;

public class AudioMediaStreamImpl
extends MediaStreamImpl
implements AudioMediaStream,
PropertyChangeListener {
    private static final AudioFormat[] CUSTOM_CODEC_FORMATS = new AudioFormat[]{new AudioFormat("ALAW/rtp", 8000.0, 8, 1, -1, 1), new AudioFormat("g722/rtp", 8000.0, -1, 1)};
    private static final Logger logger = Logger.getLogger(AudioMediaStreamImpl.class);
    private final PropertyChangeNotifier audioSystemChangeNotifier;
    private CsrcAudioLevelListener csrcAudioLevelListener;
    private final List<DTMFListener> dtmfListeners = new ArrayList<DTMFListener>();
    private DtmfTransformEngine dtmfTransformEngine;
    private SimpleAudioLevelListener localUserAudioLevelListener;
    private VolumeControl outputVolumeControl;
    private SimpleAudioLevelListener streamAudioLevelListener;
    private SsrcTransformEngine ssrcTransformEngine;

    public AudioMediaStreamImpl(StreamConnector connector, MediaDevice device, SrtpControl srtpControl) {
        super(connector, device, srtpControl);
        MediaService mediaService = LibJitsi.getMediaService();
        if (mediaService instanceof PropertyChangeNotifier) {
            this.audioSystemChangeNotifier = (PropertyChangeNotifier)((Object)mediaService);
            this.audioSystemChangeNotifier.addPropertyChangeListener(this);
        } else {
            this.audioSystemChangeNotifier = null;
        }
    }

    @Override
    public void addDTMFListener(DTMFListener listener) {
        if (listener != null && !this.dtmfListeners.contains(listener)) {
            this.dtmfListeners.add(listener);
        }
    }

    @Override
    public void addRTPExtension(byte extensionID, RTPExtension rtpExtension) {
        super.addRTPExtension(extensionID, rtpExtension);
        CsrcTransformEngine csrcEngine = this.getCsrcEngine();
        SsrcTransformEngine ssrcEngine = this.ssrcTransformEngine;
        if (csrcEngine != null || ssrcEngine != null) {
            Map<Byte, RTPExtension> activeRTPExtensions = this.getActiveRTPExtensions();
            Byte csrcExtID = null;
            MediaDirection csrcDir = MediaDirection.INACTIVE;
            Byte ssrcExtID = null;
            MediaDirection ssrcDir = MediaDirection.INACTIVE;
            if (activeRTPExtensions != null && !activeRTPExtensions.isEmpty()) {
                for (Map.Entry<Byte, RTPExtension> e : activeRTPExtensions.entrySet()) {
                    RTPExtension ext = e.getValue();
                    String uri = ext.getURI().toString();
                    if ("urn:ietf:params:rtp-hdrext:csrc-audio-level".equals(uri)) {
                        csrcExtID = e.getKey();
                        csrcDir = ext.getDirection();
                        continue;
                    }
                    if (!"urn:ietf:params:rtp-hdrext:ssrc-audio-level".equals(uri)) continue;
                    ssrcExtID = e.getKey();
                    ssrcDir = ext.getDirection();
                }
            }
            if (csrcEngine != null) {
                csrcEngine.setCsrcAudioLevelExtensionID(csrcExtID == null ? (byte)-1 : (byte)csrcExtID, csrcDir);
            }
            if (ssrcEngine != null) {
                ssrcEngine.setSsrcAudioLevelExtensionID(ssrcExtID == null ? (byte)-1 : (byte)ssrcExtID, ssrcDir);
            }
        }
    }

    public void audioLevelsReceived(long[] audioLevels) {
        CsrcAudioLevelListener csrcAudioLevelListener = this.csrcAudioLevelListener;
        if (csrcAudioLevelListener != null) {
            csrcAudioLevelListener.audioLevelsReceived(audioLevels);
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.dtmfTransformEngine != null) {
            this.dtmfTransformEngine.close();
            this.dtmfTransformEngine = null;
        }
        if (this.ssrcTransformEngine != null) {
            this.ssrcTransformEngine.close();
            this.ssrcTransformEngine = null;
        }
        if (this.audioSystemChangeNotifier != null) {
            this.audioSystemChangeNotifier.removePropertyChangeListener(this);
        }
    }

    @Override
    protected void configureRTPManagerBufferControl(StreamRTPManager rtpManager, BufferControl bufferControl) {
        long minimumThreshold;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        long bufferLength = 120L;
        if (cfg != null) {
            String bufferLengthStr = cfg.getString("net.java.sip.communicator.impl.neomedia.RECEIVE_BUFFER_LENGTH");
            try {
                if (bufferLengthStr != null && bufferLengthStr.length() > 0) {
                    bufferLength = Long.parseLong(bufferLengthStr);
                }
            }
            catch (NumberFormatException nfe) {
                logger.warn(bufferLengthStr + " is not a valid receive buffer length/long value", nfe);
            }
        }
        bufferLength = bufferControl.setBufferLength(bufferLength);
        if (logger.isTraceEnabled()) {
            logger.trace("Set receiver buffer length to " + bufferLength);
        }
        bufferControl.setEnabledThreshold((minimumThreshold = bufferLength / 2L) > 0L);
        bufferControl.setMinimumThreshold(minimumThreshold);
    }

    @Override
    protected DtmfTransformEngine createDtmfTransformEngine() {
        if (this.dtmfTransformEngine == null) {
            this.dtmfTransformEngine = new DtmfTransformEngine(this);
        }
        return this.dtmfTransformEngine;
    }

    @Override
    protected SsrcTransformEngine createSsrcTransformEngine() {
        if (this.ssrcTransformEngine == null) {
            this.ssrcTransformEngine = new SsrcTransformEngine(this);
        }
        return this.ssrcTransformEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deviceSessionChanged(MediaDeviceSession oldValue, MediaDeviceSession newValue) {
        try {
            AudioMediaDeviceSession deviceSession;
            if (oldValue != null) {
                deviceSession = (AudioMediaDeviceSession)oldValue;
                if (this.localUserAudioLevelListener != null) {
                    deviceSession.setLocalUserAudioLevelListener(null);
                }
                if (this.streamAudioLevelListener != null) {
                    deviceSession.setStreamAudioLevelListener(null);
                }
            }
            if (newValue != null) {
                deviceSession = (AudioMediaDeviceSession)newValue;
                if (this.localUserAudioLevelListener != null) {
                    deviceSession.setLocalUserAudioLevelListener(this.localUserAudioLevelListener);
                }
                if (this.streamAudioLevelListener != null) {
                    deviceSession.setStreamAudioLevelListener(this.streamAudioLevelListener);
                }
                if (this.outputVolumeControl != null) {
                    deviceSession.setOutputVolumeControl(this.outputVolumeControl);
                }
            }
        }
        finally {
            super.deviceSessionChanged(oldValue, newValue);
        }
    }

    public void fireDTMFEvent(DTMFRtpTone tone, boolean end) {
        DTMFToneEvent ev = new DTMFToneEvent(this, tone);
        for (DTMFListener listener : this.dtmfListeners) {
            if (end) {
                listener.dtmfToneReceptionEnded(ev);
                continue;
            }
            listener.dtmfToneReceptionStarted(ev);
        }
    }

    @Override
    public AudioMediaDeviceSession getDeviceSession() {
        return (AudioMediaDeviceSession)super.getDeviceSession();
    }

    public int getLastMeasuredAudioLevel(long ssrc) {
        AudioMediaDeviceSession devSession = this.getDeviceSession();
        if (devSession == null) {
            return -1;
        }
        if (ssrc == this.getLocalSourceID()) {
            return devSession.getLastMeasuredLocalUserAudioLevel();
        }
        return devSession.getLastMeasuredAudioLevel(ssrc);
    }

    @Override
    protected int getPriority() {
        return 3;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (this.sendStreamsAreCreated) {
            this.recreateSendStreams();
        } else {
            this.start();
        }
    }

    @Override
    protected void registerCustomCodecFormats(StreamRTPManager rtpManager) {
        super.registerCustomCodecFormats(rtpManager);
        for (AudioFormat format : CUSTOM_CODEC_FORMATS) {
            if (logger.isDebugEnabled()) {
                logger.debug("registering format " + format + " with RTPManager");
            }
            rtpManager.addFormat(format, MediaUtils.getRTPPayloadType(format.getEncoding(), format.getSampleRate()));
        }
    }

    @Override
    public void removeDTMFListener(DTMFListener listener) {
        this.dtmfListeners.remove(listener);
    }

    @Override
    public void setCsrcAudioLevelListener(CsrcAudioLevelListener listener) {
        this.csrcAudioLevelListener = listener;
    }

    @Override
    public void setLocalUserAudioLevelListener(SimpleAudioLevelListener listener) {
        if (this.localUserAudioLevelListener != listener) {
            this.localUserAudioLevelListener = listener;
            AudioMediaDeviceSession deviceSession = this.getDeviceSession();
            if (deviceSession != null) {
                deviceSession.setLocalUserAudioLevelListener(this.localUserAudioLevelListener);
            }
        }
    }

    @Override
    public void setOutputVolumeControl(VolumeControl outputVolumeControl) {
        if (this.outputVolumeControl != outputVolumeControl) {
            this.outputVolumeControl = outputVolumeControl;
            AudioMediaDeviceSession deviceSession = this.getDeviceSession();
            if (deviceSession != null) {
                deviceSession.setOutputVolumeControl(this.outputVolumeControl);
            }
        }
    }

    @Override
    public void setStreamAudioLevelListener(SimpleAudioLevelListener listener) {
        if (this.streamAudioLevelListener != listener) {
            this.streamAudioLevelListener = listener;
            AudioMediaDeviceSession deviceSession = this.getDeviceSession();
            if (deviceSession != null) {
                deviceSession.setStreamAudioLevelListener(this.streamAudioLevelListener);
            }
        }
    }

    @Override
    public void startSendingDTMF(DTMFTone tone, DTMFMethod dtmfMethod, int minimalToneDuration, int maximalToneDuration, int volume) {
        switch (dtmfMethod) {
            case INBAND_DTMF: {
                AudioMediaDeviceSession deviceSession = this.getDeviceSession();
                if (deviceSession == null) break;
                deviceSession.addDTMF(DTMFInbandTone.mapTone(tone));
                break;
            }
            case RTP_DTMF: {
                DTMFRtpTone t;
                if (this.dtmfTransformEngine == null || (t = DTMFRtpTone.mapTone(tone)) == null) break;
                this.dtmfTransformEngine.startSending(t, minimalToneDuration, maximalToneDuration, volume);
                break;
            }
            case SIP_INFO_DTMF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("dtmfMethod");
            }
        }
    }

    @Override
    public void stopSendingDTMF(DTMFMethod dtmfMethod) {
        switch (dtmfMethod) {
            case INBAND_DTMF: {
                break;
            }
            case RTP_DTMF: {
                if (this.dtmfTransformEngine == null) break;
                this.dtmfTransformEngine.stopSendingDTMF();
                break;
            }
            case SIP_INFO_DTMF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("dtmfMethod");
            }
        }
    }
}

