/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.util.Vector;
import javax.media.protocol.DataSource;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceptionStats;
import javax.media.rtp.rtcp.Feedback;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SenderReport;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;

public class RecvSSRCInfo
extends SSRCInfo
implements ReceiveStream,
SenderReport {
    RecvSSRCInfo(SSRCCache cache, int ssrc) {
        super(cache, ssrc);
    }

    RecvSSRCInfo(SSRCInfo info) {
        super(info);
    }

    public DataSource getDataSource() {
        return this.dsource;
    }

    public long getNTPTimeStampLSW() {
        return this.lastSRntptimestamp & 0xFFFFFFFFL;
    }

    public long getNTPTimeStampMSW() {
        return this.lastSRntptimestamp >> 32 & 0xFFFFFFFFL;
    }

    public Participant getParticipant() {
        SSRCCache cache = this.getSSRCCache();
        if (this.sourceInfo instanceof LocalParticipant && cache.sm.IsNonParticipating()) {
            return null;
        }
        return this.sourceInfo;
    }

    public long getRTPTimeStamp() {
        return this.lastSRrtptimestamp;
    }

    public long getSenderByteCount() {
        return this.lastSRoctetcount;
    }

    public Feedback getSenderFeedback() {
        SSRCCache cache = this.getSSRCCache();
        Report report = null;
        Vector reports = null;
        Vector feedback = null;
        Feedback reportblk = null;
        try {
            LocalParticipant localpartc = cache.sm.getLocalParticipant();
            reports = localpartc.getReports();
            for (int i = 0; i < reports.size(); ++i) {
                report = (Report)reports.elementAt(i);
                feedback = report.getFeedbackReports();
                for (int j = 0; j < feedback.size(); ++j) {
                    reportblk = (Feedback)feedback.elementAt(j);
                    long ssrc = reportblk.getSSRC();
                    if (ssrc != this.getSSRC()) continue;
                    return reportblk;
                }
            }
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public long getSenderPacketCount() {
        return this.lastSRpacketcount;
    }

    public SenderReport getSenderReport() {
        return this;
    }

    public ReceptionStats getSourceReceptionStats() {
        return this.stats;
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public RTPStream getStream() {
        return this;
    }
}

