/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.core.Member;
import com.hazelcast.core.MigrationListener;
import com.hazelcast.core.Partition;
import com.hazelcast.core.PartitionService;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.PartitionServiceImpl;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PartitionServiceProxy
implements PartitionService {
    private final PartitionServiceImpl partitionService;
    private final ConcurrentMap<Integer, PartitionProxy> mapPartitions = new ConcurrentHashMap<Integer, PartitionProxy>();
    private final Set<Partition> partitions = new TreeSet<Partition>();
    private final Random random = new Random();

    public PartitionServiceProxy(PartitionServiceImpl partitionService) {
        this.partitionService = partitionService;
        for (int i = 0; i < partitionService.getPartitionCount(); ++i) {
            PartitionProxy partitionProxy = new PartitionProxy(i);
            this.partitions.add(partitionProxy);
            this.mapPartitions.put(i, partitionProxy);
        }
    }

    @Override
    public String randomPartitionKey() {
        return Integer.toString(this.random.nextInt(this.partitionService.getPartitionCount()));
    }

    @Override
    public Set<Partition> getPartitions() {
        return this.partitions;
    }

    @Override
    public PartitionProxy getPartition(Object key) {
        int partitionId = this.partitionService.getPartitionId(key);
        return this.getPartition(partitionId);
    }

    @Override
    public String addMigrationListener(MigrationListener migrationListener) {
        return this.partitionService.addMigrationListener(migrationListener);
    }

    @Override
    public boolean removeMigrationListener(String registrationId) {
        return this.partitionService.removeMigrationListener(registrationId);
    }

    public PartitionProxy getPartition(int partitionId) {
        return (PartitionProxy)this.mapPartitions.get(partitionId);
    }

    public class PartitionProxy
    implements Partition,
    Comparable {
        final int partitionId;

        PartitionProxy(int partitionId) {
            this.partitionId = partitionId;
        }

        @Override
        public int getPartitionId() {
            return this.partitionId;
        }

        @Override
        public Member getOwner() {
            Address address = PartitionServiceProxy.this.partitionService.getPartitionOwner(this.partitionId);
            if (address != null) {
                return PartitionServiceProxy.this.partitionService.getMember(address);
            }
            return null;
        }

        public int compareTo(Object o) {
            PartitionProxy partition = (PartitionProxy)o;
            Integer id = this.partitionId;
            return id.compareTo(partition.getPartitionId());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionProxy partition = (PartitionProxy)o;
            return this.partitionId == partition.partitionId;
        }

        public int hashCode() {
            return this.partitionId;
        }

        public String toString() {
            return "Partition [" + this.partitionId + "], owner=" + this.getOwner();
        }
    }
}

