/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.multimap.MultiMapContainer;
import com.hazelcast.multimap.MultiMapRecord;
import com.hazelcast.multimap.operations.MultiMapBackupAwareOperation;
import com.hazelcast.multimap.operations.PutBackupOperation;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class PutOperation
extends MultiMapBackupAwareOperation {
    Data value;
    int index = -1;
    transient long begin = -1L;
    transient long recordId;

    public PutOperation() {
    }

    public PutOperation(String name, Data dataKey, int threadId, Data value, int index) {
        super(name, dataKey, threadId);
        this.value = value;
        this.index = index;
    }

    @Override
    public void run() throws Exception {
        this.begin = Clock.currentTimeMillis();
        MultiMapContainer container = this.getOrCreateContainer();
        this.recordId = container.nextId();
        MultiMapRecord record = new MultiMapRecord(this.recordId, this.isBinary() ? this.value : this.toObject(this.value));
        Collection<MultiMapRecord> coll = container.getOrCreateMultiMapWrapper(this.dataKey).getCollection(false);
        if (this.index == -1) {
            this.response = coll.add(record);
        } else {
            try {
                ((List)coll).add(this.index, record);
                this.response = true;
            }
            catch (IndexOutOfBoundsException e) {
                this.response = e;
            }
        }
    }

    @Override
    public void afterRun() throws Exception {
        long elapsed = Math.max(0L, Clock.currentTimeMillis() - this.begin);
        if (Boolean.TRUE.equals(this.response)) {
            this.publishEvent(EntryEventType.ADDED, this.dataKey, this.value);
        }
    }

    @Override
    public Operation getBackupOperation() {
        return new PutBackupOperation(this.name, this.dataKey, this.value, this.recordId, this.index);
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(false);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.index);
        this.value.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.index = in.readInt();
        this.value = IOUtil.readData(in);
    }

    @Override
    public int getId() {
        return 16;
    }
}

