/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stunclient;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.AbstractResponseCollector;
import org.ice4j.BaseStunMessageEvent;
import org.ice4j.ResponseCollector;
import org.ice4j.StunException;
import org.ice4j.StunMessageEvent;
import org.ice4j.StunResponseEvent;
import org.ice4j.TransportAddress;
import org.ice4j.message.Request;
import org.ice4j.stack.StunStack;

class BlockingRequestSender
extends AbstractResponseCollector {
    private static final Logger logger = Logger.getLogger(BlockingRequestSender.class.getName());
    private final StunStack stunStack;
    private final TransportAddress localAddress;
    private StunMessageEvent responseEvent = null;
    private boolean ended = false;
    private final Object sendLock = new Object();

    BlockingRequestSender(StunStack stunStack, TransportAddress localAddress) {
        this.stunStack = stunStack;
        this.localAddress = localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void processFailure(BaseStunMessageEvent event) {
        Object object = this.sendLock;
        synchronized (object) {
            this.ended = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processResponse(StunResponseEvent evt) {
        Object object = this.sendLock;
        synchronized (object) {
            this.responseEvent = evt;
            this.ended = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StunMessageEvent sendRequestAndWaitForResponse(Request request, TransportAddress serverAddress) throws StunException, IOException {
        Object object = this.sendLock;
        synchronized (object) {
            this.stunStack.sendRequest(request, serverAddress, this.localAddress, (ResponseCollector)this);
        }
        this.ended = false;
        while (!this.ended) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                logger.log(Level.WARNING, "Interrupted", ex);
            }
        }
        StunMessageEvent res = this.responseEvent;
        this.responseEvent = null;
        return res;
    }
}

