/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stack;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.ice4j.AbstractResponseCollector;
import org.ice4j.BaseStunMessageEvent;
import org.ice4j.MsgFixture;
import org.ice4j.ResponseCollector;
import org.ice4j.StunFailureEvent;
import org.ice4j.StunMessageEvent;
import org.ice4j.StunResponseEvent;
import org.ice4j.StunTimeoutEvent;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceUdpSocketWrapper;
import org.ice4j.socket.SafeCloseDatagramSocket;
import org.ice4j.stack.DatagramCollector;
import org.ice4j.stack.RequestListener;
import org.ice4j.stack.StunStack;

public class ShallowStackTest
extends TestCase {
    private static final Logger logger = Logger.getLogger(ShallowStackTest.class.getName());
    private StunStack stunStack;
    private MsgFixture msgFixture = null;
    private TransportAddress dummyServerAddress = null;
    private TransportAddress localAddress = null;
    private DatagramCollector dgramCollector = new DatagramCollector();
    private IceSocketWrapper localSock = null;
    private DatagramSocket dummyServerSocket = null;

    public ShallowStackTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.msgFixture = new MsgFixture();
        this.msgFixture.setUp();
        this.dummyServerAddress = new TransportAddress("127.0.0.1", 6004, Transport.UDP);
        this.localAddress = new TransportAddress("127.0.0.1", 5004, Transport.UDP);
        this.stunStack = new StunStack();
        this.localSock = new IceUdpSocketWrapper(new SafeCloseDatagramSocket(this.localAddress));
        this.stunStack.addSocket(this.localSock);
        this.dummyServerSocket = new DatagramSocket(this.dummyServerAddress);
    }

    protected void tearDown() throws Exception {
        this.stunStack.removeSocket(this.localAddress);
        this.localSock.close();
        this.dummyServerSocket.close();
        this.msgFixture.tearDown();
        this.msgFixture = null;
        super.tearDown();
    }

    public void testSendRequest() throws Exception {
        Request bindingRequest = MessageFactory.createBindingRequest();
        this.dgramCollector.startListening(this.dummyServerSocket);
        this.stunStack.sendRequest(bindingRequest, this.dummyServerAddress, this.localAddress, (ResponseCollector)new SimpleResponseCollector());
        this.dgramCollector.waitForPacket();
        DatagramPacket receivedPacket = this.dgramCollector.collectPacket();
        ShallowStackTest.assertTrue((String)"The stack did not properly send a Binding Request", (receivedPacket.getLength() > 0 ? 1 : 0) != 0);
        Request receivedRequest = (Request)Request.decode(receivedPacket.getData(), '\u0000', (char)receivedPacket.getLength());
        ShallowStackTest.assertEquals((String)"The received request did not match the one that was sent.", (Object)bindingRequest, (Object)receivedRequest);
        this.dgramCollector.startListening(this.dummyServerSocket);
        this.dgramCollector.waitForPacket();
        receivedPacket = this.dgramCollector.collectPacket();
        ShallowStackTest.assertTrue((String)"The stack did not retransmit a Binding Request", (receivedPacket.getLength() > 0 ? 1 : 0) != 0);
        receivedRequest = (Request)Request.decode(receivedPacket.getData(), '\u0000', (char)receivedPacket.getLength());
        ShallowStackTest.assertEquals((String)"The retransmitted request did not match the original.", (Object)bindingRequest, (Object)receivedRequest);
    }

    public void testReceiveRequest() throws Exception {
        SimpleRequestCollector requestCollector = new SimpleRequestCollector();
        this.stunStack.addRequestListener(requestCollector);
        this.dummyServerSocket.send(new DatagramPacket(this.msgFixture.bindingRequest2, this.msgFixture.bindingRequest2.length, this.localAddress));
        requestCollector.waitForRequest();
        Request collectedRequest = requestCollector.collectedRequest;
        ShallowStackTest.assertNotNull((String)"No request has been received", (Object)collectedRequest);
        byte[] expectedReturn = this.msgFixture.bindingRequest2;
        byte[] actualReturn = collectedRequest.encode(this.stunStack);
        ShallowStackTest.assertTrue((String)"Received request was not the same as the one that was sent", (boolean)Arrays.equals(expectedReturn, actualReturn));
    }

    public void testSendResponse() throws Exception {
        SimpleRequestCollector requestCollector = new SimpleRequestCollector();
        this.stunStack.addRequestListener(requestCollector);
        this.dummyServerSocket.send(new DatagramPacket(this.msgFixture.bindingRequest, this.msgFixture.bindingRequest.length, this.localAddress));
        requestCollector.waitForRequest();
        Request collectedRequest = requestCollector.collectedRequest;
        byte[] expectedReturn = this.msgFixture.bindingRequest;
        byte[] actualReturn = collectedRequest.encode(this.stunStack);
        ShallowStackTest.assertTrue((String)"Received request was not the same as the one that was sent", (boolean)Arrays.equals(expectedReturn, actualReturn));
        Response bindingResponse = MessageFactory.create3489BindingResponse(new TransportAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS, 1904, Transport.UDP), new TransportAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_2, 3478, Transport.UDP), new TransportAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_3, 3479, Transport.UDP));
        this.dgramCollector.startListening(this.dummyServerSocket);
        this.stunStack.sendResponse(collectedRequest.getTransactionID(), bindingResponse, this.localAddress, this.dummyServerAddress);
        this.dgramCollector.waitForPacket();
        DatagramPacket receivedPacket = this.dgramCollector.collectPacket();
        ShallowStackTest.assertTrue((String)"The stack did not properly send a Binding Request", (receivedPacket.getLength() > 0 ? 1 : 0) != 0);
        Response receivedResponse = (Response)Response.decode(receivedPacket.getData(), '\u0000', (char)receivedPacket.getLength());
        ShallowStackTest.assertEquals((String)"The received request did not match the one that was sent.", (Object)bindingResponse, (Object)receivedResponse);
    }

    public void testReceiveResponse() throws Exception {
        SimpleResponseCollector collector = new SimpleResponseCollector();
        Request bindingRequest = MessageFactory.createBindingRequest();
        this.stunStack.sendRequest(bindingRequest, this.dummyServerAddress, this.localAddress, (ResponseCollector)collector);
        collector.waitForResponse();
        byte[] response = new byte[this.msgFixture.bindingResponse.length];
        System.arraycopy(this.msgFixture.bindingResponse, 0, response, 0, response.length);
        System.arraycopy(bindingRequest.getTransactionID(), 0, response, 8, 12);
        this.dummyServerSocket.send(new DatagramPacket(response, response.length, this.localAddress));
        collector.waitForResponse();
        Response collectedResponse = collector.collectedResponse;
        byte[] expectedReturn = response;
        byte[] actualReturn = collectedResponse.encode(this.stunStack);
        ShallowStackTest.assertTrue((String)"Received request was not the same as the one that was sent", (boolean)Arrays.equals(expectedReturn, actualReturn));
    }

    public class SimpleRequestCollector
    implements RequestListener {
        private Request collectedRequest = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processRequest(StunMessageEvent evt) {
            SimpleRequestCollector simpleRequestCollector = this;
            synchronized (simpleRequestCollector) {
                this.collectedRequest = (Request)evt.getMessage();
                ShallowStackTest.this.stunStack.removeRequestListener(this);
                logger.finest("Received request.");
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForRequest() {
            SimpleRequestCollector simpleRequestCollector = this;
            synchronized (simpleRequestCollector) {
                if (this.collectedRequest != null) {
                    return;
                }
                try {
                    this.wait(50L);
                }
                catch (InterruptedException e) {
                    logger.log(Level.INFO, "oops", e);
                }
            }
        }
    }

    public static class SimpleResponseCollector
    extends AbstractResponseCollector {
        Response collectedResponse = null;

        protected synchronized void processFailure(BaseStunMessageEvent event) {
            String msg = event instanceof StunFailureEvent ? "Unreachable" : (event instanceof StunTimeoutEvent ? "Timeout" : "Failure");
            logger.info(msg);
            this.notifyAll();
        }

        public synchronized void processResponse(StunResponseEvent response) {
            this.collectedResponse = (Response)response.getMessage();
            logger.finest("Received response.");
            this.notifyAll();
        }

        public synchronized void waitForResponse() {
            try {
                if (this.collectedResponse == null) {
                    this.wait(50L);
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.INFO, "oops", e);
            }
        }
    }
}

