/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.ice4j.ResponseCollector;
import org.ice4j.StunMessageEvent;
import org.ice4j.StunResponseEvent;
import org.ice4j.StunTimeoutEvent;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.DataAttribute;
import org.ice4j.attribute.XorPeerAddressAttribute;
import org.ice4j.ice.harvest.GoogleTurnCandidateHarvest;
import org.ice4j.message.Message;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.socket.GoogleRelayedCandidateDatagramSocket;
import org.ice4j.socket.MultiplexingDatagramSocket;
import org.ice4j.stack.MessageEventHandler;
import org.ice4j.stack.TransactionID;

public class GoogleRelayedCandidateDelegate
implements MessageEventHandler,
ResponseCollector {
    private static final Logger logger = Logger.getLogger(GoogleRelayedCandidateDelegate.class.getName());
    private boolean closed = false;
    private final List<DatagramPacket> packetsToReceive = new LinkedList<DatagramPacket>();
    private final List<DatagramPacket> packetsToSend = new LinkedList<DatagramPacket>();
    private Thread sendThread;
    private final GoogleTurnCandidateHarvest turnCandidateHarvest;
    private final String username;

    public GoogleRelayedCandidateDelegate(GoogleTurnCandidateHarvest turnCandidateHarvest, String username) throws SocketException {
        this.turnCandidateHarvest = turnCandidateHarvest;
        this.username = username;
        this.turnCandidateHarvest.harvester.getStunStack().addOldIndicationListener(this.turnCandidateHarvest.hostCandidate.getTransportAddress(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<DatagramPacket> list = this;
        synchronized (list) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        list = this.packetsToReceive;
        synchronized (list) {
            this.packetsToReceive.notifyAll();
        }
        list = this.packetsToSend;
        synchronized (list) {
            this.packetsToSend.notifyAll();
        }
        this.turnCandidateHarvest.harvester.getStunStack().removeIndicationListener(this.turnCandidateHarvest.hostCandidate.getTransportAddress(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessageEvent(StunMessageEvent e) {
        DatagramPacket packetToReceive;
        Message message = e.getMessage();
        char messageType = message.getMessageType();
        if (messageType != '\u0115') {
            return;
        }
        if (!this.turnCandidateHarvest.hostCandidate.getTransportAddress().equals(e.getLocalAddress())) {
            return;
        }
        if (!this.turnCandidateHarvest.harvester.stunServer.equals(e.getRemoteAddress())) {
            return;
        }
        logger.finest("handle old DATA Indication");
        XorPeerAddressAttribute peerAddressAttribute = (XorPeerAddressAttribute)message.getAttribute('\u0012');
        if (peerAddressAttribute == null) {
            logger.info("peerAddressAttribute is null");
            return;
        }
        DataAttribute dataAttribute = (DataAttribute)message.getAttribute('\u0013');
        if (dataAttribute == null) {
            logger.info("data is null");
            return;
        }
        TransportAddress peerAddress = peerAddressAttribute.getAddress();
        if (peerAddress == null) {
            return;
        }
        byte[] data = dataAttribute.getData();
        if (data == null) {
            return;
        }
        try {
            packetToReceive = new DatagramPacket(data, 0, data.length, peerAddress);
        }
        catch (SocketException sex) {
            packetToReceive = null;
        }
        if (packetToReceive != null) {
            List<DatagramPacket> list = this.packetsToReceive;
            synchronized (list) {
                this.packetsToReceive.add(packetToReceive);
                this.packetsToReceive.notifyAll();
            }
        }
    }

    public boolean processErrorOrFailure(Response response, Request request) {
        return false;
    }

    public void processSuccess(Response response, Request request) {
    }

    public void processResponse(StunResponseEvent response) {
    }

    public void processTimeout(StunTimeoutEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(DatagramPacket p) throws IOException {
        List<DatagramPacket> list = this.packetsToReceive;
        synchronized (list) {
            while (true) {
                if (this.closed) {
                    throw new SocketException(GoogleRelayedCandidateDatagramSocket.class.getSimpleName() + " has been closed.");
                }
                if (!this.packetsToReceive.isEmpty()) break;
                try {
                    this.packetsToReceive.wait();
                }
                catch (InterruptedException iex) {}
            }
            DatagramPacket packetToReceive = this.packetsToReceive.remove(0);
            MultiplexingDatagramSocket.copy(packetToReceive, p);
            this.packetsToReceive.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(DatagramPacket p) throws IOException {
        List<DatagramPacket> list = this.packetsToSend;
        synchronized (list) {
            if (this.closed) {
                throw new IOException(GoogleRelayedCandidateDatagramSocket.class.getSimpleName() + " has been closed.");
            }
            this.packetsToSend.add(MultiplexingDatagramSocket.clone(p));
            if (this.sendThread == null) {
                this.createSendThread();
            } else {
                this.packetsToSend.notifyAll();
            }
        }
    }

    private void createSendThread() {
        this.sendThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    GoogleRelayedCandidateDelegate.this.runInSendThread();
                }
                finally {
                    List list = GoogleRelayedCandidateDelegate.this.packetsToSend;
                    synchronized (list) {
                        if (GoogleRelayedCandidateDelegate.this.sendThread == Thread.currentThread()) {
                            GoogleRelayedCandidateDelegate.this.sendThread = null;
                        }
                        if (GoogleRelayedCandidateDelegate.this.sendThread == null && !GoogleRelayedCandidateDelegate.this.closed && !GoogleRelayedCandidateDelegate.this.packetsToSend.isEmpty()) {
                            GoogleRelayedCandidateDelegate.this.createSendThread();
                        }
                    }
                }
            }
        };
        this.sendThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runInSendThread() {
        List<DatagramPacket> list = this.packetsToSend;
        synchronized (list) {
            while (!this.closed) {
                if (this.packetsToSend.isEmpty()) {
                    try {
                        this.packetsToSend.wait();
                    }
                    catch (InterruptedException iex) {}
                    continue;
                }
                int packetToSendCount = this.packetsToSend.size();
                for (int packetToSendIndex = 0; packetToSendIndex < packetToSendCount; ++packetToSendIndex) {
                    byte[] data;
                    DatagramPacket packetToSend = this.packetsToSend.remove(0);
                    TransportAddress peerAddress = new TransportAddress(packetToSend.getAddress(), packetToSend.getPort(), Transport.UDP);
                    byte[] pData = packetToSend.getData();
                    int pOffset = packetToSend.getOffset();
                    int pLength = packetToSend.getLength();
                    if (pOffset == 0 && pLength == pData.length) {
                        data = pData;
                    } else {
                        data = new byte[pLength];
                        System.arraycopy(pData, pOffset, data, 0, pLength);
                    }
                    byte[] transactionID = TransactionID.createNewTransactionID().getBytes();
                    Request sendRequest = MessageFactory.createSendRequest(this.username, peerAddress, data);
                    try {
                        sendRequest.setTransactionID(transactionID);
                        this.turnCandidateHarvest.harvester.getStunStack().sendRequest(sendRequest, this.turnCandidateHarvest.harvester.stunServer, this.turnCandidateHarvest.hostCandidate.getTransportAddress(), (ResponseCollector)this);
                        continue;
                    }
                    catch (Exception e) {
                        logger.fine("Failed to send TURN Send request: " + e);
                    }
                }
                if (this.packetsToSend.size() != packetToSendCount) continue;
                try {
                    this.packetsToSend.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
    }
}

