/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.MigrationCycleOperation;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.Collection;

final class PromoteFromBackupOperation
extends AbstractOperation
implements PartitionAwareOperation,
MigrationCycleOperation {
    PromoteFromBackupOperation() {
    }

    @Override
    public void run() throws Exception {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Collection<MigrationAwareService> services = nodeEngine.getServices(MigrationAwareService.class);
        int partitionId = this.getPartitionId();
        PartitionMigrationEvent event = new PartitionMigrationEvent(MigrationEndpoint.DESTINATION, partitionId);
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Promoting partition " + partitionId);
        }
        for (MigrationAwareService service : services) {
            try {
                service.beforeMigration(event);
                service.commitMigration(event);
            }
            catch (Exception e) {
                logger.warning("While promoting partition " + partitionId, e);
            }
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }
}

