/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.vp8;

import javax.media.Buffer;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.util.Logger;

public class DePacketizer
extends AbstractCodec2 {
    private static final int BUFFER_SIZE = 100000;
    private static final Logger logger = Logger.getLogger(DePacketizer.class);
    private static final boolean TRACE = false;
    private byte[] buffer = new byte[100000];
    private int bufferPointer = 0;
    private boolean haveSent = false;
    private boolean waitForNewStart = false;

    public DePacketizer() {
        super("VP8  RTP DePacketizer", VideoFormat.class, new VideoFormat[]{new VideoFormat("VP8")});
        this.inputFormats = new VideoFormat[]{new VideoFormat("VP8/rtp")};
    }

    @Override
    protected void doClose() {
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        if (logger.isTraceEnabled()) {
            logger.trace("Opened VP8 de-packetizer");
        }
    }

    @Override
    protected int doProcess(Buffer inBuffer, Buffer outBuffer) {
        int ret;
        int pdSize;
        byte[] in = (byte[])inBuffer.getData();
        boolean start = VP8PayloadDescriptor.isStartOfPartition(in, inBuffer.getOffset());
        if (this.waitForNewStart) {
            if (start) {
                this.waitForNewStart = false;
            } else {
                outBuffer.setDiscard(true);
                return 0;
            }
        }
        try {
            pdSize = VP8PayloadDescriptor.getSize(in, inBuffer.getOffset());
        }
        catch (Exception e) {
            outBuffer.setDiscard(true);
            return 1;
        }
        if (start && this.haveSent) {
            if (logger.isTraceEnabled()) {
                logger.trace("Sending a frame, size=" + this.bufferPointer);
            }
            byte[] out = DePacketizer.validateByteArraySize(outBuffer, this.bufferPointer, false);
            System.arraycopy(this.buffer, 0, out, 0, this.bufferPointer);
            outBuffer.setFormat(new VideoFormat("VP8"));
            outBuffer.setLength(this.bufferPointer);
            outBuffer.setOffset(0);
            this.bufferPointer = 0;
            ret = 0;
        } else {
            ret = 4;
        }
        int len = inBuffer.getLength();
        if (this.bufferPointer + len - pdSize >= 100000) {
            this.bufferPointer = 0;
            outBuffer.setDiscard(true);
            this.waitForNewStart = true;
            return 1;
        }
        System.arraycopy(in, inBuffer.getOffset() + pdSize, this.buffer, this.bufferPointer, len - pdSize);
        this.bufferPointer += len - pdSize;
        this.haveSent = true;
        return ret;
    }

    static class VP8PayloadDescriptor {
        private static final byte I_BIT = -128;
        private static final byte K_BIT = 16;
        private static final byte L_BIT = 64;
        private static final byte M_BIT = -128;
        public static final int MAX_LENGTH = 6;
        private static final byte S_BIT = 16;
        private static final byte T_BIT = 32;
        private static final byte X_BIT = -128;

        VP8PayloadDescriptor() {
        }

        public static byte[] create(boolean startOfPartition) {
            byte[] pd = new byte[]{startOfPartition ? (byte)16 : 0};
            return pd;
        }

        public static int getSize(byte[] input, int offset) throws Exception {
            if (input.length < offset + 1) {
                throw new Exception("Invalid VP8 Payload Descriptor");
            }
            if ((input[offset] & 0xFFFFFF80) == 0) {
                return 1;
            }
            int size = 1;
            if ((input[offset + 1] & 0xFFFFFF80) != 0) {
                ++size;
                if ((input[offset + 2] & 0xFFFFFF80) != 0) {
                    ++size;
                }
            }
            if ((input[offset + 1] & 0x40) != 0) {
                ++size;
            }
            if ((input[offset + 1] & 0x30) != 0) {
                ++size;
            }
            return size;
        }

        public static boolean isStartOfPartition(byte[] input, int offset) {
            return (input[offset] & 0x10) != 0;
        }
    }
}

