/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp.util;

import java.io.IOException;
import java.util.Vector;
import javax.media.rtp.SessionAddress;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketConsumer;
import net.sf.fmj.media.rtp.util.PacketSource;
import net.sf.fmj.media.rtp.util.UDPPacket;

public abstract class PacketFilter
implements PacketSource,
PacketConsumer {
    PacketSource source;
    PacketConsumer consumer;
    public Vector destAddressList = null;
    public Vector peerlist = null;
    public boolean control = false;

    public void close() {
    }

    public void closeConsumer() {
        this.close();
        if (this.consumer != null) {
            this.consumer.closeConsumer();
        }
    }

    public void closeSource() {
        this.close();
        if (this.source != null) {
            this.source.closeSource();
        }
    }

    public String consumerString() {
        if (this.consumer == null) {
            return this.filtername();
        }
        return this.filtername() + " connected to " + this.consumer.consumerString();
    }

    public String filtername() {
        return this.getClass().getName();
    }

    public PacketConsumer getConsumer() {
        return this.consumer;
    }

    public Vector getDestList() {
        return null;
    }

    public PacketSource getSource() {
        return this.source;
    }

    public abstract Packet handlePacket(Packet var1);

    public abstract Packet handlePacket(Packet var1, int var2);

    public abstract Packet handlePacket(Packet var1, SessionAddress var2);

    public Packet receiveFrom() throws IOException {
        Packet p = null;
        Packet rawp = this.source.receiveFrom();
        if (rawp != null) {
            p = this.handlePacket(rawp);
        }
        return p;
    }

    public void sendTo(Packet p) throws IOException {
        Packet origpacket = p;
        if (this.peerlist != null) {
            p = this.handlePacket(origpacket);
            for (int i = 0; i < this.peerlist.size(); ++i) {
                SessionAddress a = (SessionAddress)this.peerlist.elementAt(i);
                if (!this.control) {
                    ((UDPPacket)p).remoteAddress = a.getDataAddress();
                    ((UDPPacket)p).remotePort = a.getDataPort();
                } else {
                    ((UDPPacket)p).remoteAddress = a.getControlAddress();
                    ((UDPPacket)p).remotePort = a.getControlPort();
                }
                if (p == null || this.consumer == null) continue;
                this.consumer.sendTo(p);
            }
        } else if (this.destAddressList != null) {
            for (int i = 0; i < this.destAddressList.size(); ++i) {
                SessionAddress sa = (SessionAddress)this.destAddressList.elementAt(i);
                p = this.handlePacket(origpacket, sa);
                if (p == null || this.consumer == null) continue;
                this.consumer.sendTo(p);
            }
        } else if (this.destAddressList == null && (p = this.handlePacket(p)) != null && this.consumer != null) {
            this.consumer.sendTo(p);
        }
    }

    public void setConsumer(PacketConsumer c) {
        this.consumer = c;
    }

    public void setSource(PacketSource s) {
        this.source = s;
    }

    public String sourceString() {
        if (this.source == null) {
            return this.filtername();
        }
        return this.filtername() + " attached to " + this.source.sourceString();
    }
}

